/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<math.h>
#include	"gbgraph.h"

int
get_rol(AFFEN2D * m,
	GB_POINT s1,GB_POINT d1,
	GB_POINT s2,GB_POINT d2)
{
GB_POINT s,d;
REAL1 r1,r2;
REAL1 e;
	s = p_sub(s1,s2);
	d = p_sub(d1,d2);
	e = s.x*s.x + s.y*s.y;
	if ( e == 0 )
		return -1;
	r1 = (d.x*s.x + d.y*s.y)/e;
	r2 = (d.y*s.x - d.x*s.y)/e;
	m->matrix[0][0] = m->matrix[1][1] = r1;
	m->matrix[0][1] = -r2;
	m->matrix[1][0] = r2;
	m->org = p_sub(d1,mp_mul(m->matrix,s1));
	return 0;
}

int
get_matrix(AFFEN2D * m,
	GB_POINT s1,GB_POINT d1,
	GB_POINT s2,GB_POINT d2,
	GB_POINT s3,GB_POINT d3)
{
GB_POINT ss1,dd1;
GB_POINT ss2,dd2;
REAL1 t;


	ss1 = p_sub(s1,s2);
	ss2 = p_sub(s1,s3);
	dd1 = p_sub(d1,d2);
	dd2 = p_sub(d1,d3);
	t = ss1.x*ss2.y - ss2.x*ss1.y;
	if ( t == 0 )
		return -1;
	m->matrix[0][0] =
		(ss2.y*dd1.x - ss1.y*dd2.x)/t;
	m->matrix[0][1] =
		(ss1.x*dd2.x - ss2.x*dd1.x)/t;
	t = ss1.x*ss2.y - ss2.x*ss1.y;
	if ( t == 0 )
		return -1;
	m->matrix[1][0] =
		(ss2.y*dd1.y - ss1.y*dd2.y)/t;
	m->matrix[1][1] =
		(ss1.x*dd2.y - ss2.x*dd1.y)/t;
	m->org = p_sub(d1,mp_mul(m->matrix,s1));
	return 0;
}



REAL1
puseudo_rate(REAL1 m[2][2])
{
GB_POINT p;
REAL1 rr,r,a;
	p.x = 0;
	p.y = 1;
	p = mp_mul(m,p);
	rr = a = p.x*p.x + p.y*p.y;

	p.x = 1;
	p.y = 1;
	p = mp_mul(m,p);
	r = a = (p.x*p.x + p.y*p.y)/2;
	rr += r;

	p.x = 1;
	p.y = 0;
	p = mp_mul(m,p);
	r = a = (p.x*p.x + p.y*p.y);
	rr += r;

	p.x = 1;
	p.y = -1;
	p = mp_mul(m,p);
	r = a = (p.x*p.x + p.y*p.y)/2;
	rr += r;

	return sqrt(rr)/2;
}
