/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include "memory_debug.h"
#include "xl.h"
#include "server_work.h"
#include "stream.h"

XL_SEXP *
get_swork(char * filename)
{
extern L_CHAR * sys_path;
char * buf;
int slen,flen,wlen;
STREAM * st;
	slen = l_strlen(sys_path);
	flen = strlen(filename);
	wlen = strlen(SWORK_DIR);
	buf = d_alloc((slen+flen+wlen+10)*sizeof(L_CHAR),1);
	sprintf(buf,"%s%s",
		n_string(std_cm,sys_path),
		SWORK_DIR);
	u_mkdir(buf,0755);
	chmod(buf,0755);
	sprintf(buf,"%s%s/%s",
		n_string(std_cm,sys_path),
		SWORK_DIR,
		filename);
	st = s_open_file(buf,O_RDONLY);
	d_f_ree(buf);
	if ( st == 0 )
		return 0;
	return init_parse(st,l_string(std_cm,filename),
			l_string(std_cm,filename));
}

int
set_swork(char * filename,XL_SEXP * data)
{
extern L_CHAR * sys_path;
char * buf;
int slen,flen,wlen;
STREAM * st;

	slen = l_strlen(sys_path);
	flen = strlen(filename);
	wlen = strlen(SWORK_DIR);
	buf = d_alloc((slen+flen+wlen+10)*sizeof(L_CHAR),1);
	sprintf(buf,"%s%s",
		n_string(std_cm,sys_path),
		SWORK_DIR);
	u_mkdir(buf,0755);
	chmod(buf,0755);
	sprintf(buf,"%s%s/%s",
		n_string(std_cm,sys_path),
		SWORK_DIR,
		filename);
	st = s_open_file(buf,O_RDWR|O_CREAT|O_TRUNC,0644);
	d_f_ree(buf);
	if ( st == 0 )
		return -1;
	print_sexp(st,data,PF_INDENT|PF_MULTI_ROOT);
	s_printf(st,"\n");
	s_close(st);
	return 0;
}


