/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbview.h"

int
dummy()
{
	return 0;
}

int draw_coordinate();
int draw_pixel_data();
int draw_draw_gb();
int draw_map();
int draw_mark();
int draw_polygon2d();

int get_point_default();
int get_point_coordinate();
int get_point_pixel_data();
int get_point_draw();

int get_point_mark();
int get_point_polygon2d();

int free_polygon2d();
int free_mark();

int browse_coord();
int browse_draw_gb();
int browse_map();

int select_default();
int select_draw_gb();
int select_polygon2d();
int select_coordinate();
int select_mark();

int olist_polygon2d();
int olist_mark();

int check_default();
int check_coordinate();
int check_vector();

#include	"xl.h"
#include	"gbview.h"

char status_msg_table[][STS_MSG_TBL_LENGTH] = {
	"idle",
	"load",
	"error",
};


XL_SEXP * gv_new_coordinate();
XL_SEXP * gv_new_map();
XL_SEXP * gv_new_luster();
XL_SEXP * gv_new_vector();

GV_FUNC gv_new_table[RT_MAX] = {
	0,
	gv_new_coordinate,	/* coordinate */
	gv_new_map,		/* map */
	gv_new_vector,		/* draw_gb*/
	gv_new_luster		/* pixel data */
};


GBV_FUNC resource_table[RT_MAX][GBF_MAX] = {
	{0,0,0,0,0,0},
	{	0,
        	draw_coordinate,
		get_point_coordinate,
		0,
		browse_coord,
		select_coordinate,
		0,
		check_coordinate},
	{	0,
		draw_map,
		get_point_default,
		0,
		dummy,
		0,
		0,
		check_default},
	{	0,
		draw_draw_gb,
		get_point_draw,
		0,
		dummy,
		select_draw_gb,
		0,
		check_vector},
	{	0,
		draw_pixel_data,
		get_point_pixel_data,
		0,
		dummy,
		select_default,
		0,
		check_default}
};


GBV_FUNC object_table[OT_MAX][GBF_MAX] = {
	{0,0,0,0,0,0},
	{0,
		draw_polygon2d,
		get_point_polygon2d,
		free_polygon2d,
		0,
		select_polygon2d,
		olist_polygon2d},
	{0,
		draw_mark,
		get_point_mark,
		free_mark,
		0,
		select_mark,
		olist_mark}
};

