/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef __POLY_DATA_H__
#define __POLY_DATA_H__

#include "kibandata.h"
#include "arc_data.h"

/* ݥꥴΣɣĻ쥳 */
#define PF_NOTFINDFORJOIN 1
typedef struct poly_id_record{
	char code[32];
	int id;
	/*
	ǡμࡡ0ʤarcs˥쥳ɤ
	1ʤpoints˥ݥꥴγκɸľ
	*/
	int arcs_type;
	GB_POINT point; /* Υݥꥴɽκɸ */
	int count;
	GB_POINT *points; /* ݥ */
	ARC_REF *arcs; /* 쥳*/
	int flags; /* ǡξ֤򼨤ե饰(ݥꥴǤ˷˻Ѥ줿ɤΥե饰ʤɤ򥻥å)*/
} POLY_ID_RECORD;

/*
ݥꥴ쥳ɤޤȤ᤿ǡ
ݥꥴե
*/
typedef struct poly_data{
	KIBAN_FILE_HEADER header;
	POLY_ID_RECORD *record; /*ݥꥴΥ쥳*/
} POLY_DATA;

/* ݥꥴեɤ߹ */
int ReadPoly(const char *filename, FILE *fp, POLY_DATA *pData, int Flags);

/* ݥꥴǡSVGǤФ */
void Poly2SVG(FILE *fp, ARC_DATA *pArc, POLY_DATA *pPoly, const char *szFillColor, const char *szStrokeColor);

/* ݥꥴ쥳ɤSVGǤФ */
void PolyRecord2SVG(FILE *fp, ARC_DATA *pArc, POLY_ID_RECORD *pPolyRecord, const char *szFillColor, const char *szStrokeColor);

/* ݥꥴǡη򥢡꤫顢ƺɸľܳǼѴ */
void ChangePolyDataType(POLY_DATA *pPoly, ARC_DATA *pArc);

/* ݥꥴ쥳ɤ˥ݥȤ򣱤ɲä */
int PolyAddPoint(POLY_ID_RECORD *pDstPolyRecord, const GB_POINT *pt, int *pnMalloced);

/* ̵ʥݥꥴĤƤʤݥꥴʤɡˤ */
void CleanupPoly(POLY_DATA *pPoly);

/* ꥢȴϢ */
POLY_DATA *malloc_poly_data();
void free_poly_id_record(POLY_ID_RECORD *pRecord);
void free_poly_data(POLY_DATA *pData);
#endif