/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"nig.h"

char tfile[50];
FILE_LIST *	files;
LAYER_INFO *	layer_inf;
int		li_size;
double force_scale_x,force_scale_y;
int		swap_flag;

FILE_LIST *
new_file(char * prefix)
{
FILE_LIST * fl;
char filename[100];
	for ( fl = files ; fl ; fl = fl->next )
		if ( strcmp(fl->name,prefix) == 0 )
			return fl;
	fl = malloc(sizeof(*fl));
	fl->next = files;
	files = fl;
	strcpy(fl->name,prefix);
	strcpy(filename,tfile);
	strcpy(&filename[strlen(filename)],prefix);
	fl->fd = fopen(filename,"w+");
	fl->start = fl->end = 0;
	if ( fl->fd == 0 ) {
		fprintf(stderr,"cannot open the file %s\n",filename);
		exit(1);
	}
	return fl;
}

void
new_layer_info(int layer,char * fill,char * stroke,char * svg,char * xml)
{
int i;
	if ( li_size <= layer ) {
		if ( li_size == 0 )
			layer_inf = malloc(sizeof(*layer_inf)*
					(layer+1));
		else	layer_inf = realloc(layer_inf,
					sizeof(*layer_inf)*
					(layer+1));
		for ( i = li_size ; i < layer ; i ++ ) {
			layer_inf[i].svg = 0;
			layer_inf[i].xml = 0;
		}
		li_size = layer+1;
	}
	else if ( layer_inf[layer].svg ) {
		fprintf(stderr,"colition config LAYER = %i\n",layer);
		exit(1);
	}
	layer_inf[i].svg = new_file(svg);
	layer_inf[i].xml = new_file(xml);
	strcpy(layer_inf[i].fill,fill);
	strcpy(layer_inf[i].stroke,stroke);
}

int
cmpcmd(char * buf,char * c)
{
	return memcmp(buf,c,strlen(c));
}

void
load_config(char * trunc,char * filename)
{
FILE * fd;
char buf[1000];
char * s;
int layer;
char fill[12];
char stroke[12];
char svg[50];
char xml[50];
int i;
char cmd[50];
	strcpy(tfile,trunc);
	for ( i = strlen(tfile)-1; i >= 0 ; i -- )
		if ( tfile[i] == '.' ) {
			tfile[i] = 0;
			break;
		}
	fd = fopen(filename,"r+");
	if ( fd == 0 ) {
		fprintf(stderr,"cannot open the file %s\n",filename);
		exit(1);
	}
	for ( ; ; ) {
		s = fgets(buf,1000,fd);
		if ( s == 0 )
			break;
		if ( buf[0] == '#' )
			continue;
		if ( buf[0] == '\n' || buf[0] == 0 )
			continue;
		if ( cmpcmd(buf,"layer") == 0 ) {
			fill[0] = stroke[0] = svg[0] = xml[0] = 0;
			sscanf(buf,"%s\t%i\t%s\t%s\t%s\t%s\n",
				cmd,
				&layer,
				fill,
				stroke,
				svg,
				xml);
			if ( fill[0] == 0 ||
				stroke[0] == 0 || svg[0] == 0 ||
					xml[0] == 0 ) {
				fprintf(stderr,"invalid config : %s\n",
					buf);
				exit(1);
			}
			new_layer_info(layer,fill,stroke,svg,xml);
		}
		else if ( cmpcmd(buf,"scale-x") == 0 ) {
			sscanf(buf,"%s\t%lf\n",
				cmd,
				&force_scale_x);
		}
		else if ( cmpcmd(buf,"scale-y") == 0 ) {
			sscanf(buf,"%s\t%lf\n",
				cmd,
				&force_scale_y);
		}
		else if ( cmpcmd(buf,"swap") == 0 ) {
			swap_flag = 1;
		}
		else {
			fprintf(stderr,"invalid command %s\n",
				buf);
			exit(1);
		}
	}
	fclose(fd);
}