/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	"memory_debug.h"
#include	"nig.h"

extern LAYER_INFO * layer_inf;
extern int li_size;
extern double force_scale_x,force_scale_y;
extern int swap_flag;

double tl_x,tl_y,br_x,br_y;

NIG_PTR * list;
int nig_name,nig_type;



void
new_nig_ptr(double x,double y,int type)
{
NIG_PTR * ret;
	nig_type = type;
	ret = d_alloc(sizeof(*ret),1);
	ret->x = x;
	ret->y = y;
	ret->next = list;
	list = ret;
}

void
output_nig(int name,int layer,NIG_PTR * list)
{
NIG_PTR * lp, * p;
int poly_type;
char cmd;
	lp = 0;
	for ( ; list ; ) {
		p = list;
		list = p->next;
		p->next = lp;
		lp = p;
	}
	fprintf(layer_inf[layer].xml->fd,
	"<information name=\"path%i\" scheme=\"nigmas\" layer=\"%i\"/>\n",
		name,layer);
	fprintf(layer_inf[layer].svg->fd,
		"<path id=\"path%i\" style=\"fill:%s;stroke:%s;\" d=\"",
		name,
		layer_inf[layer].fill,
		layer_inf[layer].stroke);
	cmd = 'M';
	for ( p = lp ; p ; p = p->next ) {
		fprintf(layer_inf[layer].svg->fd,"%c %lf %lf ",
			cmd,
			p->x,
			p->y);
		cmd = 'L';
	}
	fprintf(layer_inf[layer].svg->fd,"\" />\n");
	for ( ; lp ; ) {
		p = lp;
		lp = p->next;
		d_f_ree(p);
	}
}

void
new_nig_list()
{
NIG_PTR * p;
	if ( list )
		output_nig(nig_name,nig_type,list);
	list = 0;
	nig_name ++;
}

void
load_nig(char * filename)
{
char buf[1000];
char * s;
int link,layer,key,line;
double xx,yy;
double bl_x,bl_y,tr_x,tr_y;
double scale_x,scale_y;
int i;
FILE * fd;

	fd = fopen(filename,"r+");
	if ( fd == 0 ) {
		fprintf(stderr,"cannot open the file %s\n",filename);
		exit(1);
	}

	s = fgets(buf,1000,fd);
	if ( s == 0 )
		goto end;
	sscanf(buf,"%i\t%i\t%i\t%i\t%lf\t%lf\t%lf\t%lf\n",
		&link,
		&layer,
		&key,
		&line,
		&bl_x,
		&bl_y,
		&tr_x,
		&tr_y);
	bl_y = - bl_y;
	tr_y = - tr_y;
	s = fgets(buf,1000,fd);
	if ( s == 0 )
		goto end;
	if ( swap_flag == 0 )
		sscanf(buf,"%i\t%i\t%i\t%i\t%lf\t%lf\n",
			&link,
			&layer,
			&key,
			&line,
			&scale_x,
			&scale_y);
	else	sscanf(buf,"%i\t%i\t%i\t%i\t%lf\t%lf\n",
			&link,
			&layer,
			&key,
			&line,
			&scale_y,
			&scale_x);
	if ( force_scale_x )
		scale_x = force_scale_x;
	if ( force_scale_y )
		scale_y = force_scale_y;

	if ( swap_flag == 0 ) {
		tl_x = bl_x*scale_x;
		tl_y = tr_y*scale_y;
		br_x = tr_x*scale_x;
		br_y = bl_y*scale_y;
	}
	else {
		tl_x = bl_y*scale_x;
		tl_y = tr_x*scale_y;
		br_x = tr_y*scale_x;
		br_y = bl_x*scale_y;
	}

	for ( i = 0 ; i < li_size ; i ++ ) {
		if ( layer_inf[i].svg == 0 )
			continue;
		if ( layer_inf[i].svg->start == 0 ) {
			fprintf(layer_inf[i].svg->fd,
			"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
			fprintf(layer_inf[i].svg->fd,
	"<svg width=\"400\" height=\"400\" viewBox=\"%lf %lf\">\n",
				br_x - tl_x,
				br_y - tl_y);
			layer_inf[i].svg->start = 1;
		}

		if ( layer_inf[i].xml->start == 0 ) {
			fprintf(layer_inf[i].xml->fd,
			"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
			fprintf(layer_inf[i].xml->fd,"<gbs>\n");
			layer_inf[i].xml->start = 1;
		}
	}


	for ( ; ; ) {
		s = fgets(buf,1000,fd);
		if ( s == 0 )
			break;
		if ( swap_flag == 0 )
			sscanf(buf,"%i\t%i\t%i\t%i\t%lf\t%lf\n",
				&link,
				&layer,
				&key,
				&line,
				&xx,
				&yy);
		else	sscanf(buf,"%i\t%i\t%i\t%i\t%lf\t%lf\n",
				&link,
				&layer,
				&key,
				&line,
				&yy,
				&xx);
		if ( layer >= li_size )
			continue;
		if ( layer_inf[layer].svg == 0 )
			continue;
		xx = scale_x*xx;
		yy = -scale_y*yy -345;
		switch ( (link%10) ) {
		case 1:
			new_nig_list();
			new_nig_ptr(xx,yy,layer);
			break;
		case 2:
			new_nig_ptr(xx,yy,layer);
			break;
		default:
			er_panic("load_nig(1)");
		}
	}
end:
	new_nig_list();
	for ( i = 0 ; i < li_size ; i ++ ) {
		if ( layer_inf[i].svg == 0 )
			continue;
		if ( layer_inf[i].svg->end == 0 ) {
			fprintf(layer_inf[i].svg->fd,"</svg>\n");
			layer_inf[i].svg->end = 1;
		}
		if ( layer_inf[i].xml->end == 0 ) {
			fprintf(layer_inf[i].xml->fd,"</gbs>\n");
			layer_inf[i].svg->end = 1;
		}
	}
	fclose(fd);
}
