/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"


typedef struct well_known_port {
	char	name[10];
	int	port;
} WELL_KNOWN_PORT;

WELL_KNOWN_PORT wkp_tbl[] = {
	{"http",80},
	{"xlp",0},
	{"",0}
};


int
get_wkp(L_CHAR * name)
{
int i;
	for ( i = 0 ; wkp_tbl[i].name[0] ; i ++ ) {
		if ( l_strcmp(l_string(std_cm,wkp_tbl[i].name),name) )
			continue;
		return wkp_tbl[i].port;
	}
	return -1;
}

char*
get_proto_name(int port)
{
int i;
	for ( i = 0 ; wkp_tbl[i].name[0] ; i ++ )
		if ( wkp_tbl[i].port == port )
			return wkp_tbl[i].name;
	return 0;
}

