/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_ComposePath();

void
init_ComposePath(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"ComposePath"),
		get_func_prim(xl_ComposePath,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_ComposePath(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * path1,* path2;
L_CHAR * _p;
	path1 = get_el(s,1);
	if ( get_type(path1) != XLT_STRING )
		goto type_missmatch;
	path2 = get_el(s,2);
	if ( get_type(path2) != XLT_STRING )
		goto type_missmatch;
	_p = compose_path(
		path1->string.data,
		path2->string.data);
	if ( _p == 0 )
		goto invalid_param;
	return get_string(_p);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"ComposePath"),
		0);
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"ComposePath"),
		n_get_string("invalid path argments"));
}


