#!/bin/bash
exec perl -w -x $0 ${1+"$@"} # -*- mode: perl; perl-indent-level: 2; -*-
#!perl -w


##############################################################
###                                                        ###
### cvs2rt.pl: arrange Release Tag from `cvs rdiff` output.###
###                                                        ###
##############################################################

############### Globals ################


# Where is the directory with a dependence portion?
my @ARCH = ();
$ARCH[0] = "/gbs/env/src/arch/unix"; ## UNIX
$ARCH[1] = "/gbs/env/src/arch/mac" ; ## MAC
$ARCH[2] = "/gbs/env/src/arch/win" ; ## WINDOWS

# What is Release name? 
my @REL = ();
$REL[0] = "rel-A-00";
$REL[1] = "rel-A-00-02";
$REL[2] = "rel-B-a01";
$REL[3] = "wx-motif";
$REL[4] = "rel-A-01";

# CVS Command
my $Diff_Command = "cvs -Q rdiff -s";

# Print debugging messages?
$Debug = 1;


my @OUTPUT=();
my @COUNT = ();
$COUNT[0] = 0; ## UNIX
$COUNT[1] = 0; ## MAC
$COUNT[2] = 0; ## WINDOWS
############### End Globals ################



&arrange_release_tag;

foreach(@OUTPUT){
  print;
}


########## Subroutine definitions ##########

sub arrange_release_tag()
{
  my $rel = 0;

  &output($rel);

  while($rel < $#REL){
   
   if($REL[$rel + 1] =~ m/B$/){
    $REL[$rel +1] =~ s/B$//;
    @COUNT = (0,0,0);
   }
   else{
    for(0..2){
     my $Command = "$Diff_Command -r $REL[$rel] -r $REL[$rel + 1] $ARCH[$_]";
     
     &debug ("(run \"${Command}\")\n");
     open (LOG_SOURCE, "$Command |") or die "unable to run \"${Command}\"";

     
     if(<LOG_SOURCE>){$COUNT[$_]++;}

     while(<LOG_SOURCE>){};

     close LOG_SOURCE;
    }
   }
   
   $rel++;

   &output($rel);

  }
}

sub output()
{

   my @RELARCH = ();

   $RELBASE = $REL[$_[0]];
   $RELBASE =~ s/^\w*-/-/;

   for(0..2){
    $RELARCH[$_] = $RELBASE;
   }

   $RELARCH[0] =~ s/^\w*-/posix-/;
   $RELARCH[1] =~ s/^\w*-/mac-/;
   $RELARCH[2] =~ s/^\w*-/win-/;   

   for(0..2){
    if($COUNT[$_]<10){$RELARCH[$_] .= '-0'.$COUNT[$_];}
    else{$RELARCH[$_] .=~ '-'.$COUNT[$_];}
   }

   push @OUTPUT, "$REL[$_[0]] $RELARCH[0] $RELARCH[1] $RELARCH[2]\n";
}

sub debug ()
{
  if ($Debug) {
    my $msg = shift;
    print STDERR $msg;
  }
}
