/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"pfc.h"
#include	"task.h"


extern PFC pmd_pfc;

SEM pfc_lock_lock;

int
lock_pfc(PFC * p)
{
XL_SEXP * ret;
	gc_push(0,0,"lock_pfc"); 
	ret = connect_lock(0,l_string(std_cm,p->filename),"write");
	if ( get_type(ret) != XLT_INTEGER ) {

		p->lock_id = 0;
		gc_pop(0,0);
		return -1;
	}


	lock_task(pfc_lock_lock);
	if ( p->lock_id )
		er_panic("lock_pfc(1)");
	p->lock_id = ret->integer.data;
	unlock_task(pfc_lock_lock,"lock_pfc");

	gc_pop(0,0);

	return 0;
}

void
unlock_pfc(PFC * p)
{
int id;
char * ptr;
int i;

	lock_task(pfc_lock_lock);
	if ( p->lock_id == 0 )
		er_panic("unlock_pfc(1)");
	gc_push(0,0,"unlock_pfc");

	id = p->lock_id;
	p->lock_id = 0;
	unlock_task(pfc_lock_lock,"unlock_pfc");

	connect_unlock(0,id,l_string(std_cm,p->filename));
	gc_pop(0,0);
}
