/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___PDB_INNER_H___
#define ___PDB_INNER_H___

#include	"gbgraph.h"

#define NO_PITCH	0x100
#define DF_BUF	0x2000

typedef struct acc_header {
	unsigned int	fofs;
} ACC_HEADER;

typedef struct pn_header {
	unsigned short	type;
	unsigned short	size;
} PN_HEADER;

typedef struct acc_pn_header {
	ACC_HEADER	a;
	PN_HEADER	h;
} ACC_PN_HEADER;

#define PNT_TYPE_MASK		0x00ff
#define PNT_GROUP_MASK		0xff00
#define PNT_GET_GROUP(x)	(((x)&PNT_GROUP_MASK)>>8)

#define PNT_GROUP_MAX		3

#define PNT_POLYGON_GROUP	0x0000
#define PNT_FILE_HEADER		1
#define PNT_2D_DRAW_HEADER	2
#define PNT_LOD_LIST		3
#define PNT_TREE_NODE		4
#define PNT_POLYGON2D		5
#define PNT_POLY_POINT		6	
#define PNT_POLY_END		7
#define PNT_LNO_POLY_POINT	8
#define PNT_POLY_MAX		9

#define PNT_FAVT_GROUP		1
#define PNT_FAVT_ROOT		((PNT_FAVT_GROUP<<8)|1)
#define PNT_FAVT_NODE		((PNT_FAVT_GROUP<<8)|2)
#define PNT_FREELIST_HEADER	((PNT_FAVT_GROUP<<8)|3)
#define PNT_FREELIST_NODE	((PNT_FAVT_GROUP<<8)|4)
#define PNT_DTREE_DATA		((PNT_FAVT_GROUP<<8)|5)
#define PNT_FAVT_MAX		6

#define PNT_ASSOC_GROUP		2
#define PNT_ASSOC_HEADER	((PNT_ASSOC_GROUP<<8)|1)
#define PNT_ASSOC_DATA		((PNT_ASSOC_GROUP<<8)|2)

#define PNT_PMD_GROUP		3
#define PNT_PMD_HEADER		((PNT_PMD_GROUP<<8)|1)
#define PNT_PMD_NODE		((PNT_PMD_GROUP<<8)|2)
#define PNT_PMD_MD		((PNT_PMD_GROUP<<8)|3)
#define PNT_PMD_OFSLIST		((PNT_PMD_GROUP<<8)|4)

#define PNT_RT_CACHE_GROUP	4
#define PNT_RT_CACHE_HEADER	((PNT_RT_CACHE_GROUP<<8)|1)
#define PNT_RT_CACHE_DATA	((PNT_RT_CACHE_GROUP<<8)|2)
#define PNT_RT_CACHE_LIST	((PNT_RT_CACHE_GROUP<<8)|3)

#define PNT_RS_CACHE_GROUP	5
#define PNT_RS_CACHE_NULL	((PNT_RS_CACHE_GROUP<<8)|0)
#define PNT_RS_CACHE_HEADER	((PNT_RS_CACHE_GROUP<<8)|1)
#define PNT_RS_CACHE_DATA	((PNT_RS_CACHE_GROUP<<8)|2)
#define PNT_RS_RES_STATUS	((PNT_RS_CACHE_GROUP<<8)|3)
#define PNT_RS_COORDINATE	((PNT_RS_CACHE_GROUP<<8)|4)
#define PNT_RS_PIXEL_MAP_R64	((PNT_RS_CACHE_GROUP<<8)|5)
#define PNT_RS_DRAW_GB		((PNT_RS_CACHE_GROUP<<8)|6)
#define PNT_RS_RES_MAP		((PNT_RS_CACHE_GROUP<<8)|7)
#define PNT_RS_BIB_LIST		((PNT_RS_CACHE_GROUP<<8)|8)
#define PNT_RS_NOTE		((PNT_RS_CACHE_GROUP<<8)|9)
#define PNT_RS_CLIP		((PNT_RS_CACHE_GROUP<<8)|10)
#define PNT_RS_MAP		((PNT_RS_CACHE_GROUP<<8)|11)
#define PNT_RS_INFO_SCHEME	((PNT_RS_CACHE_GROUP<<8)|12)
#define PNT_RS_TRIANGLE		((PNT_RS_CACHE_GROUP<<8)|13)
#define PNT_RS_MAP_POINT_LIST	((PNT_RS_CACHE_GROUP<<8)|14)


/*******************************/


typedef struct pn_file_header {
	PN_HEADER	h;
	int		type;	/* file type */
#define FT_2D_DRAW		1	/* draw file */
#define FT_2D_MAP		2	/* map file */
#define FT_2D_COORDINATE	3	/* coordinate system definition file */
#define FT_ADDRESS_LUMP		10	/* address lump system */
#define FT_RT_CACHE		11	/* routing cache */
	char		version[8];
#define VERSION		"0.4"
#define ENCODING_SIZE	8
	char		encoding[ENCODING_SIZE];
	unsigned int	linear;
	unsigned int	linear_length;
} PN_FILE_HEADER;
#define PN_FILE_HEADER_S	sizeof(PN_FILE_HEADER)

typedef struct pn_2d_draw_header {
	PN_HEADER	h;
	int		level;
	double		resolution;
#define UNIT_SIZE	16
	char		unit[UNIT_SIZE];
	unsigned int	fofs;	/* offset to root tree node */
	GB_RECT		minrect;
#define INFO_FILENAME_SIZE	32
	char		infofile[INFO_FILENAME_SIZE];
} PN_2D_DRAW_HEADER;
#define PN_2D_DRAW_HEADER_S	sizeof(PN_2D_DRAW_HEADER)

typedef struct pn_lod_list {
	PN_HEADER	h;
	int		max;
	unsigned int	fofs[1];
} PN_LOD_LIST;
#define PN_LOD_LIST_SIZE(max)	((int)(&((PN_LOD_LIST*)0)->fofs[max]))


#define PTR_MAX	16
typedef struct pn_tree_node {
	PN_HEADER	h;
	GB_RECT	r;
	unsigned char	lod_min;
	unsigned char	lod_max;
	short	fofs_size;
	union {
		int	fofs[PTR_MAX];
		struct {
			int	index;
			int	fofs;
		}	lst[PTR_MAX/2];
	} fo;
#define TLX_L	0x01		/* top left x value is large */
#define TLX_S	0x00		/* top left x value is small */
#define TLY_L	0x02
#define TLY_S	0x00
#define BRX_L	0x04
#define BRX_S	0x00
#define BRY_L	0x08
#define BRY_S	0x00
} PN_TREE_NODE;

#define PN_TREE_NODE_S(size) \
	( (size) >= PTR_MAX/2 ?					\
		((int)(&(((PN_TREE_NODE*)0)->fo.fofs[PTR_MAX]))):\
		((int)(&(((PN_TREE_NODE*)0)->fo.lst[size]))))

/*
	r.tl.x < tree_node.r.br.x &&
	r.br.x >= tree_node.r.tl.x &&
	r.tl.y >= tree_node.r.br.y &&
	r.br.y < tree_node.r.tl.y &&
	lod = tree_node.lod
	fofs[TLX_S|TLY_L|BRX_L|BRY_S|LOD_L]
*/

typedef struct pn_polygon2d {
	PN_HEADER	h;
	GB_COLOR	line_color;
	GB_COLOR	padding_color;
	unsigned int	code;
	short		type;
#define PNT_CLOSE	1
#define PNT_OPEN	2
	unsigned char	lod_min;
	unsigned char	lod_max;
	GB_RECT		minrect;
} PN_POLYGON2D;
#define PN_POLYGON2D_S	sizeof(PN_POLYGON2D)


typedef struct pn_poly_point {
	PN_HEADER	h;
	short		no;

#define PP_FLAGS	0x8000
#define PP_NO		0x7fff
#define PP_MOVE		0x8000

	unsigned char	lod_min;
	unsigned char	lod_max;
	GB_POINT	p;
} PN_POLY_POINT;
#define PN_POLY_POINT_S		sizeof(PN_POLY_POINT)


typedef struct pn_lno_poly_point {
	PN_HEADER	h;
	int		no;
#define PP_LFLAGS	0x80000000
#define PP_LNO		0x7fffffff
#define PP_LMOVE	0x80000000
#define PP_TO_L(x)	(((x)&PP_NO)|((((int)(x))&PP_FLAGS)<<16))
	unsigned char	lod_min;
	unsigned char	lod_max;
	GB_POINT	p;
} PN_LNO_POLY_POINT;
#define PN_LNO_POLY_POINT_S		sizeof(PN_LNO_POLY_POINT)

typedef struct pn_poly_end {
	PN_HEADER	h;
} PN_POLY_END;
#define PN_POLY_END_S		sizeof(PN_POLY_END)


/*******************************/
/*
	FILE AVT 
*/
/*******************************/

typedef struct pn_favt_root {
	PN_HEADER	h;
	int		type;
#define FAST_DTREE	0x00000001
#define FAST_OTHER_TREE	0x00000000
#define FAST_DTREE_ROOT	0x00000001

#define FAT_DTREE_NODE	2

	unsigned int	node;
} PN_FAVT_ROOT;

#define PN_FAVT_ROOT_S		sizeof(PN_FAVT_ROOT)

typedef struct pn_favt_node {
	PN_HEADER	h;
	unsigned int	small;
	unsigned int	large;
	int		level;
	/* user data is followed */
} PN_FAVT_NODE;

#define PN_FVAT_NODE_S		sizeof(PN_FAVT_NODE)

typedef struct pn_freelist {
	PN_HEADER	h;
	unsigned int	next;
} PN_FREELIST;


typedef struct pn_dtree_data {
	PN_HEADER	h;
	unsigned int	data[1];
	/* two or more data are allowed */
} PN_DTREE_DATA;

#define PN_DTREE_DATA_S(x)	((int)(&((PN_DTREE_DATA*)0)->data[x]))

/*******************************/
/*
	FAVT fundamental data structure
*/
/*******************************/


typedef struct floating_index {
	unsigned int		fofs;
	REAL1			d;
} FLOATING_INDEX;

typedef struct gb_time_index {
	unsigned int		fofs;
	GB_TIME			d;
} GB_TIME_INDEX;

typedef struct string_index {
	unsigned int		fofs;
	L_CHAR			d[1];
} STRING_INDEX;

#define STRING_IX_LENGTH(x,y)	((int)&(((STRING_INDEX*)0)->d[(x)+(y)+2]))
#define STRING_IX_LENGTH_1(x)	((int)&(((STRING_INDEX*)0)->d[(x)+1]))

typedef struct timeout_index {
	unsigned int		fofs;
	unsigned int		timeout;
} TIMEOUT_INDEX;


void favt_string_endian(STRING_INDEX * ix,int len);
void favt_gb_time_endian(GB_TIME_INDEX * ix,int len);
void favt_floating_endian(FLOATING_INDEX * ix,int len);
void favt_timeout_endian(TIMEOUT_INDEX * ix,int len);

int favt_cmp_string_1(STRING_INDEX *,STRING_INDEX *);
int favt_cmp_string_2(STRING_INDEX *,STRING_INDEX *);

/*******************************/
/*
	Associate Memory
*/
/*******************************/

typedef struct assoc_index {
	unsigned int	fofs;
	short		type;
#define AIT_INTEGER	1
#define AIT_STRING	2
	short		name;
} ASSOC_INDEX;

typedef struct pn_assoc_header {
	PN_HEADER	h;
	ASSOC_INDEX	ix[1];
} PN_ASSOC_HEADER;

#define PN_ASSOC_HEADER_S(x)	((int)(&(((PN_ASSOC_HEADER*)0)->ix[x])))

typedef struct pn_assoc_data {
	PN_HEADER	h;
	char		data[1];
} PN_ASSOC_DATA;

#define PN_ASSOC_DATA_S(x)	((int)(&(((PN_ASSOC_DATA*)0)->data[x])))

/*******************************/
/*
	PMD : Plate Metadata Lump
*/
/*******************************/

#define FAT_PMD_FLOATING	0x100
#define FAT_PMD_GB_TIME		0x102
#define FAT_PMD_STRING		0x104
#define FAT_PMD_TIMEOUT		0x106

typedef struct pn_pmd_header {
	PN_HEADER	h;
	char		version[8];
#define PMD_VERSION	"0.2"

#define PMD_UNIT_LEN	200
	L_CHAR		unit_path[PMD_UNIT_LEN];

	int		flags;
#define PMDF_WRITE	1
	unsigned int	ix_tl_x;
	unsigned int	ix_tl_y;
	unsigned int	ix_br_x;
	unsigned int	ix_br_y;
	unsigned int	ix_resolution;
	unsigned int	ix_content_period_from;
	unsigned int	ix_content_period_to;
	unsigned int	ix_target;
	unsigned int	ix_timeout;
} PN_PMD_HEADER;

typedef struct pn_pmd_node {
	PN_HEADER	h;
	GB_RECT		minrect;
	REAL1		resolution;
	GB_TIME		content_period_from;
	GB_TIME		content_period_to;
	unsigned int	timeout;
	unsigned int	md_fofs;
	unsigned short	category;
/*
	unsigned short	crd == 0 ;
*/
	unsigned short	target;
	L_CHAR		str[1];
} PN_PMD_NODE;

#define PN_PMD_NODE_S(x,y) ((int)&(((PN_PMD_NODE*)0)->str[(x)+(y)+2]))

typedef struct pn_pmd_md {
	PN_HEADER	h;
	unsigned int	next_fofs;

/*
	unsigned short	namespace == 0;
*/
	unsigned short	qualifier;
	unsigned short	inherit; /* integer of no */
	unsigned short	type;
	unsigned short	data;
	L_CHAR		str[1];
} PN_PMD_MD;

#define PN_PMD_MD_S(x,y,z,w) \
	((int)&(((PN_PMD_NODE*)0)->str[(x)+(y)+(z)+(w)+4]))

typedef struct pn_pmd_ofslist {
	PN_HEADER	h;
	unsigned int	fofs[1];
} PN_PMD_OFSLIST;

#define PN_PMD_OFSLIST_S(x) \
	((int)&(((PN_PMD_OFSLIST*)0)->fofs[x]))


/*******************************/
/* 
	Linear Section for pp
 */
/*******************************/

typedef struct code_index {
	unsigned int		fofs;
	GB_RECT			minrect;
} CODE_INDEX;


/*******************************/
/* 
	Routing Cache file
 */
/*******************************/

#define FAT_RTC_URL	0x201
#define FAT_RTC_TIMER	0x202

typedef struct pn_rt_cache_header {
	PN_HEADER	h;
	char		version[8];
#define RT_CACHE_VERSION	"0.1"
	unsigned int	url_tree;
	unsigned int	timer_tree;
	int		count;
	int		flags;
#define RTC_F_WRITE	0x00000001
} PN_RT_CACHE_HEADER;
#define PN_RT_CACHEHEADER_S	sizeof(PN_RT_CACHE_HEADER)


typedef struct pn_rt_cache_data {
	PN_HEADER	h;
	int		sts;
	unsigned int	modify;
	unsigned int	update;
} PN_RT_CACHE_DATA;

typedef struct pn_rt_cache_element {
	unsigned int	data;
	unsigned int	update;
	int		flags;
#define RTC_LF_TERMINAL	0x00000001
} PN_RT_CACHE_ELEMENT;

typedef struct pn_rt_cache_list {
	PN_HEADER	h;
	unsigned int	next;
} PN_RT_CACHE_LIST;
#define PN_RT_CACHE_LIST_S(x)	\
	(sizeof(PN_RT_CACHE_LIST) + sizeof(PN_RT_CACHE_ELEMENT)*(x))


/*******************************/
/* 
	Resource Cache file
 */
/*******************************/

#define FAT_RSC_URL	0x301
#define FAT_RSC_TIMER	0x302


typedef struct pn_rs_cache_header {
	PN_HEADER		h;
	char			version[8];
#define RS_CACHE_VERSION	"0.1"
	unsigned int		url_tree;
	unsigned int		timer_tree;
	int			count;
	int			flags;
	int			file_id;
} PN_RS_CACHE_HEADER;


typedef struct pn_rs_cache_data {
	PN_HEADER	h;
	unsigned int	expire;
	int		file_id;
} PN_RS_CACHE_DATA;

typedef struct pn_rs_res_status {
	PN_HEADER	pn_h;
	char		version[8];
#define PNRS_T_RESOURCE	1
	int		type;
} PN_RS_RES_STATUS;

typedef struct pn_rs_res_header {

	PN_HEADER	pn_h;

/* copy of resource.h res_header */
/* cut
	union resource * entry_next;
	union resource * target_next;
	union resource * no_next;
*/
	int		type;
	/* type equal to RT_.... parameter */
/* string after this structure
	URL		entry;
	URL		target;
*/
/* cut
	int		no;
*/
	int		flags;
	unsigned int	modify;
	GB_RECT		minrect;
/* string after this structure
	XL_SEXP *	meta;
*/
/* cut
	int		initial_status;
	XL_SEXP *	initial_error;
	int		incremental_status;
	XL_SEXP *	incremental_error;
	int		error_time;
	int		error_expire;
*/
/* BIB records
	BIB_LIST *	bib;
*/
/* NOTE recors
	NOTE *		notes;
*/
	REAL1		visible_resolution;
/* string after this structure SYSTEM and UNIT
	COORDINATE_UNIT cu;
*/
} PN_RS_RES_HEADER;



typedef struct pn_rs_bib_list {

	PN_HEADER		pn_h;

/* copy from resource.h */
/* cut
	struct bib_list *	next;
*/
	int			inherit;
/* string after this structure
	L_CHAR *		namespace;
	L_CHAR *		qualifier;
	L_CHAR *		type;
	L_CHAR *		data;
*/
} PN_RS_BIB_LIST;

typedef struct pn_rs_note {

	PN_HEADER		pn_h;

/* copy from resource.h */
/* cut
	struct note *		next;
*/
	int			type;
/* string after this structure
	L_CHAR *		img;
*/
	int			fill_color;
	int			line_color;
/* string after this structure
	L_CHAR *		data;
	L_CHAR *		url;
*/
} PN_RS_NOTE;



typedef struct pn_rs_pixel_map_r64 {
	PN_RS_RES_HEADER	h;
	REAL1		dpm;
	unsigned char	type;
	/*
		'P'	R64 RGB
		'G'	R64 Gray Scale
		'B'	R64 Bitmap
		'0'	CR 64 sqare RGB
		'1'	CR 128 sqare RGB
		'2'	CR 256 sqare RGB
	*/
	int		width[32];
	int		height[32];
	int		max_level;
/* cut
	TREE_CACHE	tc;
	int		loop_no;
*/
} PN_RS_PIXEL_MAP_R64;


typedef struct pn_rs_coordinate {
	PN_RS_RES_HEADER	h;
	int		flags;
	int		geometory_type;
/* cut
	double *	geometory_param;
*/
	REAL1		limit_resolution;
/* MAP records
	RING_TYPE	map_children;
	RING_TYPE	map_parents;
*/
/* cut
	OVERLAY *	ov;
*/
	REAL1		weight;
/* string after this structure
	L_CHAR *	mode;
	XL_SEXP *	initial_cmd;
	XL_SEXP *	button_action;
*/
/* CID string after this structure
	int *		cid;
*/
/* string after this structure
	L_CHAR *	body;
	L_CHAR *	body_pri;

	L_CHAR *	relation_master;
	L_CHAR *	relation_slave;
*/
/* CLIP record
	CLIP *			clip;
*/
} PN_RS_COORDINATE;


typedef struct pn_rs_clip {

	PN_HEADER		pn_h;
/*
	struct clip *		next;
*/
	short			type;
	short			shape;
	union {
		GB_RECT			rect;
	}			d;
} PN_RS_CLIP;


typedef struct pn_rs_map {

	PN_HEADER		pn_h;

/* cut
	RING_TYPE		h;
*/
	short			depth;
	short			flags;
/* cut
	union resource *	src;
	union resource *	dest;
	union resource *	map_file;
*/
/* string after this structure
	URL			src_url;
	URL			dest_url;
	URL			map_url;
*/
	unsigned int		mod_time_org;
	unsigned int		mod_time;
	unsigned int		cindex_time;
	GB_RECT			cindex_mr;
/* CLIP record
	CLIP *			clip;
*/
} PN_RS_MAP;



typedef struct pn_rs_draw_gb {
	PN_RS_RES_HEADER	h;
	int		type;
	short		level;
/* dummy */
	short		pdb_lock;
/**/
	int		flags;
/* cut
	int		pdb_lock_task;
	int		pdb_lock_msg;
	int		pdb_lock_gc_flag;
*/
	REAL1		resolution;
/* cut
	AVT_NODE *	obj_code_tree;
	RECT_TREE	obj_rect_tree;
*/
	GB_POINT	matrix_ofs;
/* cut
	DRAW_MATRIX *	dm;
*/

	GB_POINT	pitch_list[32];
	int		loop_no;
/* cut
	INFO_REQ_QUEUE * ir_queue;
*/
/* INFO_SCHEME record
	INFO_SCHEME *	ischeme;
*/
	REAL1		onmap_indicate_size;
	short		hit_level;
	short		hit_outofcircle;

} PN_RS_DRAW_GB;

typedef struct pn_rs_info_scheme {

	PN_HEADER		pn_h;

/* cut
	struct info_scheme *	next;
*/
/* string after this structure
	L_CHAR *		scheme;
*/
	short			card_type;
	short			onmap_type;
	/* these are same as STYLE_FILE.type */
/* string after this structure
	L_CHAR *		card_style;
	L_CHAR *		onmap_style;
*/
} PN_RS_INFO_SCHEME;

typedef struct pn_rs_triangle_set {
	int			sts;
	int			cnt;
	AFFEN2D			a;
	GB_RECT			minrect;
	REAL1			resolution_rate;
/* TRIANGLE records : 
		the list of pair of PN_RS_TRIANGLE
		1st is param_forward
		2nd is param_reverse
	TRIANGLE *		tri_list;
*/
} PN_RS_TRIANGLE_SET;

typedef struct pn_rs_map_parameter {
	int	type;
	REAL1	resolution_rate;
	union {
		GB_POINT	ptr;
		AFFEN2D		affen;
		PN_RS_TRIANGLE_SET	tri;
	}	opt;
} PN_RS_MAP_PARAMETER;


typedef struct pn_rs_res_map {
	PN_RS_RES_HEADER	h;
/* string after this structure
	URL		src;
	URL		dest;
	COORDINATE_UNIT	cu_src;
	COORDINATE_UNIT	cu_dest;
*/
/* MAP POINT LIST RECORDS 
	RING_TYPE	point_list;
*/
	PN_RS_MAP_PARAMETER		param_forward;
	PN_RS_MAP_PARAMETER		param_reverse;
} PN_RS_RES_MAP;



typedef struct pn_rs_triangle {

	PN_HEADER		pn_h;

/* cut
	struct triangle *	next;
*/
/* NEXT record or PREV record
	struct triangle *	c; 
*/
/* tag name string after this structure
	MAP_POINT_LIST *	ptl[3];
*/
	GB_POINT		ptp[3];
	AFFEN2D			a;
	REAL1			resolution_rate;
	GB_RECT			minrect;
} PN_RS_TRIANGLE;

typedef struct pn_rs_map_point_list {

	PN_HEADER	pn_h;

/* cut
	RING_TYPE	h;
*/
/* string after this structure
	L_CHAR *	tag;
*/
	GB_POINT	src;
	GB_POINT	dest;
} PN_RS_MAP_POINT_LIST;


/*******************************/


#define CACHE_MAX	10000000

#include	"avt.h"

typedef struct fa_ring {
	struct fa_ring *	next;
	struct fa_ring *	prev;
} FA_RING;

typedef struct fa_cache {
	struct fa_cache *	next;
	int			ref;
	char *			filename;
	AVT_NODE *		records;
} FA_CACHE;

typedef struct fac_header {
	FA_RING			r;
	FA_CACHE *		file;
	unsigned int		offset;
	PN_HEADER		h;
} FAC_HEADER;

#define SIZEOF_FAC(size)	\
	(((int)(&((FAC_HEADER*)0)->h))+(size))

typedef struct pdb_request {
	struct pdb_request *	next;
	unsigned int		fofs;
	void *			option;
} PDB_REQUEST;

typedef struct pdb {
	int		fid;
	int		flags;
#define PF_PDB_MASK	0x0000ffff
#define PF_CACHE	0x00000001
	unsigned int	fofs;
	PDB_REQUEST *	request;
	PDB_REQUEST *	next_request;
	FA_CACHE *	cache;
	char		data[DF_BUF];
	int		buf_ptr;
	int		buf_len;
	unsigned int	seek_ptr;
	void *		freelist_work;
} PDB;

PDB * open_pdb(char * filename,int oflags,int mode,int flags);
void close_pdb(PDB *);
void insert_request(PDB *,unsigned int fofs,void * option);
int delete_request(PDB * p,int (*func[])(),void*);
#define E_DR_NO_REQUEST	(-1)
#define E_DR_FILE_ACCESS (-2)
#define E_DR_SEGMENT_ACCESS (-3)
#define E_DR_UNSUPPORT_SEGMENT_TYPE (-4)

#ifndef OPEN_FILESPACE
PDB * open_filespace(char * filename,int oflags,int mode,int flags,...);
#endif
#define PF_USEFREELIST	0x80000000
unsigned int fs_raw_write(PDB * p,void * d,int flags);
#define FSF_ONLYHEADER	0x00000001
#define FSF_RESERVE_SP	0x00000002


#endif

