/**********************************************************************
 
	Copyright (C) 2003 
	Tomohito Nakajima <nakajima@zeta.co.jp>

	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/gb_windows.h"
#include	"memory_debug.h"
#include	"utils.h"

void RemoveDirectoryR(const char *pszDir){
	WIN32_FIND_DATA fd;
	char pszFilter[MAX_PATH+1];
	char pszFullPath[MAX_PATH+1];
	HANDLE hFind;

	wsprintf(pszFilter, "%s\\*.*", pszDir);
	hFind = FindFirstFile(pszFilter, &fd);
	while(FindNextFile(hFind, &fd)){
		if(strcmp(fd.cFileName,".") == 0 || strcmp(fd.cFileName,"..") == 0){
			continue;
		}
		wsprintf(pszFullPath, "%s\\%s", pszDir, fd.cFileName);
		if(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY){
			RemoveDirectoryR(pszFullPath);
			continue;
		}
		DeleteFile(pszFullPath);
	}
	if(hFind)
		FindClose(hFind);
	RemoveDirectory(pszDir);
}


void
u_rm(char * path,int flags)
{
	if ( flags & RMF_REC ) {
		RemoveDirectoryR(path);
	}
	else {
		if ( flags & RMF_FILE ) {
	 		DeleteFile(path);
		}
		if ( flags & RMF_DIR ) {
			RemoveDirectory(path);
		}
	}
}
