/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	<stdlib.h>

char * attr[100];
char * data[100];


char * q_url,*q_type,* tx,*ty,*bx,*by,* z_url, *rotate;


char
get_digit(char a)
{
	if ( '0' <= a && a <= '9' )
		return a - '0';
	if ( 'a' <= a && a <= 'f' )
		return a - 'a' + 10;
	if ( 'A' <= a && a <= 'F' )
		return a - 'A' + 10;
	return -1;
}

char * get_url_string(char *str)
{
char * ret;
char * p,* q;
char d1,d2;
	ret = malloc(strlen(str)+1);
	for ( p = ret , q = str ; *q ; ) {
		if ( *q == '%' ) {
			q ++;
			d1 = get_digit(*q);
			if ( d1 < 0 ) {
				*p++ = '%';
				continue;
			}
			q ++;
			d2 = get_digit(*q);
			if ( d2 < 0 ) {
				*p++ = d1;
				continue;
			}
			*p++ = d2 + (d1<<4);
			q ++;
		}
		else {
			*p++ = *q++;
		}
	}
	*p = 0;
	return ret;
}

void
divide(char * q)
{
int i;
char * p;
	p = q;
	for ( i = 0 ; ; i ++ ) {
		attr[i] = p;
		for ( ; *p &&
			*p != '&' &&
			*p != '=' ; p ++ );
		switch ( *p ) {
		case 0:
			return;
		case '&':
			data[i] = "";
			*p ++ = 0;
			break;
		case '=':
			*p ++ = 0;
			data[i] = p;
			for ( ; *p &&
				*p != '&';
				p ++ );
			switch ( *p ) {
			case '&':
				*p ++ = 0;
				break;
			default:
				return;
			}
			break;
		}
	}
}

void
print_divide()
{
int i;
	printf("Content-type: text/plain\n\n");
	for ( i = 0 ; ; i ++ ) {
		if ( attr[i] == 0 )
			break;
		printf("(%s) = (%s)\n",attr[i],data[i]);
	}
}

char *
search_query(char * type,char * def)
{
int i;
	for ( i = 0 ; attr[i] ; i ++ )
		if ( strcmp(attr[i],type) == 0 )
			return data[i];
	return def;
}


void
output()
{
	printf("Content-type: text/gb\n\n");
	printf("([?xl version=\"0.1\" encoding=\"EUC-JP\"])\n");
	printf("([gv-resource rid=\"6\"] \n");
	if ( q_url ) {
		printf(" (%s \n",q_type);
		printf("  (URL \"%s\")) \n",q_url);
	}
	if ( z_url ) {
		printf(" (gv-zoom \"%s\" \n",z_url);
		if ( tx && ty && bx && by ) {
			printf("  (List \n");
			printf("   (List %s %s ) \n",tx,ty);
			printf("   (List %s %s )))\n",bx,by);
		}
		else {
			printf("  )\n");
		}
	}
	printf(")\n");
	return;
}


void
gbtypes_x_y_reso()
{
char *_x;
char *_y;
char *_r;
double xx,yy,rr;
double ofs;

	_x = search_query("x",0);
	_y = search_query("y",0);
	_r = search_query("r",0);
	if ( _x == 0 ||  _y == 0 ||  _r == 0 )
		return;
	sscanf(_x,"%lf",&xx);
	sscanf(_y,"%lf",&yy);
	sscanf(_r,"%lf",&rr);
	ofs = 400/rr;

	tx = malloc(50);
	sprintf(tx,"%lf",xx - ofs);
	ty = malloc(50);
	sprintf(ty,"%lf",yy - ofs);
	bx = malloc(50);
	sprintf(bx,"%lf",xx + ofs);
	by = malloc(50);
	sprintf(by,"%lf",yy + ofs);
}

void
gbtypes()
{
char * zq_url;
	q_type = search_query("q-type","gv-insert-query");
	q_url = search_query("q-url",0);
	z_url = search_query("z-url",0);

	tx = search_query("tx",0);
	ty = search_query("ty",0);
	bx = search_query("bx",0);
	by = search_query("by",0);
	rotate = search_query("rotate","0");

	zq_url = search_query("zq-url",0);
	if ( zq_url )
		q_url = z_url = zq_url;

	gbtypes_x_y_reso();
}

int
main()
{
char * q;
	q = get_url_string(getenv("QUERY_STRING"));

	divide(q);
	gbtypes();
	output();
	exit(0);
	return 0;
}
