/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbgraph.h"
#include	"xl.h"
#include	"resource.h"

XL_SEXP * 
gbpoint2list(GB_POINT p)
{
	return List(	get_floating(p.x,0),
			get_floating(p.y,0),
			-1);
}

int
get_gbpoint(COORDINATE_UNIT * cu,GB_POINT * p,XL_SEXP * s)
{
XL_SEXP * x;
int er;
	x = get_el(s,0);
	switch ( get_type(x) ) {
	case XLT_ERROR:
		return -1;
	case XLT_INTEGER:
		if ( cu )
			p->x = conv_unit(
				&er,
				cu->uenv,
				x->integer.data,
				x->integer.unit,
				cu->unit);
		else	p->x = x->integer.data;
		break;
	case XLT_FLOAT:
		if ( cu )
			p->x = conv_unit(
				&er,
				cu->uenv,
				x->floating.data,
				x->floating.unit,
				cu->unit);
		else	p->x = x->floating.data;
		break;
	default:
		return -1;
	}
	x = get_el(s,1);
	switch ( get_type(x) ) {
	case XLT_ERROR:
		return -1;
	case XLT_INTEGER:
		if ( cu )
			p->y = conv_unit(
				&er,
				cu->uenv,
				x->integer.data,
				x->integer.unit,
				cu->unit);
		else	p->y = x->integer.data;
		break;
	case XLT_FLOAT:
		if ( cu )
			p->y = conv_unit(
				&er,
				cu->uenv,
				x->floating.data,
				x->floating.unit,
				cu->unit);
		else	p->y = x->floating.data;
		break;
	default:
		return -1;
	}
	return 0;
}

GB_POINT
list2gbpoint(COORDINATE_UNIT * cu,XL_SEXP * s)
{
GB_POINT ret;
	get_gbpoint(cu,&ret,s);
	return ret;
}

int
get_minrect(COORDINATE_UNIT * cu,GB_RECT * r,XL_SEXP * s)
{
int er;
	er = get_gbpoint(cu,&r->tl,get_el(s,0));
	if ( er < 0 )
		return er;
	return get_gbpoint(cu,&r->br,get_el(s,1));
}
