/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___BLACKLIST_H___
#define ___BLACKLIST_H___

#define BLS_OK		0
#define BLS_PROCESSING	1
#define BLS_ERROR	2

#define BLT_RESOLVE	0
#define BLT_CONNECT	1
#define BLT_MAX		2

#define BL_INTERVAL_MAX		(48*3600)

typedef struct bl_state {
	char			state;
	int			(*func)();
} BL_STATE;

typedef struct blacklist {
	struct blacklist *	next;
	void *			name;
	int			name_len;
	BL_STATE		state[BLT_MAX];
	short			port;
	unsigned int		polling_initial;
	unsigned int		polling_time;
	unsigned int		polling_interval;
} BLACKLIST;



typedef struct bl_cmd {
	void *		name;
	int		name_len;
	int		type;
	int		(*retry)();
	int		(*proc)();
} BL_CMD;

#endif

