/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___MEMORY_DEBUG_H___
#define ___MEMORY_DEBUG_H___


typedef struct mem_free_info {
	struct mem_free_info *	next;
	struct mem_free_info *	time_next;
	unsigned int		ptr;
	char *			file;
	int			line;
} MEM_FREE_INFO;

typedef struct mem_list {
	struct mem_list *	next;
	char *			file;
	int 			line;
	int			size;
	struct mem_list *	max_next;
} MEM_LIST;


void * xx_d_alloc(int size,char *,int);
void * xx_d_calloc(int size,int el,char *, int);
void xx_d_f_ree(void *,char *,int);
MEM_LIST * get_mem_debug_list(MEM_LIST * m);


void init_d_alloc();
#define d_alloc(s)	xx_d_alloc((s),__FILE__,__LINE__)
void *	d_re_alloc(void * ptr,int size);
#define d_calloc(s,el)	xx_d_calloc((s),(el),__FILE__,__LINE__)
#define d_f_ree(x)	xx_d_f_ree((x),__FILE__,__LINE__)



#endif
