/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"proxy.h"

XL_SEXP * xl_SetNativeProxy();
SERVER_LIST * get_da_server(L_CHAR * da_list);

void
init_SetNativeProxy(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetNativeProxy"),
		get_func_prim(xl_SetNativeProxy,FO_APPLICATIVE,0,1,1));
}




XL_SEXP *
xl_SetNativeProxy(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
L_CHAR * type;
L_CHAR * da_servers;
L_CHAR * proxy_server;
L_CHAR * proxy_port;
L_CHAR * da_list;
L_CHAR * keep_alive;
URL u;
char _type;
SERVER_LIST * sl, * sl2;
	type = get_sf_attribute(sf,l_string(std_cm,"type"));
	if ( l_strcmp(type,l_string(std_cm,"NoProxy")) == 0 )
		_type = PT_NO_PROXY;
	else if ( l_strcmp(type,l_string(std_cm,"HTTPProxy")) == 0 )
		_type = PT_HTTP_PROXY;
	else if ( l_strcmp(type,l_string(std_cm,"NativeProxy")) == 0 )
		_type = PT_NATIVE_PROXY;
	else if ( l_strcmp(type,l_string(std_cm,"XLoHTTP")) == 0 )
		_type = PT_XLoHTTP;
	else {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"SetNativeProxy"),
			n_get_string("invalid proxy type"));
			
	}

	da_list = get_sf_attribute(sf,l_string(std_cm,"direct"));
	if ( da_list )
		goto da_proc;

	if ( (_type&(PT_NO_PROXY|PT_NATIVE_PROXY))
			== 0 )
		goto inv_type;

	proxy_server = get_sf_attribute(sf,l_string(std_cm,"server"));
	if ( proxy_server ) {
		proxy_port = get_sf_attribute(sf,l_string(std_cm,"port"));
		if ( proxy_port == 0 )
			goto inv_proxy_port;
		memset(&u,0,sizeof(u));
		u.port = atoi(n_string(std_cm,proxy_port));
		u.server = ll_copy_str(proxy_server);
		u.proto = nl_copy_str(std_cm,"xlp");
		u.db = nl_copy_str(std_cm,"/");
		u.resource = 0;
	}
	else {
		memset(&u,0,sizeof(u));
	}
	set_native_proxy(&u);
	return 0;
da_proc:
	if ( (_type&(PT_NO_PROXY|PT_XLoHTTP)) == 0 )
		goto inv_type;
	sl = get_da_server(da_list);
	if ( sl == 0 )
		goto inv_da_list;
	for ( sl2 = sl ; sl2 ; sl2 = sl2->next )
		set_native_proxy_direct_access(l_string(std_cm,sl2->name));
	free_server_list(sl);
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SetNativeProxy"),
		0);
inv_proxy_server:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SetNativeProxy"),
		n_get_string("proxy server is required"));
inv_proxy_port:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SetNativeProxy"),
		n_get_string("proxy server port is required"));
inv_type:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SetNativeProxy"),
		List(
			n_get_string("invalid proxy type"),
			get_string(type),
			-1));
inv_da_list:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"SetNativeProxy"),
		n_get_string("invalid direct parameter"));
}


