-- create ticket table

CREATE TABLE ticket (
	ticketNumber	VARCHAR(15) PRIMARY KEY,
	couponNumber	VARCHAR(2),
	inwardNumber	VARCHAR(3),
	inwardId	VARCHAR(2),
	endorsement	VARCHAR(1024),
	issueDate	VARCHAR(8),
	issuePlace	VARCHAR(128),
	invoiceMonth	VARCHAR(8),
	origin		VARCHAR(3),
	destination	VARCHAR(3),
	currency	VARCHAR(3),
	ticketFare	NUMBER,
	salesCurrency	VARCHAR(3),
	salesFare	NUMBER,
	plusAdjustment	NUMBER,
	lessAdjustment	NUMBER,
	commissionCurrency	VARCHAR(3),
	commissionRate	NUMBER,
	commissionAmt	NUMBER,
	totalNuc	NUMBER,
	lessAmt		NUMBER,
	stopOverCharge	NUMBER,
	tourCode	VARCHAR(1024),
	agentCode	VARCHAR(128),
	fareCalculation	VARCHAR(4096),
	airwayNumber	VARCHAR(3),
	airwayId	VARCHAR(2),
	roeRate		NUMBER,
	day5Rate	NUMBER,
	meanRate	NUMBER,
	fixedFare	NUMBER,
	amountRatio	NUMBER,
	plusFlg		CHAR,
	errorFlag	NUMBER,
	errorString	VARCHAR(1024)
);

-- create sector table

CREATE TABLE sector (
	id		NUMBER PRIMARY KEY,
	ticketNumber	VARCHAR(15) NOT NULL,
	sequenceNo	NUMBER NOT NULL,
	stopOver	NUMBER,
	depCode		VARCHAR(3),
	destCode	VARCHAR(3),
	fareBasis	VARCHAR(128),
	carrier		VARCHAR(2),
	classOfService	VARCHAR(1),
	flightDate	VARCHAR(8),
	depTime		VARCHAR(4),
	fareComponent	NUMBER,
	flightNo	VARCHAR(4),
	classDiffPlus	NUMBER,
	secureCharge	NUMBER,
	sideTripPlus	NUMBER,
	stopOverPlus	NUMBER,
	prorateFactor	NUMBER,
	tax		NUMBER,
	taxIndex	NUMBER,
	taxInLocal	NUMBER,
	commission	NUMBER,
	prorationType	NUMBER,
	spaBaseAmtType	VARCHAR(3),
	spaBaseAmt	NUMBER,
	spaDay5Rate	NUMBER,
	spaDiscountRate	NUMBER,
	spaClassDiff	NUMBER,
	apdpBaseAmtType	VARCHAR(3),
	apdpBaseAmt	NUMBER,
	apdpDay5Rate	NUMBER,
	apdpDiscountRate	NUMBER,
	apdpClassDiff	NUMBER,
	proratedClassDiff	NUMBER,
	exstPlus	NUMBER,
	proratedExstPlus	NUMBER,
	prorateError	NUMBER,
	spaNuc		NUMBER,
	apdpNuc		NUMBER,
	npPvalues	NUMBER,
	srpNuc		NUMBER,
	prorateValue	NUMBER,
	amountInLocal	NUMBER,
	invoiceValue	NUMBER,
	sideTripIndex	NUMBER,
	classDiffIndex	NUMBER,
	secureIndex	NUMBER,
	fixedFareCheck	NUMBER,
	fixedFareDiscount	NUMBER,
	componentIndex	NUMBER,
	componentKind	NUMBER,
	viaRouting	VARCHAR(2),
	fareType	NUMBER,
	depAirport	VARCHAR(3),
	destAirport	VARCHAR(3),
	opCarrier	VARCHAR(2),
	npClassDiff	NUMBER,
	secureChargeSaved	NUMBER,
	proratedSecureCharge	NUMBER,
	errorFlag	NUMBER,
	errorString	VARCHAR(1024),
	fixValue	NUMBER,
	fixCurrency	VARCHAR(3),
	fixAmount	NUMBER,
	invoiceFlg	CHAR,
	certainty	NUMBER,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES ticket(ticketNumber)
);

-- create fcomp table

CREATE TABLE fcomp (
	id		NUMBER PRIMARY KEY,
	ticketNumber	VARCHAR(15) NOT NULL,
	componentIndex	NUMBER NOT NULL,
	value		NUMBER,
	kind		NUMBER,
	fixedFareDiscount	NUMBER,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES ticket(ticketNumber)
);

-- create tax table

CREATE TABLE tax (
	id		NUMBER PRIMARY KEY,
	ticketNumber	VARCHAR(15) NOT NULL,
	taxId		NUMBER NOT NULL,
	type		VARCHAR(8),
	value		NUMBER,
CONSTRAINT fk_sector
	FOREIGN KEY (ticketNumber) REFERENCES ticket(ticketNumber)
);
