/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.sourceforge.gnp.prorate.ProrateDatabase;
import jp.sourceforge.gnp.prorate.ProrateFcalc;
import jp.sourceforge.gnp.prorate.ProrateImpl;
import jp.sourceforge.gnp.prorate.ProrateRuleObjectFactory;
import jp.sourceforge.gnp.prorate.ProrateTax;
import jp.sourceforge.gnp.prorate.ProrateTaxImpl;
import jp.sourceforge.gnp.prorate.ProrateTrace;
import jp.sourceforge.gnp.prorate.ProrateTraceString;
import jp.sourceforge.gnp.prorate.database.ProrateRdb;
import jp.sourceforge.gnp.prorate.export.ProrateAudit;
import jp.sourceforge.gnp.prorate.export.ProrateSector;
import jp.sourceforge.gnp.prorate.export.ProrateTaxData;
import jp.sourceforge.gnp.prorate.fcalc.ProrateFCalcImpl;
import jp.sourceforge.gnp.rulebase.ProrateRulebase;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseElementFactory;
import jp.sourceforge.gnp.rulebase.ProrateRulebaseException;
import jp.sourceforge.gnp.rulebase.xml.XmlRulebaseLru;

class ProrateTestFile {
    BufferedReader stream;
    ProrateAudit audit;
    String ticketNumber;
    int ticketCoupon = -1;

    ProrateTestFile() {
        this.stream = null;
        this.audit = new ProrateAudit();
    }

    ProrateTestFile(String filename) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            System.out.print(filename);
            System.out.println(" not found");
            System.exit(100);
        }
        this.stream = new BufferedReader(new InputStreamReader(in));
        this.audit = new ProrateAudit();
    }

    void inputAudit() {
        String str = "";
        this.audit.setOwnAudit(false);
        this.audit.setInward(false);
        this.audit.setTicketing(false);
        this.audit.setNotRuleApply(false);
        this.audit.setNonProrateRest(false);
        this.audit.setOneComponent(false);
        this.audit.setIgnoreFareCalc(false);
        this.audit.setTourCode("");
        this.audit.setAgentCode("");
        str = this.readLine("ticket_number etc :");
        StringTokenizer getTok = new StringTokenizer(str);
        if (getTok.hasMoreTokens()) {
            this.ticketNumber = getTok.nextToken();
            this.audit.setAirwayNumber(this.ticketNumber.substring(0, 3));
        }
        if (getTok.hasMoreTokens()) {
            this.ticketCoupon = Integer.parseInt(getTok.nextToken());
        }
        if (this.ticketCoupon < 0) {
            this.audit.setOwnAudit(true);
            this.audit.setTicketing(true);
        }
        if (getTok.hasMoreTokens()) {
            this.audit.setInwardNumber(getTok.nextToken());
        } else {
            this.audit.setInwardNumber("");
        }
        if (!(this.audit.getInwardNumber().equals("") || this.audit.getInwardNumber().equals("0") || this.audit.getInwardNumber().equals("-1"))) {
            this.audit.setOwnAudit(true);
            this.audit.setInward(true);
        }
        str = this.readLine("endorsement :");
        this.audit.setEndorsement(str);
        str = this.readLine("place_issue, date of issue :");
        getTok = new StringTokenizer(str);
        if (getTok.hasMoreTokens()) {
            this.audit.setIssuePlace(getTok.nextToken());
        }
        if (getTok.hasMoreTokens()) {
            this.audit.setIssueDate(getTok.nextToken());
        }
        if (this.audit.getIssueDate().length() >= 6) {
            this.audit.setInvoiceMonth(this.audit.getIssueDate().substring(0, 6));
        } else {
            this.audit.setInvoiceMonth(this.audit.getIssueDate());
        }
        str = this.readLine("origin, destination :");
        this.audit.setCurrency("");
        this.audit.setTicketFare(0.0);
        this.audit.setTotalNuc(0.0);
        this.audit.setStopOverCharge(0.0);
        this.audit.setSalesCurrency("");
        this.audit.setSalesFare(0.0);
        str = this.readLine("fare, total nuc :");
        getTok = new StringTokenizer(str);
        if (getTok.hasMoreTokens()) {
            this.audit.setCurrency(getTok.nextToken());
        }
        if (getTok.hasMoreTokens()) {
            this.audit.setTicketFare(Double.parseDouble(getTok.nextToken()));
        }
        if (getTok.hasMoreTokens()) {
            this.audit.setTotalNuc(Double.parseDouble(getTok.nextToken()));
        }
        if (getTok.hasMoreTokens()) {
            this.audit.setStopOverCharge(Double.parseDouble(getTok.nextToken()));
        }
        if (this.audit.isOwnAudit() && this.audit.isTicketing()) {
            if (this.audit.getSalesCurrency().equals("")) {
                this.audit.setSalesCurrency(this.audit.getCurrency());
            }
            if (this.audit.getSalesFare() == 0.0) {
                this.audit.setSalesFare(this.audit.getTicketFare());
            }
        }
        this.audit.setCommissionCurrency(this.audit.getCurrency());
        this.audit.setCommissionRate(9.0);
        this.audit.setCommissionAmt(0.0);
        this.audit.setRoeRate(0.0);
        this.audit.setDay5Rate(0.0);
        this.audit.setLessAmt(0.0);
        this.audit.setPlusAdjustment(0.0);
        this.audit.setLessAdjustment(0.0);
        str = this.readLine("tax :");
        getTok = new StringTokenizer(str);
        if (getTok.hasMoreTokens()) {
            int i;
            this.audit.setNotDivideTax(false);
            int taxes = 0;
            Vector<ProrateTaxData> taxMiscs = new Vector<ProrateTaxData>();
            Vector<ProrateTaxData> tax3 = new Vector<ProrateTaxData>();
            while (getTok.hasMoreTokens()) {
                String taxStr = getTok.nextToken();
                int index = taxStr.indexOf(58);
                int padding = 1;
                if (index < 0) {
                    index = 2;
                    padding = 0;
                }
                String taxType = taxStr.substring(0, index);
                String taxAmountStr = taxStr.substring(index + padding);
                double taxAmount = Double.parseDouble(taxAmountStr);
                ProrateTaxData tax = new ProrateTaxData();
                tax.setType(taxType);
                tax.setAmount(taxAmount);
                taxMiscs.add(tax);
                if (taxes < 3) {
                    ProrateTaxData tax3Data = new ProrateTaxData();
                    tax3Data.setType(taxType);
                    tax3Data.setAmount(taxAmount);
                    tax3.add(tax3Data);
                }
                ++taxes;
            }
            ProrateTaxData[] taxMiscsArray = new ProrateTaxData[taxMiscs.size()];
            ProrateTaxData[] tax3Array = new ProrateTaxData[tax3.size()];
            for (i = 0; i < taxMiscs.size(); ++i) {
                taxMiscsArray[i] = (ProrateTaxData)taxMiscs.get(i);
            }
            for (i = 0; i < tax3.size(); ++i) {
                tax3Array[i] = (ProrateTaxData)tax3.get(i);
            }
            this.audit.setTaxMisc(taxMiscsArray);
            this.audit.setTax(tax3Array);
        }
        str = this.readLine("fare calculation :");
        this.audit.setFareCalculation(str);
        this.audit.setFixedFare(0.0);
        this.audit.setPlusFlg(false);
        this.audit.setOwnAirwayId("");
        Vector<ProrateSector> sectors = new Vector<ProrateSector>();
        this.audit.setComponents(null);
        this.audit.setAskTable(null);
        str = this.readLine(" number of sectors :");
        int noSectors = Integer.parseInt(str);
        for (int i = 0; i < noSectors; ++i) {
            String isClassDiff;
            ProrateSector sector = new ProrateSector();
            if (i == this.ticketCoupon) {
                sector.setInvoiceFlg(true);
            } else {
                sector.setInvoiceFlg(false);
            }
            sector.setSequenceNo(i);
            sector.setProrateValue(0.0);
            sector.setInvoiceValue(0.0);
            sector.setComponentIndex(0);
            sector.setComponentKind(0);
            sector.setFareComponent(0.0);
            sector.setSecureCharge(0.0);
            sector.setSecureIndex(0);
            sector.setClassDiffPlus(0.0);
            sector.setClassDiffIndex(0);
            str = this.readLine("sector info :");
            getTok = new StringTokenizer(str);
            if (getTok.hasMoreTokens()) {
                String from = getTok.nextToken();
                if (from.substring(0, 2).equals("X/")) {
                    sector.setStopOver((byte)88);
                    sector.setDepCode(from.substring(2));
                } else {
                    sector.setDepCode(from);
                }
            }
            if (getTok.hasMoreTokens()) {
                getTok.nextToken();
            }
            if (getTok.hasMoreTokens()) {
                String to = getTok.nextToken();
                if (to.substring(0, 2).equals("X/")) {
                    sector.setStopOver((byte)88);
                    sector.setDestCode(to.substring(2));
                } else {
                    sector.setDestCode(to);
                }
            }
            if (getTok.hasMoreTokens()) {
                sector.setFareBasis(getTok.nextToken());
            }
            if (getTok.hasMoreTokens()) {
                sector.setCarrier(getTok.nextToken());
            }
            if (getTok.hasMoreTokens()) {
                sector.setClassOfService(getTok.nextToken());
            }
            if (getTok.hasMoreTokens()) {
                String fareComponent = getTok.nextToken();
                sector.setFareComponent(Double.parseDouble(fareComponent));
                if (sector.getFareComponent() == -2.0) {
                    sector.setFareComponent(0.0);
                } else if (sector.getFareComponent() == 0.0) {
                    sector.setFareComponent(-1.0);
                }
            }
            if (getTok.hasMoreTokens()) {
                String flight_date = getTok.nextToken();
                int slash = flight_date.indexOf(47);
                if (slash >= 0) {
                    int month = Integer.parseInt(flight_date.substring(0, slash));
                    int day = 0;
                    if (flight_date.length() > slash + 1) {
                        day = Integer.parseInt(flight_date.substring(slash + 1));
                    }
                    String date = this.audit.getIssueDate().substring(0, 4) + (month < 10 ? "0" : "") + month + (day < 10 ? "0" : "") + day;
                    sector.setFlightDate(date);
                } else if (flight_date.length() >= 6) {
                    sector.setFlightDate(flight_date);
                } else if (flight_date.length() >= 5) {
                    sector.setFlightDate(this.audit.getIssueDate().substring(0, 4) + flight_date.substring(0, 2) + flight_date.substring(3, 5));
                } else {
                    sector.setFlightDate(this.audit.getIssueDate().substring(0, 4) + flight_date.substring(0, 2) + "01");
                }
            }
            if (getTok.hasMoreTokens()) {
                String secureCharge = getTok.nextToken();
                sector.setSecureCharge(Double.parseDouble(secureCharge));
                if (sector.getSecureCharge() > 0.0) {
                    sector.setSecureIndex(81);
                } else {
                    sector.setSecureIndex(0);
                }
            }
            if (getTok.hasMoreTokens()) {
                String classDiffPlus = getTok.nextToken();
                sector.setClassDiffPlus(Double.parseDouble(classDiffPlus));
            }
            if (getTok.hasMoreTokens() && Integer.parseInt(isClassDiff = getTok.nextToken()) > 1) {
                sector.setClassDiffIndex(68);
            }
            if (getTok.hasMoreTokens()) {
                String sideTripIndex = getTok.nextToken();
                sector.setSideTripIndex(Integer.parseInt(sideTripIndex));
                if (sector.getSideTripIndex() > 0) {
                    sector.setSideTripPlus(sector.getFareComponent());
                    sector.setFareComponent(-1.0);
                }
            }
            if (getTok.hasMoreTokens()) {
                sector.setFlightNo(getTok.nextToken());
            }
            sector.setStopOverPlus(0.0);
            sector.setProrateFactor(0.0);
            sector.setCommission(0.0);
            sector.setAmountInLocal(0.0);
            sector.setClassDiffIndex(0);
            sector.setViaRouting("");
            sector.setProrationType(0);
            sector.setCertainty(1.0);
            sector.setSpaBaseAmtType("");
            sector.setSpaBaseAmt(0.0);
            sector.setSpaDay5Rate(0.0);
            sector.setSpaDiscountRate(0.0);
            sector.setSpaClassDiff(0.0);
            sector.setNpPvalues(0.0);
            sector.setApdpBaseAmtType("");
            sector.setApdpBaseAmt(0.0);
            sector.setApdpDay5Rate(0.0);
            sector.setApdpDiscountRate(0.0);
            sector.setApdpClassDiff(0.0);
            sector.setProratedClassDiff(0.0);
            sector.setExstPlus(0.0);
            sector.setProratedExstPlus(0.0);
            sector.setSpaNuc(0.0);
            sector.setApdpNuc(0.0);
            sector.setSrpNuc(0.0);
            sector.setFixedFareCheck(0.0);
            sector.setFixedFareDiscount(0.0);
            sector.setFixCurrency("");
            sector.setFixValue(0.0);
            sector.setOpCarrier("");
            sector.setErrorFlag(0);
            sector.setErrorString("");
            sectors.add(sector);
        }
        ProrateSector[] sectorsArray = new ProrateSector[sectors.size()];
        for (int j = 0; j < sectors.size(); ++j) {
            sectorsArray[j] = (ProrateSector)sectors.get(j);
        }
        this.audit.setSectors(sectorsArray);
    }

    private String readLine(String message) {
        String str = "";
        System.err.println(message);
        try {
            str = this.stream.readLine();
        }
        catch (IOException e) {
            System.out.println("IO Error");
            System.exit(100);
        }
        if (str == null) {
            return "";
        }
        System.err.println(str);
        return str;
    }

    void printAudit() {
        int i;
        PrintStream out = System.out;
        out.println("<" + (this.audit.isInward() ? "Inw" : (this.audit.isOwnAudit() ? "Own" : "Out")) + ">TICKET# " + this.ticketNumber);
        out.println("ISSUED BY " + this.audit.getAirwayNumber() + ":" + this.audit.getAirwayId());
        out.println("ENDORSE: " + this.audit.getEndorsement() + "\tDATE OF ISSUE: " + this.audit.getIssueDate() + "\tPLACE: " + this.audit.getIssuePlace());
        out.println("FARE: " + this.audit.getCurrency() + " " + this.audit.getTicketFare() + " SALES: " + this.audit.getSalesCurrency() + " " + this.audit.getSalesFare() + " TOTAL-NUC: " + this.audit.getTotalNuc());
        out.println("COMMISSION: " + this.audit.getCommissionCurrency() + " " + this.audit.getCommissionAmt() + " rate " + this.audit.getCommissionRate());
        out.println("");
        out.println("ERROR: " + this.audit.getErrorFlag() + " " + this.audit.getErrorString());
        out.println("from - to car rou  fl# cl date     f-basis  secure differ sidetr fcomp");
        for (i = 0; i < this.audit.getSectors().length; ++i) {
            ProrateSector sector = this.audit.getSectors()[i];
            out.println("(" + sector.getSequenceNo() + ")" + sector.getDepCode() + "-" + sector.getDestCode() + " " + sector.getCarrier() + "()" + " " + sector.getFlightNo() + " " + sector.getClassOfService() + " " + sector.getFlightDate() + " " + sector.getFareBasis() + " " + sector.getSecureIndex() + ":" + sector.getSecureCharge() + " " + sector.getClassDiffIndex() + ":" + sector.getClassDiffPlus() + " " + sector.getSideTripIndex() + ":" + sector.getSideTripPlus() + " " + sector.getFareComponent() + " " + sector.getTax() + " " + sector.getTaxInLocal());
            out.println("(" + sector.getComponentKind() + ")" + "\tSPA(" + sector.getSpaDiscountRate() * 100.0 + "%of" + sector.getSpaBaseAmtType() + sector.getSpaBaseAmt() + ")" + sector.getSpaNuc() + ":\tAPDP(" + sector.getApdpDiscountRate() * 100.0 + "%of" + sector.getApdpBaseAmtType() + sector.getApdpBaseAmt() + ")" + sector.getApdpNuc() + "FIX" + sector.getFixedFareCheck() + "/" + sector.getFixedFareDiscount() + ":\tSRP" + sector.getSrpNuc());
            out.println("\tPRO-TYPE " + sector.getProrationType() + " PRO_FACTOR " + sector.getProrateFactor() + " PRO-VAL " + sector.getProrateValue() + " NP " + sector.getNpPvalues());
            out.println("\tDIFF " + sector.getClassDiffIndex() + ":" + sector.getProratedClassDiff() + " SEC " + sector.getSecureIndex() + ":" + sector.getProratedSecureCharge() + "/" + sector.getSecureChargeSaved());
            out.println("\tERROR: " + sector.getErrorFlag() + " " + sector.getErrorString());
        }
        out.println("FARE_CAL: " + this.audit.getFareCalculation());
        if (this.audit.getTraceStrings() != null) {
            out.println("TRACE: (level:" + this.audit.getTraceLevel() + ")");
            for (i = 0; i < this.audit.getTraceStrings().length; ++i) {
                String traceStr = this.audit.getTraceStrings()[i];
                out.println(traceStr);
            }
        }
    }

    public static void main(String[] args) throws ProrateRulebaseException {
        ProrateTestFile test2 = null;
        test2 = args.length > 0 ? new ProrateTestFile(args[0]) : new ProrateTestFile("test_ticket");
        int traceLevel = 10;
        if (args.length > 1) {
            traceLevel = Integer.parseInt(args[1]);
        }
        if (test2 == null) {
            return;
        }
        test2.inputAudit();
        test2.printAudit();
        test2.audit.setTraceLevel(traceLevel);
        System.err.println("traceLevel = " + test2.audit.getTraceLevel());
        XmlRulebaseLru rulebase = null;
        try {
            rulebase = new XmlRulebaseLru();
            XmlRulebaseLru.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            System.exit(1);
        }
        ProrateRuleObjectFactory factory = new ProrateRuleObjectFactory();
        rulebase.setElementFactory((ProrateRulebaseElementFactory)factory);
        ProrateImpl prorate = new ProrateImpl();
        prorate.setRulebase((ProrateRulebase)rulebase);
        prorate.setFcalc((ProrateFcalc)new ProrateFCalcImpl());
        prorate.setTax((ProrateTax)new ProrateTaxImpl());
        ProrateTraceString trace2 = new ProrateTraceString();
        prorate.setTrace((ProrateTrace)trace2);
        prorate.setDatabase((ProrateDatabase)new ProrateRdb());
        if (!prorate.getDatabase().openDatabase()) {
            System.err.println("proration service database initialization failed:" + prorate.getDatabase().getErrMessage());
            System.exit(1);
        }
        try {
            test2.audit = prorate.prorate(test2.audit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        prorate.getDatabase().closeDatabase();
        prorate.setDatabase(null);
        prorate.setTrace(null);
        prorate.setFcalc(null);
        prorate.setRulebase(null);
        prorate = null;
        test2.printAudit();
    }
}

