/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.commonlisp.lang.CommonLisp;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Symbol;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class defvar
extends Syntax {
    boolean force;

    public defvar(boolean force) {
        this.force = force;
    }

    @Override
    public boolean scanForDefinitions(Pair st, Vector forms, ScopeExp defs, Translator tr) {
        if (!(st.cdr instanceof Pair)) {
            return super.scanForDefinitions(st, forms, defs, tr);
        }
        Pair p = (Pair)st.cdr;
        Object name = p.car;
        if (name instanceof String || name instanceof Symbol) {
            Declaration decl = defs.lookup(name);
            if (decl == null) {
                decl = new Declaration(name);
                decl.setFlag(0x10000000);
                defs.addDeclaration(decl);
            } else {
                tr.error('w', "duplicate declaration for `" + name + "'");
            }
            p = Translator.makePair(p, decl, p.cdr);
            st = Translator.makePair(st, this, p);
            if (defs instanceof ModuleExp) {
                decl.setCanRead(true);
                decl.setCanWrite(true);
            }
        }
        forms.addElement(st);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        Object obj = form.cdr;
        Object name = null;
        Expression value = null;
        Declaration decl = null;
        if (obj instanceof Pair) {
            Pair p1 = (Pair)obj;
            if (p1.car instanceof Declaration) {
                decl = (Declaration)p1.car;
                name = decl.getSymbol();
                if (p1.cdr instanceof Pair) {
                    Pair p2 = (Pair)p1.cdr;
                    value = tr.rewrite(p2.car);
                    if (p2.cdr == LList.Empty) {
                        // empty if block
                    }
                } else if (p1.cdr != LList.Empty) {
                    name = null;
                }
            }
        }
        if (name == null) {
            return tr.syntaxError("invalid syntax for " + this.getName());
        }
        if (value == null) {
            if (!this.force) {
                return new QuoteExp(name);
            }
            value = CommonLisp.nilExpr;
        }
        SetExp sexp = new SetExp(name, value);
        if (!this.force) {
            sexp.setSetIfUnbound(true);
        }
        sexp.setDefining(true);
        if (decl != null) {
            sexp.setBinding(decl);
            if (decl.context instanceof ModuleExp && decl.getCanWrite()) {
                value = null;
            }
            decl.noteValue(value);
        }
        return sexp;
    }
}

