/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.BlockExitException;
import gnu.expr.BlockExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;

public class ExitExp
extends Expression {
    BlockExp block;
    Expression result;

    public ExitExp(Expression result, BlockExp block) {
        this.result = result;
        this.block = block;
    }

    public ExitExp(BlockExp block) {
        this.result = QuoteExp.voidExp;
        this.block = block;
    }

    @Override
    protected boolean mustCompile() {
        return false;
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        throw new BlockExitException(this, this.result.eval(ctx));
    }

    @Override
    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Expression res = this.result == null ? QuoteExp.voidExp : this.result;
        res.compileWithPosition(comp, this.block.subTarget);
        code.doPendingFinalizers(this.block.oldTryState);
        code.emitGoto(this.block.exitLabel);
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkExitExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.result = walker.walk(this.result);
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Exit", false, ")");
        out.writeSpaceFill();
        if (this.block == null || this.block.label == null) {
            out.print("<unknown>");
        } else {
            out.print(this.block.label.getName());
        }
        if (this.result != null) {
            out.writeSpaceLinear();
            this.result.print(out);
        }
        out.endLogicalBlock(")");
    }

    @Override
    public Type getType() {
        return Type.neverReturnsType;
    }
}

