/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.WrongType;

public class GenericProc
extends MethodProc {
    protected MethodProc[] methods;
    int count;
    int minArgs;
    int maxArgs;

    public GenericProc(String name) {
        this.setName(name);
    }

    public GenericProc() {
    }

    @Override
    public int numArgs() {
        return this.minArgs | this.maxArgs << 12;
    }

    protected synchronized void add(MethodProc[] procs) {
        int n = procs.length;
        if (this.methods == null) {
            this.methods = new MethodProc[n];
        }
        for (int i = 0; i < n; ++i) {
            this.add(procs[i]);
        }
    }

    public synchronized void add(MethodProc method) {
        MethodProc best;
        int i;
        if (this.methods == null) {
            this.methods = new MethodProc[8];
        } else if (this.count >= this.methods.length) {
            MethodProc[] copy = new MethodProc[2 * this.methods.length];
            System.arraycopy(this.methods, 0, copy, 0, this.count);
            this.methods = copy;
        }
        for (i = 0; i < this.count && (best = MethodProc.mostSpecific(method, this.methods[i])) != method; ++i) {
        }
        if (i < this.count) {
            System.arraycopy(this.methods, i, this.methods, i + 1, this.count - i);
        }
        this.methods[i] = method;
        int n = method.minArgs();
        if (n < this.minArgs || this.count == 0) {
            this.minArgs = n;
        }
        if ((n = method.maxArgs()) == -1 || n > this.maxArgs) {
            this.maxArgs = n;
        }
        ++this.count;
    }

    @Override
    public Object applyN(Object[] args) throws Throwable {
        if (this.count == 1) {
            return this.methods[0].applyN(args);
        }
        GenericProc.checkArgCount(this, args.length);
        CallContext ctx = CallContext.getInstance();
        for (int i = 0; i < this.count; ++i) {
            MethodProc method = this.methods[i];
            int m = method.matchN(args, ctx);
            if (m != 0) continue;
            return ctx.runUntilValue();
        }
        throw new WrongType((Procedure)this, -1, null);
    }

    @Override
    public int isApplicable(Type[] args) {
        int best = -1;
        int i = this.count;
        while (--i >= 0) {
            MethodProc method = this.methods[i];
            int result = method.isApplicable(args);
            if (result == 1) {
                return 1;
            }
            if (result != 0) continue;
            best = 0;
        }
        return best;
    }

    @Override
    public int match0(CallContext ctx) {
        if (this.count == 1) {
            return this.methods[0].match0(ctx);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc method = this.methods[i];
            int code = method.match0(ctx);
            if (code != 0) continue;
            return 0;
        }
        ctx.proc = null;
        return -1;
    }

    @Override
    public int match1(Object arg1, CallContext ctx) {
        if (this.count == 1) {
            return this.methods[0].match1(arg1, ctx);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc method = this.methods[i];
            int code = method.match1(arg1, ctx);
            if (code != 0) continue;
            return 0;
        }
        ctx.proc = null;
        return -1;
    }

    @Override
    public int match2(Object arg1, Object arg2, CallContext ctx) {
        if (this.count == 1) {
            return this.methods[0].match2(arg1, arg2, ctx);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc method = this.methods[i];
            int code = method.match2(arg1, arg2, ctx);
            if (code != 0) continue;
            return 0;
        }
        ctx.proc = null;
        return -1;
    }

    @Override
    public int match3(Object arg1, Object arg2, Object arg3, CallContext ctx) {
        if (this.count == 1) {
            return this.methods[0].match3(arg1, arg2, arg3, ctx);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc method = this.methods[i];
            int code = method.match3(arg1, arg2, arg3, ctx);
            if (code != 0) continue;
            return 0;
        }
        ctx.proc = null;
        return -1;
    }

    @Override
    public int match4(Object arg1, Object arg2, Object arg3, Object arg4, CallContext ctx) {
        if (this.count == 1) {
            return this.methods[0].match4(arg1, arg2, arg3, arg4, ctx);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc method = this.methods[i];
            int code = method.match4(arg1, arg2, arg3, arg4, ctx);
            if (code != 0) continue;
            return 0;
        }
        ctx.proc = null;
        return -1;
    }

    @Override
    public int matchN(Object[] args, CallContext ctx) {
        int code;
        int i;
        if (this.count == 1) {
            return this.methods[0].matchN(args, ctx);
        }
        int alen = args.length;
        Type[] atypes = new Type[alen];
        Language language = Language.getDefaultLanguage();
        for (int j = 0; j < alen; ++j) {
            Type atype;
            Object arg = args[j];
            if (arg == null) {
                atype = Type.nullType;
            } else {
                Class<?> aclass = arg.getClass();
                atype = language != null ? language.getTypeFor(aclass) : Type.make(aclass);
            }
            atypes[j] = atype;
        }
        int[] codes = new int[this.count];
        int defCount = 0;
        int maybeCount = 0;
        int bestIndex = -1;
        for (i = 0; i < this.count; ++i) {
            code = this.methods[i].isApplicable(atypes);
            if (defCount == 0 && code >= 0) {
                bestIndex = i;
            }
            if (code > 0) {
                ++defCount;
            } else if (code == 0) {
                ++maybeCount;
            }
            codes[i] = code;
        }
        if (defCount == 1 || defCount == 0 && maybeCount == 1) {
            return this.methods[bestIndex].matchN(args, ctx);
        }
        for (i = 0; i < this.count; ++i) {
            MethodProc method;
            code = codes[i];
            if (code < 0 || code == 0 && defCount > 0 || (code = (method = this.methods[i]).matchN(args, ctx)) != 0) continue;
            return 0;
        }
        ctx.proc = null;
        return -1;
    }

    public final void setProperties(Object[] args) {
        int alen = args.length;
        for (int i = 0; i < alen; ++i) {
            Object arg = args[i];
            if (arg instanceof Keyword) {
                String name = ((Keyword)arg).getName();
                Object value = args[++i];
                if (name == "name") {
                    this.setName(value.toString());
                    continue;
                }
                if (name == "method") {
                    this.add((MethodProc)value);
                    continue;
                }
                this.setProperty(name, value);
                continue;
            }
            this.add((MethodProc)arg);
        }
    }

    public static GenericProc make(Object[] args) {
        GenericProc result = new GenericProc();
        result.setProperties(args);
        return result;
    }
}

