/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.GenericProc;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleMethod;
import gnu.expr.PairClassType;
import gnu.expr.Target;
import gnu.kawa.functions.MakeList;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongArguments;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;

public class PrimProcedure
extends MethodProc
implements Inlineable {
    Type retType;
    Type[] argTypes;
    Method method;
    int op_code;
    char mode;
    LambdaExp source;
    Member member;
    private static ClassLoader systemClassLoader = PrimProcedure.class.getClassLoader();

    public final int opcode() {
        return this.op_code;
    }

    public Type getReturnType() {
        return this.retType;
    }

    public void setReturnType(Type retType) {
        this.retType = retType;
    }

    public boolean isSpecial() {
        return this.mode == 'P';
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return this.retType;
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean takesVarArgs() {
        if (this.method != null) {
            String name = this.method.getName();
            return name.endsWith("$V") || name.endsWith("$V$X");
        }
        return false;
    }

    public boolean takesContext() {
        return this.method != null && PrimProcedure.takesContext(this.method);
    }

    public static boolean takesContext(Method method) {
        return method.getName().endsWith("$X");
    }

    public final boolean isConstructor() {
        return this.opcode() == 183 && this.mode != 'P';
    }

    public boolean takesTarget() {
        return this.mode != '\u0000';
    }

    @Override
    public int numArgs() {
        int num = this.argTypes.length;
        if (this.takesTarget()) {
            ++num;
        }
        if (this.takesContext()) {
            --num;
        }
        return this.takesVarArgs() ? num - 1 + -4096 : num + (num << 12);
    }

    @Override
    public int match0(CallContext ctx) {
        return this.matchN(ProcedureN.noArgs, ctx);
    }

    @Override
    public int match1(Object arg1, CallContext ctx) {
        Object[] args = new Object[]{arg1};
        return this.matchN(args, ctx);
    }

    @Override
    public int match2(Object arg1, Object arg2, CallContext ctx) {
        Object[] args = new Object[]{arg1, arg2};
        return this.matchN(args, ctx);
    }

    @Override
    public int match3(Object arg1, Object arg2, Object arg3, CallContext ctx) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.matchN(args, ctx);
    }

    @Override
    public int match4(Object arg1, Object arg2, Object arg3, Object arg4, CallContext ctx) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.matchN(args, ctx);
    }

    @Override
    public int matchN(Object[] args, CallContext ctx) {
        Object extraArg;
        int nargs = args.length;
        boolean takesVarArgs = this.takesVarArgs();
        int fixArgs = this.minArgs();
        if (nargs < fixArgs) {
            return 0xFFF10000 | fixArgs;
        }
        if (!takesVarArgs && nargs > fixArgs) {
            return 0xFFF20000 | fixArgs;
        }
        int paramCount = this.argTypes.length;
        Type elementType = null;
        Object[] restArray = null;
        int extraCount = this.takesTarget() || this.isConstructor() ? 1 : 0;
        boolean takesContext = this.takesContext();
        Object[] rargs = new Object[paramCount];
        if (takesContext) {
            rargs[--paramCount] = ctx;
        }
        if (takesVarArgs) {
            Type restType = this.argTypes[paramCount - 1];
            if (restType == Compilation.scmListType) {
                rargs[paramCount - 1] = LList.makeList(args, fixArgs);
                nargs = fixArgs;
                elementType = Type.pointer_type;
            } else {
                ArrayType restArrayType = (ArrayType)restType;
                elementType = restArrayType.getComponentType();
                Class elementClass = elementType.getReflectClass();
                rargs[paramCount - 1] = restArray = (Object[])Array.newInstance(elementClass, nargs - fixArgs);
            }
        }
        if (this.isConstructor()) {
            extraArg = args[0];
        } else if (extraCount != 0) {
            try {
                extraArg = this.method.getDeclaringClass().coerceFromObject(args[0]);
            }
            catch (ClassCastException ex) {
                return -786431;
            }
        } else {
            extraArg = null;
        }
        for (int i = extraCount; i < args.length; ++i) {
            Type type;
            Object arg = args[i];
            Type type2 = type = i < fixArgs ? this.argTypes[i - extraCount] : elementType;
            if (type != Type.pointer_type) {
                try {
                    arg = type.coerceFromObject(arg);
                }
                catch (ClassCastException ex) {
                    return 0xFFF40000 | i + 1;
                }
            }
            if (i < fixArgs) {
                rargs[i - extraCount] = arg;
                continue;
            }
            if (restArray == null) continue;
            restArray[i - fixArgs] = arg;
        }
        ctx.value1 = extraArg;
        ctx.values = rargs;
        ctx.proc = this;
        return 0;
    }

    @Override
    public void apply(CallContext ctx) throws Throwable {
        int arg_count = this.argTypes.length;
        boolean is_constructor = this.isConstructor();
        boolean slink = is_constructor && this.method.getDeclaringClass().hasOuterLink();
        try {
            Object result;
            if (this.member == null) {
                Class clas = this.method.getDeclaringClass().getReflectClass();
                Class[] paramTypes = new Class[arg_count + (slink ? 1 : 0)];
                int i = arg_count;
                while (--i >= 0) {
                    paramTypes[i + (slink ? 1 : 0)] = this.argTypes[i].getReflectClass();
                }
                if (slink) {
                    paramTypes[0] = this.method.getDeclaringClass().getOuterLinkType().getReflectClass();
                }
                if (is_constructor) {
                    this.member = clas.getConstructor(paramTypes);
                } else if (this.method != Type.clone_method) {
                    this.member = clas.getMethod(this.method.getName(), paramTypes);
                }
            }
            if (is_constructor) {
                Object[] args = ctx.values;
                if (slink) {
                    int nargs = args.length + 1;
                    Object[] xargs = new Object[nargs];
                    System.arraycopy(args, 0, xargs, 1, nargs - 1);
                    xargs[0] = ((PairClassType)ctx.value1).staticLink;
                    args = xargs;
                }
                result = ((Constructor)this.member).newInstance(args);
            } else if (this.method == Type.clone_method) {
                Object arr = ctx.value1;
                Class<?> elClass = arr.getClass().getComponentType();
                int n = Array.getLength(arr);
                result = Array.newInstance(elClass, n);
                System.arraycopy(arr, 0, result, 0, n);
            } else {
                result = this.retType.coerceToObject(((java.lang.reflect.Method)this.member).invoke(ctx.value1, ctx.values));
            }
            if (!this.takesContext()) {
                ctx.consumer.writeObject(result);
            }
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public PrimProcedure(String className, String methodName, int numArgs) {
        this(ClassType.make(className).getDeclaredMethod(methodName, numArgs));
    }

    public PrimProcedure(java.lang.reflect.Method method, Language language) {
        this(((ClassType)language.getTypeFor(method.getDeclaringClass())).getMethod(method), language);
    }

    public PrimProcedure(Method method) {
        this.init(method);
        this.retType = method.getName().endsWith("$X") ? Type.pointer_type : method.getReturnType();
    }

    public PrimProcedure(Method method, Language language) {
        this(method, '\u0000', language);
    }

    public PrimProcedure(Method method, char mode, Language language) {
        this.mode = mode;
        this.init(method);
        Type[] pTypes = this.argTypes;
        int nTypes = pTypes.length;
        this.argTypes = null;
        int i = nTypes;
        while (--i >= 0) {
            Type langType;
            Type javaType = pTypes[i];
            if (javaType instanceof ClassType && !((ClassType)javaType).isExisting() || javaType == (langType = language.getLangTypeFor(javaType))) continue;
            if (this.argTypes == null) {
                this.argTypes = new Type[nTypes];
                System.arraycopy(pTypes, 0, this.argTypes, 0, nTypes);
            }
            this.argTypes[i] = langType;
        }
        if (this.argTypes == null) {
            this.argTypes = pTypes;
        }
        if (this.isConstructor()) {
            this.retType = method.getDeclaringClass();
        } else if (method.getName().endsWith("$X")) {
            this.retType = Type.pointer_type;
        } else {
            this.retType = language.getLangTypeFor(method.getReturnType());
            if (this.retType == Type.tostring_type) {
                this.retType = Type.string_type;
            }
        }
    }

    private void init(Method method) {
        this.method = method;
        int flags = method.getModifiers();
        if ((flags & 8) != 0) {
            this.op_code = 184;
        } else {
            ClassType mclass = method.getDeclaringClass();
            if (this.mode == 'P') {
                this.op_code = 183;
            } else {
                this.mode = (char)86;
                this.op_code = "<init>".equals(method.getName()) ? 183 : ((mclass.getModifiers() & 0x200) != 0 ? 185 : 182);
            }
        }
        Type[] mtypes = method.getParameterTypes();
        if (this.isConstructor() && method.getDeclaringClass().hasOuterLink()) {
            int len = mtypes.length - 1;
            Type[] types = new Type[len];
            System.arraycopy(mtypes, 1, types, 0, len);
            mtypes = types;
        }
        this.argTypes = mtypes;
    }

    public PrimProcedure(Method method, LambdaExp source) {
        this(method);
        this.retType = source.getReturnType();
        this.source = source;
    }

    public PrimProcedure(int opcode, Type retType, Type[] argTypes) {
        this.op_code = opcode;
        this.retType = retType;
        this.argTypes = argTypes;
    }

    public static PrimProcedure makeBuiltinUnary(int opcode, Type type) {
        Type[] args = new Type[]{type};
        return new PrimProcedure(opcode, type, args);
    }

    public static PrimProcedure makeBuiltinBinary(int opcode, Type type) {
        Type[] args = new Type[]{type, type};
        return new PrimProcedure(opcode, type, args);
    }

    public PrimProcedure(int op_code, ClassType classtype, String name, Type retType, Type[] argTypes) {
        this.op_code = op_code;
        this.method = classtype.addMethod(name, op_code == 184 ? 8 : 0, argTypes, retType);
        this.retType = retType;
        this.argTypes = argTypes;
        this.mode = (char)(op_code == 184 ? 0 : 86);
    }

    public final boolean getStaticFlag() {
        return this.method == null || this.method.getStaticFlag() || this.isConstructor();
    }

    public final Type[] getParameterTypes() {
        return this.argTypes;
    }

    private void compileArgs(Expression[] args, int startArg, Type thisType, Compilation comp) {
        Declaration argDecl;
        boolean variable = this.takesVarArgs();
        String name = this.getName();
        Type arg_type = null;
        CodeAttr code = comp.getCode();
        int skipArg = thisType == Type.void_type ? 1 : 0;
        int arg_count = this.argTypes.length - skipArg;
        if (this.takesContext()) {
            --arg_count;
        }
        boolean is_static = thisType == null || skipArg != 0;
        int fix_arg_count = variable ? arg_count - 1 : args.length - startArg;
        Declaration declaration = argDecl = this.source == null ? null : this.source.firstDecl();
        if (argDecl != null && argDecl.isThisParameter()) {
            argDecl = argDecl.nextDecl();
        }
        int i = 0;
        while (true) {
            if (variable && i == fix_arg_count) {
                arg_type = this.argTypes[arg_count - 1 + skipArg];
                if (arg_type == Compilation.scmListType) {
                    MakeList.compile(args, startArg + i, comp);
                    break;
                }
                code.emitPushInt(args.length - startArg - fix_arg_count);
                arg_type = ((ArrayType)arg_type).getComponentType();
                code.emitNewArray(arg_type);
            }
            if (i + startArg >= args.length) break;
            if (i >= fix_arg_count) {
                code.emitDup(1);
                code.emitPushInt(i - fix_arg_count);
            } else {
                arg_type = argDecl != null && (is_static || i > 0) ? argDecl.getType() : (is_static ? this.argTypes[i + skipArg] : (i == 0 ? thisType : this.argTypes[i - 1]));
            }
            comp.usedClass(arg_type);
            Target target = this.source == null ? CheckedTarget.getInstance(arg_type, name, i + 1) : CheckedTarget.getInstance(arg_type, this.source, i);
            args[startArg + i].compileNotePosition(comp, target, args[startArg + i]);
            if (i >= fix_arg_count) {
                code.emitArrayStore(arg_type);
            }
            if (argDecl != null && (is_static || i > 0)) {
                argDecl = argDecl.nextDecl();
            }
            ++i;
        }
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        String arg_error;
        CodeAttr code = comp.getCode();
        ClassType mclass = this.method == null ? null : this.method.getDeclaringClass();
        Expression[] args = exp.getArgs();
        if (this.isConstructor()) {
            code.emitNew(mclass);
            code.emitDup(mclass);
        }
        if ((arg_error = WrongArguments.checkArgCount(this, args.length)) != null) {
            comp.error('e', arg_error);
        }
        this.compile(this.getStaticFlag() ? null : mclass, exp, comp, target);
    }

    void compile(Type thisType, ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        Type stackType = this.retType;
        int startArg = 0;
        if (this.isConstructor()) {
            ClassType mclass;
            ClassType classType = mclass = this.method == null ? null : this.method.getDeclaringClass();
            if (mclass.hasOuterLink()) {
                args[0].compile(comp, Target.pushValue(Compilation.typeClassType));
                code.emitInvokeStatic(ClassType.make("gnu.expr.PairClassType").getDeclaredMethod("extractStaticLink", 1));
                code.emitCheckcast(mclass.getOuterLinkType());
                thisType = Type.void_type;
            } else {
                thisType = null;
            }
            startArg = 1;
        } else if (this.takesTarget() && this.method.getStaticFlag()) {
            startArg = 1;
        }
        this.compileArgs(args, startArg, thisType, comp);
        if (this.method == null) {
            code.emitPrimop(this.opcode(), args.length, this.retType);
            target.compileFromStack(comp, stackType);
        } else {
            PrimProcedure.compileInvoke(comp, this.method, target, exp.isTailCall(), this.op_code, stackType);
        }
    }

    public static void compileInvoke(Compilation comp, Method method, Target target, boolean isTailCall, int op_code, Type stackType) {
        CodeAttr code = comp.getCode();
        comp.usedClass(method.getDeclaringClass());
        comp.usedClass(method.getReturnType());
        if (!PrimProcedure.takesContext(method)) {
            code.emitInvokeMethod(method, op_code);
        } else {
            if (target instanceof IgnoreTarget || target instanceof ConsumerTarget && ((ConsumerTarget)target).isContextTarget()) {
                Field consumerFld = null;
                Variable saveCallContext = null;
                comp.loadCallContext();
                if (target instanceof IgnoreTarget) {
                    ClassType typeCallContext = Compilation.typeCallContext;
                    consumerFld = typeCallContext.getDeclaredField("consumer");
                    code.pushScope();
                    saveCallContext = code.addLocal(typeCallContext);
                    code.emitDup();
                    code.emitGetField(consumerFld);
                    code.emitStore(saveCallContext);
                    code.emitDup();
                    code.emitGetStatic(ClassType.make("gnu.lists.VoidConsumer").getDeclaredField("instance"));
                    code.emitPutField(consumerFld);
                }
                code.emitInvokeMethod(method, op_code);
                if (isTailCall) {
                    comp.loadCallContext();
                    code.emitInvoke(Compilation.typeCallContext.getDeclaredMethod("runUntilDone", 0));
                }
                if (target instanceof IgnoreTarget) {
                    comp.loadCallContext();
                    code.emitLoad(saveCallContext);
                    code.emitPutField(consumerFld);
                    code.popScope();
                }
                return;
            }
            comp.loadCallContext();
            stackType = Type.pointer_type;
            code.pushScope();
            Variable saveIndex = code.addLocal(Type.int_type);
            comp.loadCallContext();
            code.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("startFromContext", 0));
            code.emitStore(saveIndex);
            code.emitWithCleanupStart();
            code.emitInvokeMethod(method, op_code);
            code.emitWithCleanupCatch(null);
            comp.loadCallContext();
            code.emitLoad(saveIndex);
            code.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("cleanupFromContext", 1));
            code.emitWithCleanupDone();
            comp.loadCallContext();
            code.emitLoad(saveIndex);
            code.emitInvokeVirtual(Compilation.typeCallContext.getDeclaredMethod("getFromContext", 1));
            code.popScope();
        }
        target.compileFromStack(comp, stackType);
    }

    @Override
    public Type getParameterType(int index) {
        int lenTypes;
        if (this.takesTarget()) {
            if (index == 0) {
                return this.isConstructor() ? Type.pointer_type : this.method.getDeclaringClass();
            }
            --index;
        }
        if (index < (lenTypes = this.argTypes.length) - 1) {
            return this.argTypes[index];
        }
        boolean varArgs = this.takesVarArgs();
        if (index < lenTypes && !varArgs) {
            return this.argTypes[index];
        }
        Type restType = this.argTypes[lenTypes - 1];
        if (restType instanceof ArrayType) {
            return ((ArrayType)restType).getComponentType();
        }
        return Type.pointer_type;
    }

    public static PrimProcedure getMethodFor(Procedure pproc, Expression[] args) {
        return PrimProcedure.getMethodFor(pproc, null, args, Language.getDefaultLanguage());
    }

    public static PrimProcedure getMethodFor(Procedure pproc, Declaration decl, Expression[] args, Language language) {
        int nargs = args.length;
        Type[] atypes = new Type[nargs];
        int i = nargs;
        while (--i >= 0) {
            atypes[i] = args[i].getType();
        }
        return PrimProcedure.getMethodFor(pproc, decl, atypes, language);
    }

    public static PrimProcedure getMethodFor(Procedure pproc, Declaration decl, Type[] atypes, Language language) {
        PrimProcedure prproc;
        if (pproc instanceof GenericProc) {
            GenericProc gproc = (GenericProc)pproc;
            MethodProc[] methods = gproc.methods;
            pproc = null;
            int i = gproc.count;
            while (--i >= 0) {
                int applic = methods[i].isApplicable(atypes);
                if (applic < 0) continue;
                if (pproc != null) {
                    return null;
                }
                pproc = methods[i];
            }
            if (pproc == null) {
                return null;
            }
        }
        if (pproc instanceof PrimProcedure && (prproc = (PrimProcedure)pproc).isApplicable(atypes) >= 0) {
            return prproc;
        }
        Class pclass = PrimProcedure.getProcedureClass(pproc);
        if (pclass == null) {
            return null;
        }
        return PrimProcedure.getMethodFor((ClassType)Type.make(pclass), pproc.getName(), decl, atypes, language);
    }

    public static Class getProcedureClass(Object pproc) {
        Class<?> procClass = pproc instanceof ModuleMethod ? ((ModuleMethod)pproc).module.getClass() : pproc.getClass();
        try {
            if (procClass.getClassLoader() == systemClassLoader) {
                return procClass;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static PrimProcedure getMethodFor(Class procClass, String name, Declaration decl, Expression[] args, Language language) {
        return PrimProcedure.getMethodFor((ClassType)Type.make(procClass), name, decl, args, language);
    }

    public static PrimProcedure getMethodFor(ClassType procClass, String name, Declaration decl, Expression[] args, Language language) {
        int nargs = args.length;
        Type[] atypes = new Type[nargs];
        int i = nargs;
        while (--i >= 0) {
            atypes[i] = args[i].getType();
        }
        return PrimProcedure.getMethodFor(procClass, name, decl, atypes, language);
    }

    public static PrimProcedure getMethodFor(ClassType procClass, String name, Declaration decl, Type[] atypes, Language language) {
        PrimProcedure best = null;
        int bestCode = -1;
        boolean bestIsApply = false;
        try {
            if (name == null) {
                return null;
            }
            String mangledName = Compilation.mangleName(name);
            String mangledNameV = mangledName + "$V";
            String mangledNameVX = mangledName + "$V$X";
            String mangledNameX = mangledName + "$X";
            boolean applyOk = true;
            for (Method meth = procClass.getDeclaredMethods(); meth != null; meth = meth.getNext()) {
                boolean isApply;
                int mods = meth.getModifiers();
                if ((mods & 9) != 9 && (decl == null || decl.base == null)) continue;
                String mname = meth.getName();
                if (mname.equals(mangledName) || mname.equals(mangledNameV) || mname.equals(mangledNameX) || mname.equals(mangledNameVX)) {
                    isApply = false;
                } else {
                    if (!applyOk || !mname.equals("apply") && !mname.equals("apply$V")) continue;
                    isApply = true;
                }
                if (!isApply) {
                    applyOk = false;
                    if (bestIsApply) {
                        best = null;
                        bestCode = -1;
                        bestIsApply = false;
                    }
                }
                PrimProcedure prproc = new PrimProcedure(meth, language);
                prproc.setName(name);
                int code = prproc.isApplicable(atypes);
                if (code < 0 || code < bestCode) continue;
                if (code > bestCode) {
                    best = prproc;
                } else if (best != null && (best = (PrimProcedure)MethodProc.mostSpecific(best, prproc)) == null && bestCode > 0) {
                    return null;
                }
                bestCode = code;
                bestIsApply = isApply;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return best;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        name = this.getVerboseName();
        this.setName(name);
        return name;
    }

    public String getVerboseName() {
        StringBuffer buf = new StringBuffer(100);
        if (this.method == null) {
            buf.append("<op ");
            buf.append(this.op_code);
            buf.append('>');
        } else {
            buf.append(this.method.getDeclaringClass().getName());
            buf.append('.');
            buf.append(this.method.getName());
        }
        buf.append('(');
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.argTypes[i].getName());
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.retType.getName());
        buf.append(' ');
        buf.append(this.getVerboseName());
        return buf.toString();
    }

    public void print(PrintWriter ps) {
        ps.print("#<primitive procedure ");
        ps.print(this.toString());
        ps.print('>');
    }
}

