/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.PrimProcedure;
import gnu.expr.ReferenceExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.lists.AbstractFormat;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;

public class QuoteExp
extends Expression {
    Object value;
    protected Type type;
    public static QuoteExp undefined_exp = new QuoteExp(Special.undefined);
    public static QuoteExp voidExp = new QuoteExp(Values.empty, Type.void_type);
    public static QuoteExp trueExp = new QuoteExp(Boolean.TRUE);
    public static QuoteExp falseExp = new QuoteExp(Boolean.FALSE);
    public static QuoteExp nullExp = new QuoteExp(null, Type.nullType);

    public final Object getValue() {
        return this.value;
    }

    @Override
    public final Object valueIfConstant() {
        return this.value;
    }

    @Override
    public final Type getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.value == Values.empty) {
            return Type.void_type;
        }
        if (this.value == null) {
            return Type.nullType;
        }
        if (this == undefined_exp) {
            return Type.pointer_type;
        }
        return Type.make(this.value.getClass());
    }

    public static QuoteExp getInstance(Object value) {
        if (value == null) {
            return nullExp;
        }
        if (value == Special.undefined) {
            return undefined_exp;
        }
        if (value == Values.empty) {
            return voidExp;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? trueExp : falseExp;
        }
        return new QuoteExp(value);
    }

    public QuoteExp(Object val) {
        this.value = val;
    }

    public QuoteExp(Object val, Type type) {
        this.value = val;
        this.type = type;
    }

    @Override
    protected boolean mustCompile() {
        return false;
    }

    @Override
    public void apply(CallContext ctx) {
        ctx.writeValue(this.value);
    }

    @Override
    public void compile(Compilation comp, Target target) {
        if (this.type == null || this.type == Type.pointer_type || target instanceof IgnoreTarget || this.type instanceof ObjectType && this.type.isInstance(this.value)) {
            comp.compileConstant(this.value, target);
        } else {
            comp.compileConstant(this.value, StackTarget.getInstance(this.type));
            target.compileFromStack(comp, this.type);
        }
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkQuoteExp(this);
    }

    @Override
    public Expression inline(ApplyExp exp, InlineCalls walker, Declaration decl) {
        Expression e;
        if (this == undefined_exp) {
            return exp;
        }
        Object fval = this.getValue();
        if (!(fval instanceof Procedure)) {
            return walker.noteError(decl == null || fval == null ? "called value is not a procedure" : "calling " + decl.getName() + " which is a " + fval.getClass().getName());
        }
        Procedure proc = (Procedure)fval;
        int nargs = exp.getArgCount();
        String msg = WrongArguments.checkArgCount(proc, nargs);
        if (msg != null) {
            return walker.noteError(msg);
        }
        if (proc instanceof CanInline) {
            return ((CanInline)((Object)proc)).inline(exp, walker);
        }
        if (exp.getFlag(2) && (e = exp.inlineIfConstant(proc, walker)) != exp) {
            return walker.walk(e);
        }
        Compilation comp = walker.getCompilation();
        if (comp.inlineOk(proc)) {
            if (proc instanceof Inlineable) {
                if (exp.getFunction() == this) {
                    return exp;
                }
                return new ApplyExp(this, exp.getArgs()).setLine(exp);
            }
            PrimProcedure mproc = PrimProcedure.getMethodFor(proc, decl, exp.args, comp.getLanguage());
            if (mproc != null) {
                ApplyExp nexp;
                if (mproc.getStaticFlag() || decl == null) {
                    nexp = new ApplyExp(mproc, exp.args);
                } else {
                    if (decl.base == null) {
                        return exp;
                    }
                    Expression[] margs = new Expression[1 + nargs];
                    System.arraycopy(exp.getArgs(), 0, margs, 1, nargs);
                    margs[0] = new ReferenceExp(decl.base);
                    nexp = new ApplyExp(mproc, margs);
                }
                return nexp.setLine(exp);
            }
        }
        return exp;
    }

    @Override
    public boolean side_effects() {
        return false;
    }

    @Override
    public String toString() {
        return "QuoteExp[" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Quote", ")", 2);
        out.writeSpaceLinear();
        if (this.value instanceof Expression) {
            this.value = this.value.toString();
        }
        AbstractFormat saveFormat = out.objectFormat;
        try {
            out.objectFormat = Language.getDefaultLanguage().getFormat(true);
            out.print(this.value);
        }
        finally {
            out.objectFormat = saveFormat;
        }
        out.endLogicalBlock(")");
    }
}

