/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.functions.ApplyToArgs;
import gnu.kawa.functions.SetArray;
import gnu.kawa.functions.SetArrayExp;
import gnu.kawa.functions.SetList;
import gnu.kawa.functions.SetListExp;
import gnu.mapping.HasSetter;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure1;
import java.io.Externalizable;
import java.util.List;

public class Setter
extends Procedure1
implements CanInline,
HasSetter {
    public static final Setter setter = new Setter();
    static final ClassType setterType;
    static final Field setterField;
    public static final Declaration setterDecl;

    public static Object setter(Procedure arg) {
        return arg.getSetter();
    }

    @Override
    public Object apply1(Object arg) {
        if (!(arg instanceof Procedure)) {
            if (arg instanceof List) {
                return new SetList((List)arg);
            }
            Class<?> cl = arg.getClass();
            if (cl.isArray()) {
                return new SetArray(arg, Language.getDefaultLanguage());
            }
        }
        return ((Procedure)arg).getSetter();
    }

    @Override
    public Expression inline(ApplyExp exp, ExpWalker walker) {
        Expression[] args = exp.getArgs();
        if (args.length == 1) {
            Procedure setter;
            Object value;
            Declaration decl;
            ClassType ctype;
            Expression arg = args[0];
            Type argType = arg.getType();
            if (argType instanceof ArrayType) {
                return new SetArrayExp(arg, (ArrayType)argType);
            }
            if (argType instanceof ClassType && (ctype = (ClassType)argType).isSubclass(ApplyToArgs.typeList)) {
                if (exp instanceof SetListExp) {
                    return exp;
                }
                return new SetListExp(exp.getFunction(), args);
            }
            if (arg instanceof ReferenceExp && (decl = ((ReferenceExp)arg).getBinding()) != null) {
                arg = decl.getValue();
            }
            if (arg instanceof QuoteExp && (value = ((QuoteExp)arg).getValue()) instanceof Procedure && (setter = ((Procedure)value).getSetter()) instanceof Procedure) {
                if (setter instanceof Externalizable) {
                    return new QuoteExp(setter);
                }
                Declaration decl2 = Declaration.getDeclaration(setter);
                if (decl2 != null) {
                    return new ReferenceExp(decl2);
                }
            }
        }
        return exp;
    }

    @Override
    public void set1(Object arg1, Object value) throws Throwable {
        ((Procedure)arg1).setSetter((Procedure)value);
    }

    static {
        setter.setName("setter");
        setterType = ClassType.make("gnu.kawa.functions.Setter");
        setterField = setterType.getDeclaredField("setter");
        setterDecl = new Declaration((Object)"setter", setterField);
        setterDecl.noteValue(new QuoteExp(setter));
    }
}

