/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.lispexpr.ClassNamespace;
import gnu.kawa.xml.XmlNamespace;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Namespace;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class DefineNamespace
extends Syntax {
    private boolean makePrivate;
    private boolean makeXML;
    public static final DefineNamespace define_namespace = new DefineNamespace();
    public static final DefineNamespace define_private_namespace = new DefineNamespace();
    public static final DefineNamespace define_xml_namespace = new DefineNamespace();
    public static final String XML_NAMESPACE_MAGIC = "&xml&";

    @Override
    public boolean scanForDefinitions(Pair st, Vector forms, ScopeExp defs, Translator tr) {
        Expression value;
        Pair p2;
        Pair p1;
        block13: {
            block12: {
                if (!(st.cdr instanceof Pair)) break block12;
                p1 = (Pair)st.cdr;
                if (!(p1.car instanceof String) || !(p1.cdr instanceof Pair)) break block12;
                p2 = (Pair)p1.cdr;
                if (p2.cdr == LList.Empty) break block13;
            }
            tr.error('e', "invalid syntax for define-namespace");
            return false;
        }
        String name = (String)p1.car;
        Declaration decl = defs.getDefine(name, 'w', tr);
        tr.push(decl);
        decl.setFlag(0x204000);
        if (this.makePrivate) {
            decl.setFlag(0x1000000);
            decl.setPrivate(true);
        } else if (defs instanceof ModuleExp) {
            decl.setCanRead(true);
        }
        Translator.setLine(decl, (Object)p1);
        String literal = null;
        if (p2.car instanceof FString) {
            Namespace namespace;
            literal = p2.car.toString();
            if (literal.startsWith("class:")) {
                String cname = literal.substring(6);
                namespace = ClassNamespace.getInstance(literal, ClassType.make(cname));
                decl.setType(ClassType.make("gnu.kawa.lispexpr.ClassNamespace"));
            } else if (this.makeXML) {
                namespace = XmlNamespace.getInstance(name, literal);
                decl.setType(ClassType.make("gnu.kawa.xml.XmlNamespace"));
            } else {
                namespace = Namespace.getInstance(literal);
                decl.setType(ClassType.make("gnu.mapping.Namespace"));
            }
            value = new QuoteExp(namespace);
            decl.setFlag(8192);
        } else {
            value = tr.rewrite_car(p2, false);
        }
        decl.noteValue(value);
        forms.addElement(SetExp.makeDefinition(decl, value));
        return true;
    }

    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        return tr.syntaxError("define-namespace is only allowed in a <body>");
    }

    static {
        define_namespace.setName("define-namespace");
        define_private_namespace.setName("define-private-namespace");
        DefineNamespace.define_private_namespace.makePrivate = true;
        define_xml_namespace.setName("define-xml-namespace");
        DefineNamespace.define_xml_namespace.makeXML = true;
    }
}

