/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.mapping.Procedure1;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class ArrayLength
extends Procedure1
implements Inlineable,
Externalizable {
    Type element_type;

    public ArrayLength(Type element_type) {
        this.element_type = element_type;
    }

    @Override
    public Object apply1(Object array) {
        return IntNum.make(Array.getLength(array));
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        exp.getArgs()[0].compile(comp, ArrayType.make(this.element_type));
        CodeAttr code = comp.getCode();
        code.emitArrayLength();
        target.compileFromStack(comp, LangPrimType.intType);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return LangPrimType.intType;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.element_type);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.element_type = (Type)in.readObject();
    }
}

