/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class S8Vector
extends SimpleVector
implements Externalizable,
Comparable {
    byte[] data;
    protected static byte[] empty = new byte[0];

    public S8Vector() {
        this.data = empty;
    }

    public S8Vector(int size, byte value) {
        byte[] array = new byte[size];
        this.data = array;
        this.size = size;
        while (--size >= 0) {
            array[size] = value;
        }
    }

    public S8Vector(int size) {
        this.data = new byte[size];
        this.size = size;
    }

    public S8Vector(byte[] data) {
        this.data = data;
        this.size = data.length;
    }

    public S8Vector(Sequence seq) {
        this.data = new byte[seq.size()];
        this.addAll((Collection)seq);
    }

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            byte[] tmp = new byte[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    @Override
    protected Object getBuffer() {
        return this.data;
    }

    public final byte byteAt(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public final byte byteAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[index]);
    }

    @Override
    public final Object getBuffer(int index) {
        return Convert.toObject(this.data[index]);
    }

    @Override
    public Object setBuffer(int index, Object value) {
        byte old = this.data[index];
        this.data[index] = Convert.toByte(value);
        return Convert.toObject(old);
    }

    public final void setByteAt(int index, byte value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[index] = value;
    }

    public final void setByteAtBuffer(int index, byte value) {
        this.data[index] = value;
    }

    @Override
    protected void clearBuffer(int start, int count) {
        while (--count >= 0) {
            this.data[start++] = 0;
        }
    }

    @Override
    public int getElementKind() {
        return 18;
    }

    @Override
    public String getTag() {
        return "s8";
    }

    @Override
    public boolean consumeNext(int ipos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeInt(this.data[index]);
        return true;
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int i = iposStart >>> 1;
        int end = iposEnd >>> 1;
        if (end > this.size) {
            end = this.size;
        }
        while (i < end) {
            out.writeInt(this.data[i]);
            ++i;
        }
    }

    public int compareTo(Object obj) {
        return S8Vector.compareToInt(this, (S8Vector)obj);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeByte(this.data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = in.readByte();
        }
        this.data = data;
        this.size = size;
    }
}

