/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Location;
import gnu.mapping.LocationRef;
import gnu.mapping.Named;
import gnu.mapping.NamedLocation;
import gnu.mapping.SharedLocation;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;

public class ThreadLocation
extends Location
implements Named {
    final Symbol name;
    final Object property;
    static int counter;
    boolean unlink;
    public static final String ANONYMOUS;
    Location global;
    ThreadLocal thLocal = new ThreadLocal();
    static SimpleEnvironment env;

    private static synchronized int nextCounter() {
        return ++counter;
    }

    public ThreadLocation() {
        this("param#" + ThreadLocation.nextCounter());
    }

    public ThreadLocation(String name) {
        this.name = Symbol.makeUninterned(name);
        this.property = ANONYMOUS;
        this.unlink = true;
        this.global = new SharedLocation(this.name, null, 0);
    }

    private ThreadLocation(Symbol name) {
        this.name = name;
        String str = name == null ? null : name.toString();
        this.property = ANONYMOUS;
        this.unlink = true;
        this.global = new SharedLocation(Symbol.makeUninterned(str), null, 0);
    }

    public ThreadLocation(Symbol name, Object property, Location global) {
        this.name = name;
        this.property = property;
        this.global = global;
    }

    public static ThreadLocation makePrivate(String name) {
        return new ThreadLocation(name);
    }

    public static ThreadLocation makePrivate(Symbol name) {
        return new ThreadLocation(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobal(Object value) {
        ThreadLocation threadLocation = this;
        synchronized (threadLocation) {
            if (this.global == null) {
                this.global = new SharedLocation(this.name, null, 0);
            }
            this.global.set(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation() {
        Object entry = this.thLocal.get();
        if (entry == null) {
            Environment env = Environment.getCurrent();
            NamedLocation loc = env.getLocation(this.name, this.property, true);
            if (this.global != null) {
                NamedLocation namedLocation = loc;
                synchronized (namedLocation) {
                    if (loc.base == null && loc.value == Location.UNBOUND) {
                        loc.setBase(this.global);
                    }
                }
            }
            if (this.unlink) {
                LocationRef lref = new LocationRef();
                lref.env = env;
                lref.loc = loc;
                entry = lref;
            } else {
                entry = loc;
            }
            this.thLocal.set(entry);
        }
        if (entry instanceof LocationRef) {
            return ((LocationRef)entry).loc;
        }
        return (Location)entry;
    }

    @Override
    public Object get(Object defaultValue) {
        return this.getLocation().get(defaultValue);
    }

    @Override
    public void set(Object value) {
        this.getLocation().set(value);
    }

    @Override
    public Object setWithSave(Object newValue, CallContext ctx) {
        return this.getLocation().setWithSave(newValue, ctx);
    }

    @Override
    public void setRestore(Object oldValue, CallContext ctx) {
        this.getLocation().setRestore(oldValue, ctx);
    }

    @Override
    public Symbol getKeySymbol() {
        return this.name;
    }

    @Override
    public Object getKeyProperty() {
        return this.property;
    }

    @Override
    public String getName() {
        return this.name == null ? null : this.name.toString();
    }

    @Override
    public Object getSymbol() {
        if (this.name != null && this.property == ANONYMOUS && ((SharedLocation)this.global).getKeySymbol() == this.name) {
            return this.name.toString();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new RuntimeException("setName not allowed");
    }

    public static synchronized ThreadLocation getInstance(Symbol name, Object property) {
        if (env == null) {
            env = new SimpleEnvironment("[thread-locations]");
        }
        IndirectableLocation loc = (IndirectableLocation)env.getLocation(name, property);
        if (loc.base != null) {
            return (ThreadLocation)loc.base;
        }
        ThreadLocation tloc = new ThreadLocation(name, property, null);
        loc.base = tloc;
        return tloc;
    }

    static {
        ANONYMOUS = new String("(dynamic)");
    }
}

