/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.glj.graph;

import java.util.LinkedList;

public abstract class GraphNode {
    Object state;
    int ghat = 0;
    int fhat;
    GraphNode parent = null;
    LinkedList successors = null;

    public void setState(Object state) {
        this.state = state;
    }

    public void setGhat(int ghat) {
        this.ghat = ghat;
    }

    public void setFhat(int fhat) {
        this.fhat = fhat;
    }

    public void setParent(GraphNode parent) {
        this.parent = parent;
    }

    public void addSuccessors(GraphNode node) {
        if (this.successors == null) {
            this.successors = new LinkedList();
        }
        this.successors.add(node);
    }

    public LinkedList graphExpand() {
        LinkedList<GraphNode> nodes = null;
        LinkedList applied = null;
        int i = 0;
        while ((applied = this.operators(i)) != null) {
            GraphNode node = this.makeSuccessor(applied);
            if (node != null) {
                if (nodes == null) {
                    nodes = new LinkedList<GraphNode>();
                }
                nodes.add(node);
            }
            ++i;
        }
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.addFirst(nodes);
        ret.addLast(this);
        return ret;
    }

    public GraphNode makeSuccessor(LinkedList stateAndCost) {
        GraphNode node = null;
        if (stateAndCost.isEmpty()) {
            return null;
        }
        try {
            node = (GraphNode)this.getClass().newInstance();
        }
        catch (Exception e) {
            System.err.println("make instance failed");
        }
        node.setState(stateAndCost.getFirst());
        node.setGhat(this.ghat + (Integer)stateAndCost.getLast());
        node.setFhat(node.ghat + this.hhat());
        node.setParent(this);
        this.addSuccessors(node);
        return node;
    }

    public boolean isBetterNode(GraphNode anotherNode) {
        int anotherFhat = anotherNode.fhat;
        if (this.fhat < anotherFhat) {
            return true;
        }
        if (this.fhat > anotherFhat) {
            return false;
        }
        return this.isGoal();
    }

    public GraphNode isOnGraph(LinkedList nodeList) {
        LinkedList list = new LinkedList(nodeList);
        GraphNode result = null;
        while (!list.isEmpty()) {
            if (this.isStateEqual(list.getFirst())) {
                result = (GraphNode)list.getFirst();
            }
            if (result != null) {
                return result;
            }
            list.removeFirst();
        }
        return result;
    }

    public abstract boolean isGoal();

    public abstract LinkedList operators(int var1);

    public abstract void reportSolution();

    public abstract boolean isStateEqual(Object var1);

    public abstract int hhat();

    public LinkedList getSuccessors() {
        return this.successors;
    }

    public void setSuccessors(LinkedList successors) {
        this.successors = successors;
    }

    public Object getState() {
        return this.state;
    }

    public int getGhat() {
        return this.ghat;
    }

    public int getFhat() {
        return this.fhat;
    }

    public GraphNode getParent() {
        return this.parent;
    }
}

