/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gnp.prubae;

import gnu.lists.LList;
import gnu.math.IntNum;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import jp.sourceforge.glj.lisp.Lisp;
import jp.sourceforge.gnp.prubae.PrubaeController;
import jp.sourceforge.gnp.prubae.PrubaeControllerDo;
import jp.sourceforge.gnp.prubae.PrubaeControllerValueStatement;
import jp.sourceforge.gnp.prubae.PrubaeModel;
import jp.sourceforge.gnp.prubae.PrubaeModelDoStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelStatement;
import jp.sourceforge.gnp.prubae.PrubaeModelTable;
import jp.sourceforge.gnp.prubae.PrubaeModelValue;
import jp.sourceforge.gnp.prubae.PrubaeModelValueStatement;

public class PrubaeControllerTable
extends PrubaeControllerDo
implements TableModel {
    private JRadioButton rowButton;
    private JRadioButton colButton;
    private JPanel rowPanel;
    private JPanel colPanel;
    private JPanel varRowPanel;
    private JPanel varColPanel;
    private JPanel rowsCountPanel;
    private JLabel rowsCountLabel;
    private JTextField rowsCountField;
    private JButton rowsCountButton;
    private int rowsCount = 0;
    private JPanel colsCountPanel;
    private JLabel colsCountLabel;
    private JTextField colsCountField;
    private JButton colsCountButton;
    private int colsCount = 0;
    private JTable table;
    private JScrollPane tablePanel;

    @Override
    protected void createButtons() {
        this.setRowButton(new JRadioButton("row col(2-dim)"));
        this.setColButton(new JRadioButton("col(1-dim)"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRowButton());
        group.add(this.getColButton());
        this.getRowButton().setActionCommand("row");
        this.getRowButton().addActionListener(this);
        this.getColButton().setActionCommand("col");
        this.getColButton().addActionListener(this);
        this.getRowButton().setSelected(true);
        this.getColButton().setSelected(false);
        JPanel rowColPanel = new JPanel();
        rowColPanel.setLayout(new BoxLayout(rowColPanel, 0));
        rowColPanel.add(new JLabel("TABLE"));
        rowColPanel.add(this.getRowButton());
        rowColPanel.add(this.getColButton());
        this.getPanel().add(rowColPanel);
        this.setRowPanel(new JPanel());
        this.getRowPanel().setLayout(new BoxLayout(this.getRowPanel(), 1));
        this.getRowPanel().setBorder(BorderFactory.createLineBorder(Color.black, 5));
        this.setVarRowPanel(new JPanel());
        this.getVarRowPanel().setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.getRowPanel().add(this.getVarRowPanel());
        this.setRowsCountPanel(new JPanel());
        this.setRowsCountLabel(new JLabel("COUNT"));
        this.setRowsCountField(new JTextField("", 4));
        this.setRowsCountButton(new JButton("INPUT"));
        this.getRowsCountButton().setActionCommand("set rows");
        this.getRowsCountButton().addActionListener(this);
        this.getRowsCountPanel().setLayout(new BoxLayout(this.getRowsCountPanel(), 0));
        this.getRowsCountPanel().add(this.getRowsCountLabel());
        this.getRowsCountPanel().add(this.getRowsCountField());
        this.getRowsCountPanel().add(this.getRowsCountButton());
        this.getRowPanel().add(this.getRowsCountPanel());
        this.setColPanel(new JPanel());
        this.getColPanel().setLayout(new BoxLayout(this.getColPanel(), 1));
        this.getColPanel().setBorder(BorderFactory.createLineBorder(Color.black, 5));
        this.setVarColPanel(new JPanel());
        this.getVarColPanel().setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.getColPanel().add(this.getVarColPanel());
        this.setColsCountPanel(new JPanel());
        this.setColsCountLabel(new JLabel("COUNT"));
        this.setColsCountField(new JTextField("", 4));
        this.setColsCountButton(new JButton("INPUT"));
        this.getColsCountButton().setActionCommand("set cols");
        this.getColsCountButton().addActionListener(this);
        this.getColsCountPanel().setLayout(new BoxLayout(this.getColsCountPanel(), 0));
        this.getColsCountPanel().add(this.getColsCountLabel());
        this.getColsCountPanel().add(this.getColsCountField());
        this.getColsCountPanel().add(this.getColsCountButton());
        this.getColPanel().add(this.getColsCountPanel());
        this.setTable(new JTable());
        this.setTablePanel(new JScrollPane());
        this.getTablePanel().setPreferredSize(new Dimension(200, 200));
        this.getTablePanel().getViewport().add(this.getTable());
        this.getPanel().add(this.getTablePanel());
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setRowsCount(0);
        this.setColsCount(0);
    }

    @Override
    public void update() {
        ((PrubaeModelTable)this.getModel()).updateVarRow();
        ((PrubaeModelTable)this.getModel()).updateVarCol();
        ((PrubaeModelTable)this.getModel()).updateRows();
        ((PrubaeModelTable)this.getModel()).updateCols();
        super.update();
    }

    private void updateRowsCount() {
        ((PrubaeModelTable)this.getModel()).updateRows();
        int numArgs = 0;
        try {
            numArgs = Integer.parseInt(this.getRowsCountField().getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        int oldArgsCount = this.getRowsCount();
        this.setRowsCount(numArgs);
        if (numArgs > oldArgsCount) {
            this.addRows(oldArgsCount, numArgs);
        } else if (numArgs < oldArgsCount) {
            this.removeRows(numArgs, oldArgsCount);
        }
    }

    private void updateColsCount() {
        ((PrubaeModelTable)this.getModel()).updateCols();
        int numArgs = 0;
        try {
            numArgs = Integer.parseInt(this.getColsCountField().getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        int oldArgsCount = this.getColsCount();
        this.setColsCount(numArgs);
        if (numArgs > oldArgsCount) {
            this.addCols(oldArgsCount, numArgs);
        } else if (numArgs < oldArgsCount) {
            this.removeCols(numArgs, oldArgsCount);
        }
    }

    @Override
    public void destroyPanel() {
        this.setRowButton(null);
        this.setColButton(null);
        this.setRowPanel(null);
        this.setVarRowPanel(null);
        this.setRowsCountPanel(null);
        this.setRowsCountLabel(null);
        this.setRowsCountField(null);
        this.setRowsCountButton(null);
        this.setColPanel(null);
        this.setVarColPanel(null);
        this.setColsCountPanel(null);
        this.setColsCountLabel(null);
        this.setColsCountField(null);
        this.setColsCountButton(null);
        this.setTable(null);
        this.setTablePanel(null);
        super.destroyPanel();
    }

    public void addRows(int minArgs, int numArgs) {
        int i;
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        if (model.getRows() == null) {
            model.setRows(new Vector());
        }
        Vector<PrubaeModel> newTbls = new Vector<PrubaeModel>();
        int rowsCnt = model.getRows() == null ? 1 : (model.getRows().size() == 0 ? 1 : model.getRows().size());
        for (int i2 = 0; i2 < rowsCnt; ++i2) {
            for (int j = 0; j < model.getCols().size(); ++j) {
                PrubaeModel amt = (PrubaeModel)model.getTbls().get(i2 * model.getCols().size() + j);
                amt.setParentList(newTbls);
                newTbls.add(amt);
            }
        }
        LList list = Lisp.append(Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList()), this.getEditor().getSettablevarList());
        PrubaeModel var = model.getVarRow();
        LList valueList = Lisp.assoc(new IntNum(var.getRegist()), list);
        Object type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
        for (i = minArgs; i < numArgs; ++i) {
            PrubaeModelValueStatement child = new PrubaeModelValueStatement();
            child.setComment("");
            child.setStatement("");
            child.initialize(this.getEditor(), model, model.getRows());
            child.setRequiredType(type);
            ((PrubaeModel)child).openUI();
            model.getRows().add(child);
        }
        for (i = rowsCnt; i < numArgs; ++i) {
            for (int j = 0; j < model.getCols().size(); ++j) {
                PrubaeModelDoStatement amt = new PrubaeModelDoStatement();
                amt.setComment("");
                amt.setStatement("");
                amt.setRegist((short)520);
                amt.setValues(new Vector());
                amt.getValues().add("   ");
                amt.getValues().add(new Double(0.0));
                amt.initialize(this.getEditor(), model, newTbls);
                amt.openUI();
                newTbls.add(amt);
            }
        }
        model.setTbls(newTbls);
    }

    public void removeRows(int minArgs, int numArgs) {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        for (int i = numArgs - 1; i >= minArgs; --i) {
            PrubaeModelValue child = (PrubaeModelValue)model.getRows().get(i);
            this.getRowPanel().remove(child.getController().getPanel());
            child.closeUI();
            model.getRows().remove(child);
        }
        Vector<PrubaeModel> newTbls = new Vector<PrubaeModel>();
        int rowsCnt = model.getRows() == null ? 1 : (model.getRows().size() == 0 ? 1 : model.getRows().size());
        for (int i = 0; i < rowsCnt; ++i) {
            for (int j = 0; j < model.getCols().size(); ++j) {
                PrubaeModel amt = (PrubaeModel)model.getTbls().get(i * model.getCols().size() + j);
                amt.setParentList(newTbls);
                newTbls.add(amt);
            }
        }
        model.setTbls(newTbls);
    }

    public void addCols(int minArgs, int numArgs) {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        if (model.getCols() == null) {
            model.setCols(new Vector());
        }
        LList list = Lisp.append(Lisp.append(Lisp.append(this.getEditor().getValueList(), this.getEditor().getVarList()), this.getEditor().getConstList()), this.getEditor().getSettablevarList());
        PrubaeModel var = model.getVarCol();
        LList valueList = Lisp.assoc(new IntNum(var.getRegist()), list);
        Object type = Lisp.car(Lisp.cdr(Lisp.cdr(Lisp.cdr(valueList))));
        for (int i = minArgs; i < numArgs; ++i) {
            PrubaeModelValueStatement child = new PrubaeModelValueStatement();
            child.setComment("");
            child.setStatement("");
            child.initialize(this.getEditor(), model, model.getCols());
            child.setRequiredType(type);
            ((PrubaeModel)child).openUI();
            model.getCols().add(child);
        }
        Vector<PrubaeModel> newTbls = new Vector<PrubaeModel>();
        int rowsCnt = model.getRows() == null ? 1 : (model.getRows().size() == 0 ? 1 : model.getRows().size());
        for (int i = 0; i < rowsCnt; ++i) {
            PrubaeModel amt;
            int j;
            for (j = 0; j < minArgs; ++j) {
                amt = (PrubaeModel)model.getTbls().get(i * minArgs + j);
                amt.setParentList(newTbls);
                newTbls.add(amt);
            }
            for (j = minArgs; j < numArgs; ++j) {
                amt = new PrubaeModelDoStatement();
                amt.setComment("");
                ((PrubaeModelDoStatement)amt).setStatement("");
                amt.setRegist((short)520);
                ((PrubaeModelDoStatement)amt).setValues(new Vector());
                ((PrubaeModelDoStatement)amt).getValues().add("   ");
                ((PrubaeModelDoStatement)amt).getValues().add(new Double(0.0));
                amt.initialize(this.getEditor(), model, newTbls);
                amt.openUI();
                newTbls.add(amt);
            }
        }
        model.setTbls(newTbls);
    }

    public void removeCols(int minArgs, int numArgs) {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        for (int i = numArgs - 1; i >= minArgs; --i) {
            PrubaeModelValue child = (PrubaeModelValue)model.getCols().get(i);
            this.getColPanel().remove(child.getController().getPanel());
            child.closeUI();
            model.getCols().remove(child);
        }
        Vector<PrubaeModel> newTbls = new Vector<PrubaeModel>();
        int rowsCnt = model.getRows() == null ? 1 : (model.getRows().size() == 0 ? 1 : model.getRows().size());
        for (int i = 0; i < rowsCnt; ++i) {
            for (int j = 0; j < minArgs; ++j) {
                PrubaeModel amt = (PrubaeModel)model.getTbls().get(i * numArgs + j);
                amt.setParentList(newTbls);
                newTbls.add(amt);
            }
        }
        model.setTbls(newTbls);
    }

    public void resetRows() {
        int rows = ((PrubaeModelTable)this.getModel()).getRows().size();
        this.removeRows(0, rows);
    }

    public void resetCols() {
        int cols = ((PrubaeModelTable)this.getModel()).getCols().size();
        this.removeCols(0, cols);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("delete")) {
            PrubaeController cntl = this.getEditor().getController();
            if (this == cntl) {
                this.deleteAndUp();
            } else {
                this.delete();
            }
        } else if (e.getActionCommand().equals("insert")) {
            this.insert();
        } else {
            System.err.println("action = " + e.getActionCommand());
            if (e.getActionCommand().equals("row")) {
                PrubaeModelTable model = (PrubaeModelTable)this.getModel();
                if (model.getVarRow() == null) {
                    model.setVarRow(new PrubaeModelValueStatement());
                    model.getVarRow().setComment("");
                    model.getVarRow().setStatement("");
                    model.getVarRow().initialize(this.getEditor(), model, null);
                }
                if (model.getRows() == null) {
                    model.setRows(new Vector());
                }
            } else if (e.getActionCommand().equals("col")) {
                PrubaeModelValue varRow = (PrubaeModelValue)((PrubaeModelTable)this.getModel()).getVarRow();
                if (varRow != null) {
                    PrubaeControllerValueStatement varRowCtl = (PrubaeControllerValueStatement)varRow.getController();
                    if (this.getVarRowPanel().isAncestorOf(varRowCtl.getPanel())) {
                        this.getVarRowPanel().remove(varRowCtl.getPanel());
                    }
                    ((PrubaeModelTable)this.getModel()).setVarRow(null);
                }
                if (((PrubaeModelTable)this.getModel()).getRows() != null) {
                    int rows = ((PrubaeModelTable)this.getModel()).getRows().size();
                    this.removeRows(0, rows);
                    ((PrubaeModelTable)this.getModel()).setRows(null);
                }
            } else if (e.getActionCommand().equals("set rows")) {
                this.updateRowsCount();
            } else if (e.getActionCommand().equals("set cols")) {
                this.updateColsCount();
            }
            this.view.display();
        }
    }

    @Override
    void createPopupMenu() {
        JMenuItem mi = null;
        this.setPopupMenu(new JPopupMenu());
        mi = new JMenuItem("delete this action");
        mi.setActionCommand("delete");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
        mi = new JMenuItem("insert action before this");
        mi.setActionCommand("insert");
        mi.addActionListener(this);
        this.getPopupMenu().add(mi);
    }

    public void updateTable() {
        this.getTablePanel().getViewport().remove(this.getTable());
        this.setTable(new JTable(this));
        if (!this.isCellEditable(0, 0)) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setBackground(Color.lightGray);
            this.getTable().getColumnModel().getColumn(0).setCellRenderer(renderer);
        }
        this.getTablePanel().getViewport().add(this.getTable());
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        if (model == null) {
            return false;
        }
        if (model.getRows() == null || model.getRows().size() == 0) {
            return true;
        }
        return columnIndex >= 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        if (model == null) {
            System.err.println("getColumnName model is null");
            return "";
        }
        if (model.getRows() != null && model.getRows().size() != 0) {
            if (columnIndex < 1) {
                System.err.println("getColumnName columnIndex(<1) = " + columnIndex);
                return "";
            }
            --columnIndex;
        }
        PrubaeModelStatement stmt = (PrubaeModelStatement)model.getCols().get(columnIndex);
        System.err.println("getColumnName columnIndex = " + columnIndex + ":" + model.getCols() + ":" + model.getCols().size() + ":" + stmt);
        String columnName = ((PrubaeModel)((Object)stmt)).getComment();
        if (columnName == null || columnName.equals("")) {
            columnName = stmt.getStatement();
        }
        System.err.println("getColumnName columnIndex = " + columnIndex + ":" + columnName);
        return columnName;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        if (model == null) {
            return 0;
        }
        if (model.getRows() == null || model.getRows().size() == 0) {
            return 1;
        }
        return model.getRows().size();
    }

    @Override
    public int getColumnCount() {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        if (model == null) {
            return 0;
        }
        if (model.getCols() == null || model.getCols().size() == 0) {
            return 0;
        }
        if (model.getRows() == null || model.getRows().size() == 0) {
            return model.getCols().size();
        }
        return model.getCols().size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        int index = 0;
        if (model.getRows() == null || model.getRows().size() == 0) {
            index = columnIndex;
        } else {
            if (columnIndex < 1) {
                String str;
                List rows = model.getRows();
                PrubaeModelStatement stmt = (PrubaeModelStatement)rows.get(rowIndex);
                int left = (str = stmt.getStatement()).indexOf(40);
                int right = str.indexOf(41, left < 0 ? 0 : left);
                if (left >= 0 || right >= 0) {
                    str = str.substring(left + 1, right);
                }
                return str;
            }
            int rowsStart = model.getCols().size();
            index = rowIndex * rowsStart + columnIndex - 1;
        }
        List tbls = model.getTbls();
        PrubaeModelStatement stmt = (PrubaeModelStatement)tbls.get(index);
        String str = stmt.getStatement();
        int left = str.indexOf(40);
        int right = str.indexOf(41, left < 0 ? 0 : left);
        if (left >= 0 || right >= 0) {
            str = str.substring(left + 1, right);
        }
        return str;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        PrubaeModelTable model = (PrubaeModelTable)this.getModel();
        int index = 0;
        if (model.getRows() == null || model.getRows().size() == 0) {
            index = columnIndex;
        } else {
            if (columnIndex < 1) {
                return;
            }
            int rowsStart = model.getCols().size();
            index = rowIndex * rowsStart + columnIndex - 1;
        }
        List tbls = model.getTbls();
        PrubaeModelDoStatement stmt = (PrubaeModelDoStatement)tbls.get(index);
        String str = (String)aValue;
        System.err.println("setValueAt:" + str + ":" + rowIndex + "/" + columnIndex + "/" + index);
        String currency = "   ";
        double value = 0.0;
        if (str.length() > 3) {
            currency = str.substring(0, 3);
            str = str.substring(3);
            try {
                value = Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        System.err.println("setValueAt:[" + currency + "] [" + value + "]:" + rowIndex + "/" + columnIndex + "/" + index);
        stmt.setRegist((short)520);
        stmt.setValues(new Vector());
        stmt.getValues().add(currency);
        stmt.getValues().add(new Double(value));
        stmt.updateStatement();
        tbls.set(index, stmt);
    }

    @Override
    public Object clone() {
        PrubaeControllerTable clone = null;
        clone = (PrubaeControllerTable)super.clone();
        if (this.getRowPanel() != null) {
            clone.setRowPanel(new JPanel());
        }
        if (this.getColPanel() != null) {
            clone.setColPanel(new JPanel());
        }
        if (this.getVarRowPanel() != null) {
            clone.setVarRowPanel(new JPanel());
        }
        if (this.getVarColPanel() != null) {
            clone.setVarColPanel(new JPanel());
        }
        if (this.getRowsCountPanel() != null) {
            clone.setRowsCountPanel(new JPanel());
        }
        if (this.getRowsCountField() != null) {
            clone.setRowsCountField(new JTextField());
        }
        if (this.getColsCountPanel() != null) {
            clone.setColsCountPanel(new JPanel());
        }
        if (this.getColsCountField() != null) {
            clone.setColsCountField(new JTextField());
        }
        return clone;
    }

    public void setRowButton(JRadioButton theRowButton) {
        this.rowButton = theRowButton;
    }

    public JRadioButton getRowButton() {
        return this.rowButton;
    }

    public void setColButton(JRadioButton theColButton) {
        this.colButton = theColButton;
    }

    public JRadioButton getColButton() {
        return this.colButton;
    }

    public void setRowPanel(JPanel theRowPanel) {
        this.rowPanel = theRowPanel;
    }

    public JPanel getRowPanel() {
        return this.rowPanel;
    }

    public void setColPanel(JPanel theColPanel) {
        this.colPanel = theColPanel;
    }

    public JPanel getColPanel() {
        return this.colPanel;
    }

    public void setRowsCountPanel(JPanel theRowsCountPanel) {
        this.rowsCountPanel = theRowsCountPanel;
    }

    public void setVarRowPanel(JPanel theVarRowPanel) {
        this.varRowPanel = theVarRowPanel;
    }

    public JPanel getVarRowPanel() {
        return this.varRowPanel;
    }

    public void setVarColPanel(JPanel theVarColPanel) {
        this.varColPanel = theVarColPanel;
    }

    public JPanel getVarColPanel() {
        return this.varColPanel;
    }

    public JPanel getRowsCountPanel() {
        return this.rowsCountPanel;
    }

    public void setRowsCountLabel(JLabel theRowsCountLabel) {
        this.rowsCountLabel = theRowsCountLabel;
    }

    public JLabel getRowsCountLabel() {
        return this.rowsCountLabel;
    }

    public void setRowsCountField(JTextField theRowsCountField) {
        this.rowsCountField = theRowsCountField;
    }

    public JTextField getRowsCountField() {
        return this.rowsCountField;
    }

    public void setRowsCountButton(JButton theRowsCountButton) {
        this.rowsCountButton = theRowsCountButton;
    }

    public JButton getRowsCountButton() {
        return this.rowsCountButton;
    }

    public void setRowsCount(int theRowsCount) {
        this.rowsCount = theRowsCount;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public void setColsCountPanel(JPanel theColsCountPanel) {
        this.colsCountPanel = theColsCountPanel;
    }

    public JPanel getColsCountPanel() {
        return this.colsCountPanel;
    }

    public void setColsCountLabel(JLabel theColsCountLabel) {
        this.colsCountLabel = theColsCountLabel;
    }

    public JLabel getColsCountLabel() {
        return this.colsCountLabel;
    }

    public void setColsCountField(JTextField theColsCountField) {
        this.colsCountField = theColsCountField;
    }

    public JTextField getColsCountField() {
        return this.colsCountField;
    }

    public void setColsCountButton(JButton theColsCountButton) {
        this.colsCountButton = theColsCountButton;
    }

    public JButton getColsCountButton() {
        return this.colsCountButton;
    }

    public void setColsCount(int theColsCount) {
        this.colsCount = theColsCount;
    }

    public int getColsCount() {
        return this.colsCount;
    }

    public void setTable(JTable theTable) {
        this.table = theTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTablePanel(JScrollPane theTablePanel) {
        this.tablePanel = theTablePanel;
    }

    public JScrollPane getTablePanel() {
        return this.tablePanel;
    }
}

