/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.lists.AbstractFormat;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.text.Path;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URL;
import kawa.standard.load;

public class Shell {
    private static Class[] noClasses = new Class[0];
    private static Class[] boolClasses = new Class[]{Boolean.TYPE};
    private static Class[] xmlPrinterClasses = new Class[]{OutPort.class, Object.class};
    private static Class[] httpPrinterClasses = new Class[]{OutPort.class};
    private static Object portArg = "(port)";
    static Object[][] formats = new Object[][]{{"scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.FALSE}, {"readable-scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.TRUE}, {"elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.FALSE}, {"readable-elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.TRUE}, {"clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"xml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, null}, {"html", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "html"}, {"xhtml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "xhtml"}, {"cgi", "gnu.kawa.xml.HttpPrinter", "make", httpPrinterClasses, portArg}, {"ignore", "gnu.lists.VoidConsumer", "getInstance", noClasses}, {null}};
    public static String defaultFormatName;
    public static Object[] defaultFormatInfo;
    public static Method defaultFormatMethod;

    public static void setDefaultFormat(String name) {
        defaultFormatName = name = name.intern();
        int i = 0;
        while (true) {
            Object[] info;
            Object iname;
            if ((iname = (info = formats[i])[0]) == null) {
                System.err.println("kawa: unknown output format '" + name + "'");
                System.exit(-1);
            } else if (iname == name) {
                defaultFormatInfo = info;
                try {
                    Class<?> formatClass = Class.forName((String)info[1]);
                    defaultFormatMethod = formatClass.getMethod((String)info[2], (Class[])info[3]);
                }
                catch (Throwable ex) {
                    System.err.println("kawa:  caught " + ex + " while looking for format '" + name + "'");
                    System.exit(-1);
                }
                break;
            }
            ++i;
        }
        if (!defaultFormatInfo[1].equals("gnu.lists.VoidConsumer")) {
            ModuleBody.setMainPrintValues(true);
        }
    }

    public static Consumer getOutputConsumer(OutPort out) {
        Object[] info = defaultFormatInfo;
        if (out == null) {
            return VoidConsumer.getInstance();
        }
        if (info == null) {
            return Language.getDefaultLanguage().getOutputConsumer(out);
        }
        try {
            Object[] args = new Object[info.length - 4];
            System.arraycopy(info, 4, args, 0, args.length);
            int i = args.length;
            while (--i >= 0) {
                if (args[i] != portArg) continue;
                args[i] = out;
            }
            Object format = defaultFormatMethod.invoke(null, args);
            if (format instanceof AbstractFormat) {
                out.objectFormat = (AbstractFormat)format;
                return out;
            }
            return (Consumer)format;
        }
        catch (Throwable ex) {
            throw new RuntimeException("cannot get output-format '" + defaultFormatName + "' - caught " + ex);
        }
    }

    public static void run(Language language, Environment env) {
        Procedure prompter;
        InPort inp = InPort.inDefault();
        if (inp instanceof TtyInPort && (prompter = language.getPrompter()) != null) {
            ((TtyInPort)inp).setPrompter(prompter);
        }
        Shell.run(language, env, inp, OutPort.outDefault(), OutPort.errDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Language language, Environment env, InPort inp, OutPort pout, OutPort perr) {
        AbstractFormat saveFormat = null;
        if (pout != null) {
            saveFormat = pout.objectFormat;
        }
        Consumer out = Shell.getOutputConsumer(pout);
        try {
            Shell.run(language, env, inp, out, perr, null);
        }
        finally {
            if (pout != null) {
                pout.objectFormat = saveFormat;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static void run(Language language, Environment env, InPort inp, Consumer out, OutPort perr, URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void runString(String str, Language language, Environment env) {
        Shell.run(language, env, new CharArrayInPort(str), ModuleBody.getMainPrintValues() ? OutPort.outDefault() : null, OutPort.errDefault());
    }

    public static void runFile(String fname, int skipLines) {
        Environment env = Environment.getCurrent();
        try {
            if (fname.equals("-")) {
                InPort in = InPort.inDefault();
                while (--skipLines >= 0) {
                    in.skipRestOfLine();
                }
                load.loadSource(in, env, null);
            } else {
                load.apply(Path.valueOf(fname), env, false, skipLines);
            }
        }
        catch (SyntaxException e) {
            e.printAll(OutPort.errDefault(), 20);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open file " + fname);
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

