/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.functions.GetNamedPart;
import gnu.kawa.reflect.Invoke;
import gnu.lists.FVector;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Symbol;
import java.util.IdentityHashMap;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.Translator;

public class Quote
extends Syntax {
    public static final Quote plainQuote = new Quote("quote", false);
    public static final Quote quasiQuote = new Quote("quasiquote", true);
    protected static final int QUOTE_DEPTH = -1;
    protected boolean isQuasi;
    private static final Object WORKING = new String("(working)");
    private static final Object CYCLE = new String("(cycle)");
    static final ClassType vectorType = ClassType.make("kawa.lib.vectors");
    static final ClassType vectorAppendType = ClassType.make("kawa.standard.vector_append");
    static final ClassType quoteType = ClassType.make("kawa.lang.Quote");

    public Quote(String name, boolean isQuasi) {
        super(name);
        this.isQuasi = isQuasi;
    }

    protected Object expand(Object template, int depth, Translator tr) {
        IdentityHashMap seen = new IdentityHashMap();
        return this.expand(template, depth, null, seen, tr);
    }

    public static Object quote(Object obj, Translator tr) {
        return plainQuote.expand(obj, -1, tr);
    }

    public static Object quote(Object obj) {
        return plainQuote.expand(obj, -1, (Translator)Compilation.getCurrent());
    }

    protected Expression coerceExpression(Object val, Translator tr) {
        return val instanceof Expression ? (Expression)val : this.leaf(val, tr);
    }

    protected Expression leaf(Object val, Translator tr) {
        return new QuoteExp(val);
    }

    protected boolean expandColonForms() {
        return true;
    }

    Object expand_pair(Pair list, int depth, SyntaxForm syntax2, Object seen, Translator tr) {
        Object cdr;
        Object rest;
        block32: {
            Object car;
            Pair pair;
            block34: {
                pair = list;
                while (true) {
                    block35: {
                        block37: {
                            Pair pair_cdr;
                            block39: {
                                block38: {
                                    block36: {
                                        Pair p2;
                                        Pair p1;
                                        rest = pair;
                                        if (this.expandColonForms() && tr.matches(pair.car, syntax2, "$lookup$") && pair.cdr instanceof Pair && (p1 = (Pair)pair.cdr) instanceof Pair && (p2 = (Pair)p1.cdr) instanceof Pair && p2.cdr == LList.Empty) {
                                            Expression part2;
                                            Expression part1 = tr.rewrite_car(p1, false);
                                            Symbol sym = tr.namespaceResolve(part1, part2 = tr.rewrite_car(p2, false));
                                            if (sym == null) {
                                                if (part1 instanceof ReferenceExp && part2 instanceof QuoteExp) {
                                                    sym = tr.getGlobalEnvironment().getSymbol(((ReferenceExp)part1).getName() + ':' + ((QuoteExp)part2).getValue().toString());
                                                } else {
                                                    String combinedName = GetNamedPart.combineName(part1, part2);
                                                    if (combinedName != null) {
                                                        sym = tr.getGlobalEnvironment().getSymbol(combinedName);
                                                    } else {
                                                        Object save = tr.pushPositionOf(pair);
                                                        tr.error('e', "'" + p1.car + "' is not a valid prefix");
                                                        tr.popPositionOf(save);
                                                    }
                                                }
                                            }
                                            cdr = sym;
                                            break block32;
                                        }
                                        if (depth < 0) break block35;
                                        if (!tr.matches(pair.car, syntax2, "quasiquote")) break block36;
                                        ++depth;
                                        break block35;
                                    }
                                    if (!tr.matches(pair.car, syntax2, "unquote")) break block37;
                                    --depth;
                                    if (!(pair.cdr instanceof Pair)) break block38;
                                    pair_cdr = (Pair)pair.cdr;
                                    if (pair_cdr.cdr == LList.Empty) break block39;
                                }
                                return tr.syntaxError("invalid used of " + pair.car + " in quasiquote template");
                            }
                            if (depth == 0) {
                                cdr = tr.rewrite_car(pair_cdr, syntax2);
                                break block32;
                            }
                            break block35;
                        }
                        if (tr.matches(pair.car, syntax2, "unquote-splicing")) {
                            return tr.syntaxError("invalid used of " + pair.car + " in quasiquote template");
                        }
                    }
                    if (depth == 1 && pair.car instanceof Pair) {
                        Object form = pair.car;
                        SyntaxForm subsyntax = syntax2;
                        while (form instanceof SyntaxForm) {
                            subsyntax = (SyntaxForm)form;
                            form = subsyntax.form;
                        }
                        int splicing = -1;
                        if (form instanceof Pair) {
                            Object op = ((Pair)form).car;
                            if (tr.matches(op, subsyntax, "unquote")) {
                                splicing = 0;
                            } else if (tr.matches(op, subsyntax, "unquote-splicing")) {
                                splicing = 1;
                            }
                        }
                        if (splicing >= 0) {
                            Vector<Expression> vec;
                            block33: {
                                form = ((Pair)form).cdr;
                                vec = new Vector<Expression>();
                                cdr = null;
                                while (true) {
                                    if (form instanceof SyntaxForm) {
                                        subsyntax = (SyntaxForm)form;
                                        form = subsyntax.form;
                                    }
                                    if (form == LList.Empty) break block33;
                                    if (!(form instanceof Pair)) break;
                                    vec.addElement(tr.rewrite_car((Pair)form, subsyntax));
                                    form = ((Pair)form).cdr;
                                }
                                return tr.syntaxError("improper list argument to unquote");
                            }
                            int nargs = vec.size() + 1;
                            cdr = this.expand(pair.cdr, 1, syntax2, seen, tr);
                            if (nargs > 1) {
                                Object[] args = new Expression[nargs];
                                vec.copyInto(args);
                                args[nargs - 1] = this.coerceExpression(cdr, tr);
                                String method = splicing == 0 ? "consX" : "append";
                                cdr = Invoke.makeInvokeStatic(quoteType, method, (Expression[])args);
                            }
                            rest = pair;
                            break block32;
                        }
                    }
                    if ((car = this.expand(pair.car, depth, syntax2, seen, tr)) != pair.car) break block34;
                    rest = pair.cdr;
                    if (!(rest instanceof Pair)) break;
                    pair = (Pair)rest;
                }
                cdr = this.expand(rest, depth, syntax2, seen, tr);
                break block32;
            }
            cdr = this.expand(pair.cdr, depth, syntax2, seen, tr);
            if (car instanceof Expression || cdr instanceof Expression) {
                Expression[] args = new Expression[]{this.coerceExpression(car, tr), this.coerceExpression(cdr, tr)};
                cdr = Invoke.makeInvokeStatic(Compilation.typePair, "make", args);
            } else {
                cdr = Translator.makePair(pair, car, cdr);
            }
        }
        if (list == rest) {
            return cdr;
        }
        Pair p = list;
        Pair prev = null;
        while (true) {
            Pair q = Translator.makePair(p, p.car, null);
            if (prev == null) {
                list = q;
            } else {
                prev.cdr = q;
            }
            prev = q;
            if (p.cdr == rest) break;
            p = (Pair)p.cdr;
        }
        if (cdr instanceof Expression) {
            Expression[] args = new Expression[2];
            args[1] = (Expression)cdr;
            if (prev == list) {
                args[0] = this.leaf(list.car, tr);
                return Invoke.makeInvokeStatic(Compilation.typePair, "make", args);
            }
            prev.cdr = LList.Empty;
            args[0] = this.leaf(list, tr);
            return Invoke.makeInvokeStatic(quoteType, "append", args);
        }
        prev.cdr = cdr;
        return list;
    }

    Object expand(Object template, int depth, SyntaxForm syntax2, Object seen, Translator tr) {
        Object result;
        IdentityHashMap map2;
        block17: {
            block19: {
                block18: {
                    block16: {
                        map2 = (IdentityHashMap)seen;
                        Object old = map2.get(template);
                        if (old == WORKING) {
                            map2.put(template, CYCLE);
                            return old;
                        }
                        if (old == CYCLE) {
                            return old;
                        }
                        if (old != null) {
                            return old;
                        }
                        if (!(template instanceof Pair)) break block16;
                        result = this.expand_pair((Pair)template, depth, syntax2, seen, tr);
                        break block17;
                    }
                    if (!(template instanceof SyntaxForm)) break block18;
                    syntax2 = (SyntaxForm)template;
                    result = this.expand(syntax2.form, depth, syntax2, seen, tr);
                    break block17;
                }
                if (!(template instanceof FVector)) break block19;
                FVector vector = (FVector)template;
                int n = vector.size();
                Object[] buffer = new Object[n];
                byte[] state = new byte[n];
                byte max_state = 0;
                for (int i = 0; i < n; ++i) {
                    block23: {
                        int element_depth;
                        Object element;
                        block20: {
                            Pair pair_cdr;
                            block22: {
                                Pair pair;
                                block21: {
                                    element = vector.get(i);
                                    element_depth = depth;
                                    if (!(element instanceof Pair) || depth <= -1) break block20;
                                    pair = (Pair)element;
                                    if (!tr.matches(pair.car, syntax2, "unquote-splicing") || --element_depth != 0) break block20;
                                    if (!(pair.cdr instanceof Pair)) break block21;
                                    pair_cdr = (Pair)pair.cdr;
                                    if (pair_cdr.cdr == LList.Empty) break block22;
                                }
                                return tr.syntaxError("invalid used of " + pair.car + " in quasiquote template");
                            }
                            buffer[i] = tr.rewrite_car(pair_cdr, syntax2);
                            state[i] = 3;
                            break block23;
                        }
                        buffer[i] = this.expand(element, element_depth, syntax2, seen, tr);
                        state[i] = buffer[i] == element ? 0 : (buffer[i] instanceof Expression ? 2 : 1);
                    }
                    if (state[i] <= max_state) continue;
                    max_state = state[i];
                }
                if (max_state == 0) {
                    result = vector;
                } else if (max_state == 1) {
                    result = new FVector(buffer);
                } else {
                    Expression[] args = new Expression[n];
                    for (int i = 0; i < n; ++i) {
                        Object[] arg1;
                        if (state[i] == 3) {
                            args[i] = (Expression)buffer[i];
                            continue;
                        }
                        if (max_state < 3) {
                            args[i] = this.coerceExpression(buffer[i], tr);
                            continue;
                        }
                        if (state[i] < 2) {
                            arg1 = new Object[]{buffer[i]};
                            args[i] = this.leaf(new FVector(arg1), tr);
                            continue;
                        }
                        arg1 = new Expression[]{(Expression)buffer[i]};
                        args[i] = Invoke.makeInvokeStatic(vectorType, "vector", (Expression[])arg1);
                    }
                    result = max_state < 3 ? Invoke.makeInvokeStatic(vectorType, "vector", args) : Invoke.makeInvokeStatic(vectorAppendType, "apply", args);
                }
                break block17;
            }
            result = template;
        }
        if (template != result && map2.get(template) == CYCLE) {
            tr.error('e', "cycle in non-literal data");
        }
        map2.put(template, result);
        return result;
    }

    @Override
    public Expression rewrite(Object obj, Translator tr) {
        Pair pair;
        block3: {
            block2: {
                if (!(obj instanceof Pair)) break block2;
                pair = (Pair)obj;
                if (pair.cdr == LList.Empty) break block3;
            }
            return tr.syntaxError("wrong number of arguments to quote");
        }
        return this.coerceExpression(this.expand(pair.car, this.isQuasi ? 1 : -1, tr), tr);
    }

    public static Object consX$V(Object[] args) {
        return LList.consX(args);
    }

    public static Object append$V(Object[] args) {
        int count = args.length;
        if (count == 0) {
            return LList.Empty;
        }
        Object result = args[count - 1];
        int i = count - 1;
        while (--i >= 0) {
            Object list = args[i];
            Pair copy = null;
            Pair last = null;
            SyntaxForm syntax2 = null;
            while (true) {
                if (list instanceof SyntaxForm) {
                    syntax2 = (SyntaxForm)list;
                    list = syntax2.form;
                    continue;
                }
                if (list == LList.Empty) break;
                Pair list_pair = (Pair)list;
                Object car = list_pair.car;
                if (syntax2 != null && !(car instanceof SyntaxForm)) {
                    car = SyntaxForm.make(car, syntax2.scope);
                }
                Pair new_pair = new Pair(car, null);
                if (last == null) {
                    copy = new_pair;
                } else {
                    last.cdr = new_pair;
                }
                last = new_pair;
                list = list_pair.cdr;
            }
            if (last == null) continue;
            last.cdr = result;
            result = copy;
        }
        return result;
    }
}

