/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.KawaConvert;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.StaticFieldConstraint;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.FormatToConsumer;
import gnu.lists.PrintConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.UnboundSymbol;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Interpreter {
    public static Interpreter defaultInterpreter = null;
    public static final String quote_sym = "quote";
    public static final String unquote_sym = "unquote";
    public static final String unquotesplicing_sym = "unquote-splicing";
    public static final String quasiquote_sym = "quasiquote";
    static String[][] languages = new String[][]{{"scheme", ".scm", ".sc", "kawa.standard.Scheme"}, {"krl", ".krl", "gnu.kawa.brl.BRL"}, {"brl", ".brl", "gnu.kawa.brl.BRL"}, {"emacs", "elisp", "emacs-lisp", ".el", "gnu.jemacs.lang.ELisp"}, {"xquery", ".xql", "gnu.xquery.lang.XQuery"}, {"xslt", "xsl", ".xsl", "gnu.kawa.xslt.XSLT"}, {"commonlisp", "common-lisp", "clisp", "lisp", ".lisp", ".lsp", ".cl", "gnu.commonlisp.lang.CommonLisp"}};
    protected Environment environ;
    public static final int PARSE_IMMEDIATE = 1;
    public static final int PARSE_ONE_LINE = 2;
    public static final String NAMESPACE_PREFIX = "$Namespace$";
    public static final int VALUE_NAMESPACE = 1;
    public static final int FUNCTION_NAMESPACE = 2;

    public static Interpreter getInterpreter() {
        return defaultInterpreter;
    }

    public static String[][] getLanguages() {
        return languages;
    }

    public static void registerLanguage(String[] stringArray) {
        String[][] stringArrayArray = new String[languages.length + 1][];
        System.arraycopy(languages, 0, stringArrayArray, 0, languages.length);
        stringArrayArray[stringArrayArray.length - 1] = stringArray;
        languages = stringArrayArray;
    }

    public static Interpreter getInstanceFromFilenameExtension(String string) {
        Interpreter interpreter;
        int n = string.lastIndexOf(46);
        if (n > 0 && (interpreter = Interpreter.getInstance(string.substring(n))) != null) {
            return interpreter;
        }
        return null;
    }

    public static Interpreter getInstance(String string) {
        int n = languages.length;
        block2: for (int i = 0; i < n; ++i) {
            int n2;
            String[] stringArray = languages[i];
            int n3 = n2 = stringArray.length - 1;
            while (--n3 >= 0) {
                Class<?> clazz;
                if (string != null && !stringArray[n3].equalsIgnoreCase(string)) continue;
                try {
                    clazz = Class.forName(stringArray[n2]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue block2;
                }
                return Interpreter.getInstance(stringArray[0], clazz);
            }
        }
        return null;
    }

    protected Interpreter() {
        Convert.setInstance(KawaConvert.getInstance());
    }

    public static Interpreter getInstance(String string, Class clazz) {
        try {
            Method method;
            Class[] classArray = new Class[]{};
            try {
                String string2 = Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase();
                String string3 = "get" + string2 + "Instance";
                method = clazz.getDeclaredMethod(string3, classArray);
            }
            catch (Exception exception) {
                method = clazz.getDeclaredMethod("getInstance", classArray);
            }
            return (Interpreter)method.invoke(null, Values.noArgs);
        }
        catch (Exception exception) {
            string = clazz.getName();
            Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
            throw new WrappedException("getInstance for '" + string + "' failed", throwable);
        }
    }

    public boolean isTrue(Object object2) {
        return object2 != Boolean.FALSE;
    }

    public Object booleanObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object noValue() {
        return Values.empty;
    }

    public boolean hasSeparateFunctionNamespace() {
        return false;
    }

    public Environment getEnvironment() {
        return this.environ;
    }

    public void setEnvironment(Environment environment) {
        this.environ = environment;
    }

    public void define(String string, Object object2) {
        this.environ.define(string, object2);
    }

    protected void define_method(String string, String string2, String string3) {
        this.environ.define(string, ClassMethods.apply(string2, string3));
    }

    protected void define_field(String string, String string2, String string3) {
        StaticFieldConstraint.define(this.environ, string, string2, string3);
    }

    protected void define_field(String string, String string2) {
        StaticFieldConstraint.define(this.environ, string, string2, Compilation.mangleNameIfNeeded(string));
    }

    public final void defineFunction(Named named) {
        this.defineFunction(named.getName(), named);
    }

    public void defineFunction(String string, Object object2) {
        this.environ.define(string, object2);
    }

    public void defineAll(Object object2) {
        Class<?> clazz = object2.getClass();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            String string = field.getName();
            if ((field.getModifiers() & 0x10) != 0) {
                try {
                    this.defineFromFieldValue(string, field.get(object2));
                    continue;
                }
                catch (Throwable throwable) {
                    throw new WrappedException("error accessing field " + field, throwable);
                }
            }
            System.err.println("INTERNAL ERROR in defineAll for " + string + " in " + clazz);
        }
    }

    public void defineFromFieldValue(String string, Object object2) throws Throwable {
        string = object2 instanceof Named ? ((Named)object2).getName() : string.intern();
        if (object2 instanceof Symbol) {
            this.environ.addSymbol((Symbol)object2);
        } else {
            this.environ.define(string, object2);
        }
    }

    public void loadClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            this.defineAll(obj);
            if (obj instanceof ModuleBody) {
                ((ModuleBody)obj).run();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new WrappedException("cannot load " + string, exception);
        }
    }

    public Object lookup(String string) {
        return this.environ.get(string);
    }

    public abstract Object read(InPort var1) throws IOException, SyntaxException;

    public void print(Object object2, OutPort outPort) {
        this.print(object2, outPort, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object object2, OutPort outPort, boolean bl) {
        if (object2 == Values.empty) {
            return;
        }
        FormatToConsumer formatToConsumer = outPort.objectFormat;
        try {
            outPort.objectFormat = this.getFormat(bl);
            if (object2 instanceof Values) {
                Object[] objectArray = ((Values)object2).getValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    outPort.println(objectArray[i]);
                }
            } else {
                outPort.println(object2);
            }
        }
        finally {
            outPort.objectFormat = formatToConsumer;
        }
    }

    public abstract FormatToConsumer getFormat(boolean var1);

    public Consumer getOutputConsumer(Writer writer) {
        OutPort outPort = writer instanceof OutPort ? (OutPort)writer : new OutPort(writer);
        outPort.objectFormat = this.getFormat(false);
        return outPort;
    }

    public Environment getNewEnvironment() {
        return new Environment(this.environ);
    }

    public abstract String getName();

    public abstract Lexer getLexer(InPort var1, SourceMessages var2);

    public final Compilation parse(InPort inPort, SourceMessages sourceMessages, int n) throws IOException, SyntaxException {
        Lexer lexer = this.getLexer(inPort, sourceMessages);
        return this.parse(lexer, n);
    }

    public abstract Compilation parse(Lexer var1, int var2) throws IOException, SyntaxException;

    public abstract Type getTypeFor(Class var1);

    public static Type string2Type(String string) {
        Type type;
        if (string.endsWith("[]")) {
            type = Interpreter.string2Type(string.substring(0, string.length() - 2));
            if (type == null) {
                return null;
            }
            type = ArrayType.make(type);
        } else if (Type.isValidJavaTypeName(string)) {
            type = Type.getType(string);
        } else {
            return null;
        }
        return type;
    }

    public Type getTypeFor(String string) {
        return Interpreter.string2Type(string);
    }

    public Type asType(Object object2) {
        if (!(object2 instanceof Type)) {
            if (object2 instanceof Class) {
                return this.getTypeFor((Class)object2);
            }
            if (object2 instanceof String) {
                return this.getTypeFor(object2.toString());
            }
            if (object2 instanceof Symbol) {
                return this.getTypeFor(((Symbol)object2).getName());
            }
            if (object2 instanceof CharSeq) {
                return ClassType.make(object2.toString());
            }
        }
        return (Type)object2;
    }

    public Type getTypeFor(Expression expression) {
        if (expression instanceof QuoteExp) {
            try {
                return this.asType(((QuoteExp)expression).getValue());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (expression instanceof ReferenceExp) {
            Object object2;
            ReferenceExp referenceExp = (ReferenceExp)expression;
            Declaration declaration = Declaration.followAliases(referenceExp.getBinding());
            String string = referenceExp.getName();
            if (declaration != null) {
                string = declaration.getName();
                expression = declaration.getValue();
                if (declaration.isAlias() && expression instanceof QuoteExp) {
                    object2 = ((QuoteExp)expression).getValue();
                    if (object2 instanceof Location) {
                        Location location2 = (Location)object2;
                        if (location2.isBound()) {
                            return this.asType(location2.get());
                        }
                        if (!(location2 instanceof Named)) {
                            return null;
                        }
                        string = location2.getName();
                    }
                } else if (!declaration.getFlag(65536)) {
                    return this.getTypeFor(expression);
                }
            }
            if ((object2 = Environment.getCurrent().get(string)) instanceof Type) {
                return (Type)object2;
            }
            int n = string.length();
            if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                return this.getTypeFor(string.substring(1, n - 1));
            }
        } else if (expression instanceof ClassExp) {
            return ((ClassExp)expression).getType();
        }
        return null;
    }

    public int getNamespaceOf(Declaration declaration) {
        return 1;
    }

    public void emitPushBoolean(boolean bl, CodeAttr codeAttr) {
        codeAttr.emitGetStatic(bl ? Compilation.trueConstant : Compilation.falseConstant);
    }

    public void emitCoerceToBoolean(CodeAttr codeAttr) {
        this.emitPushBoolean(false, codeAttr);
        codeAttr.emitIfNEq();
        codeAttr.emitPushInt(1);
        codeAttr.emitElse();
        codeAttr.emitPushInt(0);
        codeAttr.emitFi();
    }

    public Object coerceFromObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceFromObject(object2);
    }

    public Object coerceToObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceToObject(object2);
    }

    public Object coerceToObject(int n) {
        return IntNum.make(n);
    }

    public Procedure getPrompter() {
        Symbol symbol = Environment.getCurrentSymbol("default-prompter");
        return symbol == null ? null : symbol.getProcedure();
    }

    public final Object eval(String string) throws Throwable {
        return this.eval(new CharArrayInPort(string));
    }

    public final Object eval(Reader reader) throws Throwable {
        return this.eval(reader instanceof InPort ? (InPort)reader : new InPort(reader));
    }

    public final Object eval(InPort inPort) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            this.eval(inPort, callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public final void eval(String string, Writer writer) throws Throwable {
        this.eval((Reader)new CharArrayInPort(string), writer);
    }

    public final void eval(String string, PrintConsumer printConsumer) throws Throwable {
        this.eval(string, this.getOutputConsumer(printConsumer));
    }

    public final void eval(String string, Consumer consumer) throws Throwable {
        this.eval((Reader)new CharArrayInPort(string), consumer);
    }

    public final void eval(Reader reader, Writer writer) throws Throwable {
        this.eval(reader, this.getOutputConsumer(writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(Reader reader, Consumer consumer) throws Throwable {
        InPort inPort = reader instanceof InPort ? (InPort)reader : new InPort(reader);
        CallContext callContext = CallContext.getInstance();
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            this.eval(inPort, callContext);
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void eval(InPort inPort, CallContext callContext) throws Throwable {
        Interpreter interpreter;
        SourceMessages sourceMessages;
        block5: {
            sourceMessages = new SourceMessages();
            Environment environment = Environment.getCurrent();
            if (environment != this.environ) {
                Environment.setCurrent(this.environ);
            }
            interpreter = defaultInterpreter;
            defaultInterpreter = this;
            try {
                Compilation compilation = this.parse(inPort, sourceMessages, 1);
                ModuleExp.evalModule(this.environ, callContext, compilation);
                Object var8_7 = null;
                if (environment == this.environ || environment == null) break block5;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (environment != this.environ && environment != null) {
                    Environment.setCurrent(environment);
                }
                defaultInterpreter = interpreter;
                throw throwable;
            }
            Environment.setCurrent(environment);
        }
        defaultInterpreter = interpreter;
        if (sourceMessages.seenErrors()) {
            throw new RuntimeException("invalid syntax in eval form:\n" + sourceMessages.toString(20));
        }
    }

    public Object getDefaultSymbolValue(Symbol symbol, boolean bl) {
        Environment environment;
        String string = symbol.getNamespaceURI();
        String string2 = symbol.getName();
        if ((bl || !this.hasSeparateFunctionNamespace()) && string != null && string.startsWith("class:")) {
            return ClassMethods.apply(string.substring(6), string2);
        }
        int n = string2.indexOf(58);
        if (n >= 0 & (environment = symbol.getEnvironment()) != null) {
            String string3 = (NAMESPACE_PREFIX + string2.substring(0, n)).intern();
            Object object2 = environment.get(string3, null);
            if (object2 == null && n == 0) {
                object2 = "";
            }
            if (object2 != null) {
                symbol = Symbol.make(object2, string2.substring(n + 1));
                return bl ? Interpreter.getSymbolProcedure(symbol) : Interpreter.getSymbolValue(symbol);
            }
        }
        throw new UnboundSymbol(string2);
    }

    public static Object getSymbolValue(Symbol symbol) {
        Object object2 = symbol.get(Symbol.UNBOUND);
        if (object2 == Symbol.UNBOUND) {
            return Interpreter.getInterpreter().getDefaultSymbolValue(symbol, false);
        }
        return object2;
    }

    public static Procedure getSymbolProcedure(Symbol symbol) {
        Object object2 = symbol.getFunctionValue(Symbol.UNBOUND);
        if (object2 == Symbol.UNBOUND) {
            object2 = symbol.get(Symbol.UNBOUND);
        }
        if (object2 == Symbol.UNBOUND) {
            object2 = Interpreter.getInterpreter().getDefaultSymbolValue(symbol, true);
        }
        return (Procedure)object2;
    }
}

