/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Symbol;

public class BufferLocalConstraint
extends Constraint {
    Constraint oldConstraint;
    boolean all;
    Buffer lastBuffer;
    Object lastValue;
    Object[] bufferBindings;

    public static void make(Symbol symbol, boolean all) {
        BufferLocalConstraint newConstraint;
        Constraint oldConstraint = BufferLocalConstraint.getConstraint(symbol);
        if (oldConstraint instanceof BufferLocalConstraint) {
            newConstraint = (BufferLocalConstraint)oldConstraint;
        } else {
            newConstraint = new BufferLocalConstraint();
            newConstraint.all = all;
            newConstraint.oldConstraint = oldConstraint;
            symbol.setConstraint(newConstraint);
        }
        if (!all) {
            Buffer buffer = Buffer.getCurrent();
            if (newConstraint.lastBuffer != buffer) {
                newConstraint.save();
            }
            newConstraint.lastBuffer = buffer;
            newConstraint.lastValue = newConstraint;
        }
    }

    private void save() {
        if (this.lastBuffer == null || this.lastValue == this) {
            return;
        }
        if (this.bufferBindings == null) {
            this.bufferBindings = new Object[20];
            this.bufferBindings[0] = this.lastBuffer;
            this.bufferBindings[1] = this.lastValue;
            return;
        }
        int len = this.bufferBindings.length;
        for (int i = 0; i < len; i += 2) {
            if (this.bufferBindings[i] != this.lastBuffer) continue;
            this.bufferBindings[i + 1] = this.lastValue;
            return;
        }
        Object[] newBindings = new Object[2 * len];
        System.arraycopy(this.bufferBindings, 0, newBindings, 0, len);
        newBindings[len] = this.lastBuffer;
        newBindings[len + 1] = this.lastValue;
        this.bufferBindings = newBindings;
    }

    public boolean isBound(Symbol symbol) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == this.lastBuffer) {
            if (this.lastValue != this) {
                return true;
            }
        } else if (this.bufferBindings != null) {
            this.save();
            this.lastBuffer = buffer;
            int len = this.bufferBindings.length;
            for (int i = 0; i < len; i += 2) {
                if (this.bufferBindings[i] != buffer) continue;
                this.lastValue = this.bufferBindings[i + 1];
                if (this.lastValue == this) break;
                return true;
            }
            this.lastValue = this;
        }
        return this.oldConstraint.isBound(symbol);
    }

    public Object get(Symbol symbol, Object defaultValue) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == this.lastBuffer) {
            if (this.lastValue != this) {
                return this.lastValue;
            }
        } else if (this.bufferBindings != null) {
            int len = this.bufferBindings.length;
            for (int i = 0; i < len; i += 2) {
                if (this.bufferBindings[i] != buffer) continue;
                this.save();
                this.lastBuffer = buffer;
                this.lastValue = this.bufferBindings[i + 1];
                if (this.lastValue == this) break;
                return this.lastValue;
            }
        }
        this.lastValue = this.oldConstraint.get(symbol, defaultValue);
        this.lastBuffer = buffer;
        return this.lastValue;
    }

    public void set(Symbol symbol, Object value) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer != this.lastBuffer) {
            this.save();
            this.lastBuffer = buffer;
            int len = this.bufferBindings.length;
            int i = 0;
            while (true) {
                if (i == len) {
                    this.lastValue = this;
                    break;
                }
                if (this.bufferBindings[i] == buffer) {
                    this.lastValue = this.bufferBindings[i + 1];
                    break;
                }
                i += 2;
            }
        }
        if (this.all || this.lastValue != this) {
            this.lastValue = value;
            return;
        }
        this.oldConstraint.set(symbol, value);
    }

    public Environment getEnvironment(Symbol symbol) {
        return this.oldConstraint.getEnvironment(symbol);
    }
}

