/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Command;
import gnu.jemacs.buffer.IgnoreAction;
import gnu.jemacs.lang.ELisp;
import gnu.kawa.util.RangeTable;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.Sequence;
import gnu.mapping.Named;
import gnu.mapping.Symbol;
import gnu.math.IntNum;
import gnu.text.Char;
import java.util.Enumeration;

public class EKeymap
extends RangeTable
implements Named {
    public static final EKeymap[] empty = new EKeymap[0];
    EKeymap[] parents = empty;
    public static int PRESSED = 256;
    public static int RELEASED = 512;
    Object defaultBinding;
    String name;
    public static final int metaKey = 27;
    public static EKeymap globalKeymap = new EKeymap();
    public static EKeymap metaKeymap = new EKeymap("ESC-map");
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 8;
    static final int ALT_MASK = 4;

    public EKeymap(String name) {
        this.name = name;
    }

    public EKeymap() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final Object getDefaultBinding() {
        return this.defaultBinding;
    }

    public void setDefaultBinding(Object value) {
        this.defaultBinding = value;
    }

    public static int getModifiers(int code) {
        return code >> 16 & 0xFF;
    }

    public EKeymap[] getParents() {
        return this.parents;
    }

    public void setParents(EKeymap[] parents) {
        this.parents = parents;
    }

    public void setParent(EKeymap parent) {
        this.parents = parent == null ? empty : new EKeymap[]{parent};
    }

    public EKeymap getParent() {
        int num = this.parents.length;
        if (num == 0) {
            return null;
        }
        if (num == 1) {
            return this.parents[0];
        }
        throw new Error("multiple parents - set getParents, not getParent");
    }

    public void setAction(int key, Object command) {
        this.set(key, command);
    }

    public Object get(int key, int modifiers, boolean acceptDefaults) {
        return this.get(key | modifiers << 16, acceptDefaults);
    }

    protected Object get(int key, boolean acceptDefaults) {
        Object value = super.lookup(key, null);
        if (value != null) {
            return value;
        }
        if (acceptDefaults && this.defaultBinding != null) {
            return this.defaultBinding;
        }
        int plen = this.parents.length;
        for (int i = 0; i < plen; ++i) {
            value = this.parents[i].get(key, acceptDefaults);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(40);
        sbuf.append("#<keymap ");
        if (this.name != null) {
            sbuf.append(this.name);
            sbuf.append(' ');
        }
        sbuf.append("0x");
        sbuf.append(Integer.toHexString(System.identityHashCode(this)));
        sbuf.append('>');
        return sbuf.toString();
    }

    public EKeymap definePrefix(int key) {
        Object command;
        Object cc = command = this.get(key, false);
        if (command == null) {
            EKeymap next = new EKeymap(null);
            this.set(key, next);
            return next;
        }
        if ((command = Command.resolveSymbol(command)) instanceof EKeymap) {
            return (EKeymap)command;
        }
        throw new Error("prefix command cannot override exiting action: " + cc + " : " + cc.getClass() + " -> " + command + " key " + key + "=" + EKeymap.toString(key) + " in " + this);
    }

    public void defineKey(Object keySpec, Object binding) {
        EKeymap keymap2 = this;
        if (keySpec instanceof Sequence && !(keySpec instanceof LList)) {
            Sequence value = (Sequence)keySpec;
            boolean hackMeta = keySpec instanceof FString;
            int len = value.size();
            int i = 0;
            while (i < len) {
                Object keyValue = value.get(i);
                boolean sawMeta = false;
                ++i;
                int key = EKeymap.asKeyStroke(keyValue);
                if (key == 0) {
                    throw new Error("unknown keyspec: " + keyValue);
                }
                if (hackMeta && key > 127 && key <= 255) {
                    sawMeta = true;
                    key -= 128;
                }
                if ((EKeymap.getModifiers(key) & 8) != 0) {
                    key = EKeymap.stripMeta(key);
                    sawMeta = true;
                }
                if (sawMeta) {
                    keymap2 = keymap2.definePrefix(27);
                }
                if (i < len) {
                    keymap2 = keymap2.definePrefix(key);
                    continue;
                }
                keymap2.defineKey(key, binding);
            }
        } else {
            int key = EKeymap.asKeyStroke(keySpec);
            if (key == 0) {
                throw new Error("unknown keyspec: " + keySpec);
            }
            this.defineKey(key, binding);
        }
    }

    public void defineKey(int key, Object binding) {
        boolean sawMeta = false;
        if ((EKeymap.getModifiers(key) & 8) != 0) {
            key = EKeymap.stripMeta(key);
            sawMeta = true;
        }
        EKeymap keymap2 = this;
        if (sawMeta) {
            keymap2 = keymap2.definePrefix(27);
        }
        keymap2.setAction(key, binding);
    }

    public static int asKeyStroke(char ch, int mods) {
        if (mods == 1 && Character.isLetter(ch)) {
            ch = Character.toUpperCase(ch);
            mods = 0;
        }
        if (ch < ' ') {
            mods |= 2 | PRESSED;
            ch = (char)(ch == '\u0000' ? 32 : (char)(64 + (ch & 0x1F)));
        }
        return ch | mods << 16;
    }

    public static int getKeyForName(String name) {
        int len = (name = name.toLowerCase()).length();
        if (len == 0) {
            return 0;
        }
        char c0 = name.charAt(0);
        if (len == 1) {
            return c0;
        }
        switch (c0) {
            case 'b': {
                if (name != "backspace") break;
                return 8;
            }
            case 'd': {
                if (name == "delete") {
                    return 127;
                }
                if (name != "down") break;
                return 40;
            }
            case 'e': {
                if (name != "enter") break;
                return 10;
            }
            case 'f': {
                if (len == 2) {
                    char c1 = name.charAt(1);
                    if (c1 <= '0' || c1 > '9') break;
                    return 112 + c1 - 49;
                }
                if (len != 3 || name.charAt(0) != 'f') break;
                int c1 = name.charAt(1);
                char c2 = name.charAt(2);
                if (c1 <= 48 || c1 > 57 || c2 <= '0' || c2 > '9' || (c1 = (c1 - 48) * 10 + (c2 - 48)) > 24) break;
                if (c1 <= 12) {
                    return 121 + c2 - 48;
                }
                return 61440 + c1 - 13;
            }
            case 'h': {
                if (name != "help") break;
                return 156;
            }
            case 'k': {
                if (name == "kp-left") {
                    return 226;
                }
                if (name == "kp-right") {
                    return 227;
                }
                if (name == "kp-up") {
                    return 224;
                }
                if (name == "kp-down") {
                    return 225;
                }
                if (name != "kp-delete") break;
                return 127;
            }
            case 'l': {
                if (name != "left") break;
                return 37;
            }
            case 'n': {
                if (name != "next") break;
                return 34;
            }
            case 'p': {
                if (name != "prior") break;
                return 33;
            }
            case 'r': {
                if (name == "enter") {
                    return 10;
                }
                if (name == "return") {
                    return 10;
                }
                if (name != "right") break;
                return 39;
            }
            case 't': {
                if (name != "tab") break;
                return 9;
            }
            case 'u': {
                if (name != "up") break;
                return 38;
            }
        }
        return 0;
    }

    public static int asKeyStroke(Object key) {
        int m = 0;
        while (key instanceof Pair) {
            Pair pair = (Pair)key;
            if (pair.cdr == LList.Empty) {
                key = pair.car;
                continue;
            }
            Object car = pair.car;
            if (car instanceof Symbol) {
                car = ((Symbol)car).getName();
            }
            if (car == "control") {
                m |= 2;
            }
            if (car == "meta") {
                m |= 8;
            }
            if (car == "shift") {
                m |= 1;
            }
            if (car == "alt") {
                m |= 4;
            }
            key = pair.cdr;
        }
        if (key instanceof Char) {
            return EKeymap.asKeyStroke(((Char)key).charValue(), m);
        }
        if (key instanceof IntNum) {
            return EKeymap.asKeyStroke((char)((IntNum)key).intValue(), m);
        }
        if (key instanceof String || key instanceof Symbol) {
            String name;
            String string = name = key instanceof String ? (String)key : ((Symbol)key).getName();
            if (name.length() == 1) {
                char ch = name.charAt(0);
                if (m == 0) {
                    return EKeymap.asKeyStroke(ch, 0);
                }
                ch = Character.toUpperCase(ch);
                return EKeymap.asKeyStroke(ch, m);
            }
            int code = EKeymap.getKeyForName(name);
            if (code == 0) {
                throw new Error("unknown key-name: " + name);
            }
            return code | (m | PRESSED) << 16;
        }
        return 0;
    }

    public static int stripMeta(int key) {
        boolean onRelease;
        int mods = EKeymap.getModifiers(key);
        if ((mods & 8) == 0) {
            return key;
        }
        int code = key & 0xFFFF;
        boolean bl = onRelease = (key & RELEASED << 16) != 0;
        if (((mods &= 0xFFFFFFF7) & 0xFFFFFFFE) != 0 || onRelease || code > 127 || code < 32) {
            return code | (mods | RELEASED) << 16;
        }
        if (code >= 65 && code <= 90 && mods != 1) {
            code = code + 97 - 65;
        }
        return code;
    }

    public static boolean ignorable(int key) {
        if ((key & RELEASED << 16) != 0) {
            return true;
        }
        int mods = EKeymap.getModifiers(key);
        int code = key & 0xFFFF;
        if ((key & PRESSED << 16) == 0) {
            char ch = (char)key;
            return ch < ' ' || ch >= '\u007f';
        }
        if (code == 17 || code == 16 || code == 18 || code == 157) {
            return true;
        }
        return (mods & 0xFFFFFFFE) == 0 && code >= 32 && code < 127;
    }

    public static String toString(int code) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('[');
        if ((code >> 16 & (PRESSED | RELEASED)) == 0) {
            sbuf.append("char:'");
            ELisp.readableChar((char)code, sbuf, true);
            sbuf.append("'");
        } else {
            sbuf.append("code:");
            sbuf.append(code & 0xFFFF);
        }
        int mods = code >> 16 & 0xFF;
        if (mods != 0) {
            sbuf.append(" mods:");
            sbuf.append(mods);
        }
        if ((code & RELEASED << 16) != 0) {
            sbuf.append(" release");
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    public Object lookupKey(Sequence keys, boolean acceptDefaults) {
        int nKeys = keys.size();
        int[] prefixKeys = new int[nKeys];
        Enumeration enumKeys = keys.elements();
        int i = 0;
        while (enumKeys.hasMoreElements()) {
            prefixKeys[i] = EKeymap.asKeyStroke(enumKeys.nextElement());
            ++i;
        }
        return this.lookupKey(prefixKeys, nKeys, 0, acceptDefaults);
    }

    public Object lookupKey(int[] prefixKeys, int nPrefix, int key, boolean acceptDefaults) {
        EKeymap keymap2 = this;
        int nKeys = nPrefix + (key != 0 ? 1 : 0);
        boolean pendingMeta = false;
        if (nKeys == 0) {
            throw new Error("no keys");
        }
        int i = 0;
        while (true) {
            Object metaCommand;
            Object command;
            int key_i;
            int n = key_i = i == nPrefix ? key : prefixKeys[i];
            if (pendingMeta) {
                key_i |= (8 | PRESSED) << 16;
            }
            if ((command = keymap2.get(key_i, false)) == null && (EKeymap.getModifiers(key_i) & 8) != 0 && (metaCommand = keymap2.get(27, false)) instanceof EKeymap) {
                command = ((EKeymap)metaCommand).get(EKeymap.stripMeta(key_i), false);
            }
            ++i;
            if (command == null) {
                if (EKeymap.ignorable(key)) {
                    return IgnoreAction.getInstance();
                }
                return keymap2.getDefaultBinding();
            }
            if (i == nKeys) {
                return command;
            }
            if (command instanceof String || command instanceof Symbol) {
                command = Command.resolveSymbol(command);
            }
            if (!(command instanceof EKeymap)) break;
            keymap2 = (EKeymap)command;
        }
        return null;
    }

    static {
        globalKeymap.setAction(27, metaKeymap);
    }
}

