/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.bytecode.Type;
import gnu.commonlisp.lang.Lisp2;
import gnu.commonlisp.lang.SymbolTable;
import gnu.commonlisp.lang.Symbols;
import gnu.commonlisp.lang.UnwindProtect;
import gnu.commonlisp.lang.defun;
import gnu.commonlisp.lang.defvar;
import gnu.commonlisp.lang.function;
import gnu.commonlisp.lang.prog1;
import gnu.commonlisp.lang.setq;
import gnu.expr.Interpreter;
import gnu.jemacs.buffer.SelfInsertCommand;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.lang.AddOp;
import gnu.jemacs.lang.DivideOp;
import gnu.jemacs.lang.ELispReader;
import gnu.jemacs.lang.NumberCompare;
import gnu.jemacs.lang.Print;
import gnu.jemacs.lang.SaveExcursion;
import gnu.jemacs.lang.While;
import gnu.jemacs.lang.defcustom;
import gnu.jemacs.lang.defgroup;
import gnu.jemacs.lang.lambda;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.SymbolEnumeration;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import javax.swing.text.Position;
import kawa.lang.Syntax;
import kawa.repl;
import kawa.standard.Scheme;
import kawa.standard.and_or;
import kawa.standard.begin;
import kawa.standard.fluid_let;
import kawa.standard.ifp;
import kawa.standard.not;

public class ELisp
extends Lisp2 {
    static boolean charIsInt = false;
    static ELisp instance;
    static int elispCounter;
    static final DisplayFormat writeFormat;
    static final DisplayFormat displayFormat;
    LangPrimType booleanType;

    public static Object getCharacter(int c) {
        if (charIsInt) {
            return IntNum.make(c);
        }
        return Char.make((char)c);
    }

    public static Numeric asNumber(Object arg) {
        if (arg instanceof Char) {
            return IntNum.make(((Char)arg).intValue());
        }
        if (arg instanceof Position) {
            return IntNum.make(1 + ((Position)arg).getOffset());
        }
        return (Numeric)arg;
    }

    public static char asChar(Object x) {
        if (x instanceof Char) {
            return ((Char)x).charValue();
        }
        int i = x instanceof Numeric ? ((Numeric)x).intValue() : (x instanceof Position ? ((Position)x).getOffset() + 1 : -1);
        if (i < 0 || i > 65535) {
            throw new Signal("error", "not a character value");
        }
        return (char)i;
    }

    public Lexer getLexer(InPort inp, SourceMessages messages) {
        return new ELispReader(inp, messages);
    }

    public String getName() {
        return "Emacs-Lisp";
    }

    protected void defun(String name, Object value) {
        Named n;
        Symbols.setFunctionBinding(this.environ, name, value);
        if (value instanceof Named && (n = (Named)value).getName() == null) {
            n.setName(name);
        }
    }

    private void defun(Procedure proc) {
        this.defun(proc.getName(), proc);
    }

    public ELisp() {
        Environment scmEnv = Scheme.builtin();
        this.environ = SymbolTable.make("interaction-environment." + ++elispCounter);
        Environment.setCurrent(this.environ);
        TRUE = this.environ.getSymbol("t");
        TRUE.set(TRUE);
        this.define("nil", FALSE);
        Scheme.getInstance();
        SymbolEnumeration e = Scheme.builtin().enumerateAllSymbols();
        while (e.hasMoreElements()) {
            Symbol b = e.nextSymbol();
            Object val = b.get(null);
            if (val == null) continue;
            String name = b.getName();
            if (val instanceof Procedure || val instanceof Syntax) {
                this.defun(name, val);
                continue;
            }
            this.define(name, val);
        }
        if (instance == null) {
            instance = this;
        }
        try {
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
            this.loadClass("gnu.jemacs.lang.NumberOps");
            this.loadClass("gnu.jemacs.lang.MiscOps");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        this.defun(AddOp.$Pl);
        this.defun(AddOp.$Mn);
        this.defun(DivideOp.$Sl);
        this.defun(NumberCompare.$Eq);
        this.defun(NumberCompare.$Ls);
        this.defun(NumberCompare.$Gr);
        this.defun(NumberCompare.$Ls$Eq);
        this.defun(NumberCompare.$Gr$Eq);
        this.defun("self-insert-command", new SelfInsertCommand());
        lambda lambda2 = new lambda();
        lambda2.setKeywords(ELisp.getSymbol("&optional"), ELisp.getSymbol("&rest"), ELisp.getSymbol("&key"));
        lambda2.defaultDefault = nilExpr;
        this.defun("lambda", lambda2);
        this.defun("defun", new defun(lambda2));
        this.defun("function", new function(lambda2));
        this.defun("defgroup", new defgroup());
        this.defun("defcustom", new defcustom());
        this.defun("defvar", new defvar(false));
        this.defun("defconst", new defvar(true));
        this.defun("defsubst", new defun(lambda2));
        this.defun("setq", new setq());
        this.defun("prog1", prog1.prog1);
        this.defun("prog2", prog1.prog2);
        this.defun("progn", new begin());
        this.defun("if", new ifp());
        this.defun("or", new and_or(false, this));
        this.defun("and", new and_or(true, this));
        this.defun("while", new While());
        this.defun("unwind-protect", new UnwindProtect());
        this.defun("save-excursion", new SaveExcursion(false));
        this.defun("save-current-buffer", new SaveExcursion(true));
        this.defun("let", new fluid_let(false, nilExpr));
        this.defun("let*", new fluid_let(true, nilExpr));
        this.define_field("concat", "kawa.lib.strings", "string$Mnappend");
        not not2 = new not(this);
        this.defun("not", not2);
        this.defun("null", not2);
        this.defun("eq", new IsEq(this, "eq"));
        this.defun("equal", new IsEqual(this, "equal"));
        this.defun("typep", new InstanceOf(this));
        this.defun("princ", displayFormat);
        this.defun("prin1", writeFormat);
        try {
            this.loadClass("gnu.jemacs.lisp.primitives");
            this.loadClass("gnu.jemacs.buffer.emacs");
            this.loadClass("gnu.jemacs.lisp.simple");
            this.loadClass("gnu.jemacs.lisp.autoloads");
            this.loadClass("gnu.jemacs.lisp.keymap");
            this.loadClass("gnu.jemacs.lisp.editfns");
            this.loadClass("gnu.jemacs.lisp.keydefs");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ELisp getInstance() {
        if (instance == null) {
            Environment saveEnv = Environment.getCurrent();
            try {
                instance = new ELisp();
            }
            finally {
                Environment.setCurrent(saveEnv);
            }
        }
        return instance;
    }

    public static void registerEnvironment() {
        ELisp interp = new ELisp();
        Interpreter.defaultInterpreter = interp;
        Environment.setCurrent(interp.getEnvironment());
    }

    public Object read(InPort in) throws IOException, SyntaxException {
        return ELispReader.readObject(in);
    }

    public FormatToConsumer getFormat(boolean readable) {
        return readable ? writeFormat : displayFormat;
    }

    public Type getTypeFor(String name) {
        if (name == "t") {
            name = "java.lang.Object";
        } else if (name == "marker") {
            name = "gnu.jemacs.buffer.Marker";
        } else if (name == "buffer") {
            name = "gnu.jemacs.buffer.Buffer";
        } else if (name == "window") {
            name = "gnu.jemacs.buffer.Window";
        }
        return Scheme.string2Type(name);
    }

    public Type getTypeFor(Class clas) {
        if (clas.isPrimitive()) {
            String name = clas.getName();
            if (name.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(name);
        }
        return Type.make(clas);
    }

    public void defineFromFieldValue(String name, Object part) throws Throwable {
        name = part instanceof Named ? ((Named)part).getName() : name.intern();
        if (part instanceof Symbol) {
            this.environ.addSymbol((Symbol)part);
        } else if (part instanceof Procedure || part instanceof Syntax) {
            Symbols.setFunctionBinding(this.environ, name, part);
        } else {
            this.environ.define(name, part);
        }
    }

    public static void readableChar(char ch, StringBuffer buf, boolean quote) {
        if (quote && (ch == '\\' || ch == '\'' || ch == '\"')) {
            buf.append('\\');
            buf.append(ch);
        } else if (ch > '\u007f') {
            buf.append("\\u");
            String hex = Integer.toHexString(ch);
            for (int i = hex.length(); i < 4; ++i) {
                buf.append('0');
            }
            buf.append(hex);
        } else if (ch >= ' ') {
            buf.append(ch);
        } else if (ch == '\t') {
            buf.append("\\t");
        } else if (ch == '\r') {
            buf.append("\\r");
        } else if (ch == '\n') {
            buf.append("\\n");
        } else {
            buf.append("\\0");
            buf.append(ch >> 3 & 7);
            buf.append(ch & 7);
        }
    }

    public static String readableString(Object obj) {
        String str = obj.toString();
        StringBuffer buf = new StringBuffer(200);
        for (int i = 0; i < str.length(); ++i) {
            ELisp.readableChar(str.charAt(i), buf, false);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        ELisp.registerEnvironment();
        if (args.length == 0) {
            args = new String[]{"-e", "(emacs)", "--"};
        }
        repl.main(args);
    }

    static {
        elispCounter = 0;
        writeFormat = new Print(true);
        displayFormat = new Print(false);
    }
}

