/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Signal;
import gnu.jemacs.swing.GapPosition;
import gnu.jemacs.swing.GapUndoableEdit;
import gnu.lists.CharBuffer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class BufferContent
extends CharBuffer
implements AbstractDocument.Content {
    public BufferContent() {
        this(100);
    }

    public BufferContent(int initialSize) {
        super(initialSize);
        this.gapEnd = initialSize - 1;
        this.getArray()[this.gapEnd] = 10;
    }

    protected int getChars(int where, int len) throws BadLocationException {
        int length = this.length();
        if (where < 0 || where > length) {
            throw new BadLocationException("bad location (in getChars)", where);
        }
        if (len < 0) {
            len = 0;
        } else if (where + len > length) {
            len = length - where;
        }
        if (where + len <= this.gapStart) {
            return where;
        }
        if (where >= this.gapStart) {
            return where + (this.gapEnd - this.gapStart);
        }
        if (this.gapStart - where > len >> 1) {
            this.shiftGap(where + len);
            return where;
        }
        this.shiftGap(where);
        return where + (this.gapEnd - this.gapStart);
    }

    public void getChars(int where, int len, Segment txt) throws BadLocationException {
        txt.offset = this.getChars(where, len);
        txt.array = this.getArray();
        txt.count = len;
    }

    public String getString(int where, int len) throws BadLocationException {
        return new String(this.getArray(), this.getChars(where, len), len);
    }

    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        if (nitems < 0 || where < 0 || where + nitems > this.length()) {
            throw new BadLocationException("invalid remove", where);
        }
        this.delete(where, nitems);
        GapUndoableEdit undo = new GapUndoableEdit(where);
        undo.content = this;
        undo.data = new String(this.getArray(), this.gapEnd - nitems, nitems);
        undo.nitems = nitems;
        undo.isInsertion = false;
        return undo;
    }

    public UndoableEdit insertString(int where, String str, boolean beforeMarkers) throws BadLocationException {
        if (where < 0 || where > this.length()) {
            throw new BadLocationException("bad insert", where);
        }
        this.insert(where, str, beforeMarkers);
        GapUndoableEdit undo = new GapUndoableEdit(where);
        undo.content = this;
        undo.data = str;
        undo.nitems = str.length();
        undo.isInsertion = true;
        return undo;
    }

    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        return this.insertString(where, str, false);
    }

    public Position createPosition(int offset) throws BadLocationException {
        boolean isAfter;
        boolean bl = isAfter = offset != 0;
        if (offset < 0 || offset > this.length()) {
            throw new BadLocationException("bad offset to createPosition", offset);
        }
        return new GapPosition(this, offset, isAfter);
    }

    public void dump() {
        System.err.println("Buffer Content dump.  size:" + this.size() + "  buffer:" + this.getArray().length);
        System.err.print("before gap: \"");
        System.err.print(new String(this.getArray(), 0, this.gapStart));
        System.err.println("\" (gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + ')');
        System.err.print("after gap: \"");
        System.err.print(new String(this.getArray(), this.gapEnd, this.getArray().length - this.gapEnd));
        System.err.println("\"");
        int poslen = this.positions == null ? 0 : this.positions.length;
        System.err.println("Positions (size: " + poslen + " free:" + this.free + "):");
        for (int i = 0; i < poslen; ++i) {
            int pos = this.positions[i];
            if (!(this.free == -2 ? pos != -2 : pos != 0)) continue;
            System.err.println("position#" + i + ": " + (pos >> 1) + " isAfter:" + (pos & 1));
        }
    }

    public static int indexOf(char[] buffer, int start, int limit, char ch) {
        for (int i = start; i < limit; ++i) {
            if (buffer[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] buffer, int start, int limit, char ch) {
        for (int i = start; i >= limit; --i) {
            if (buffer[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public final long scan(char target, int start, int end, int count, boolean allowQuit) {
        int limit;
        int n = limit = end > this.gapStart ? end + this.gapEnd - this.gapStart : end;
        if (start > this.gapStart) {
            start += this.gapEnd - this.gapStart;
        }
        if (count > 0) {
            while (start < limit && count > 0) {
                int i;
                if (start == this.gapStart) {
                    start = this.gapEnd;
                }
                int ceil = start < this.gapStart && limit > this.gapStart ? this.gapStart : limit;
                if (allowQuit) {
                    if (ceil - start > 5000) {
                        ceil = start + 5000;
                    }
                    Signal.checkQuit();
                }
                if ((i = BufferContent.indexOf(this.getArray(), start, ceil, target)) >= 0) {
                    --count;
                    start = i + 1;
                    continue;
                }
                start = ceil;
            }
            if (start > this.gapEnd) {
                start -= this.gapEnd - this.gapStart;
            }
            return (long)count << 32 | (long)start;
        }
        while (start > limit && count < 0) {
            int i;
            if (start == this.gapEnd) {
                start = this.gapStart;
            }
            int floor = start <= this.gapStart || limit >= this.gapEnd ? limit : this.gapEnd;
            if (allowQuit) {
                if (start - floor > 5000) {
                    floor = start - 5000;
                }
                Signal.checkQuit();
            }
            if ((i = BufferContent.lastIndexOf(this.getArray(), start - 1, floor, target)) >= 0) {
                ++count;
                start = i;
                continue;
            }
            start = floor;
        }
        if (start >= this.gapEnd) {
            start -= this.gapEnd - this.gapStart;
        }
        if (count != 0) {
            return (long)(-count) << 32 | (long)start;
        }
        return start + 1;
    }
}

