/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.swing.BufferContent;
import gnu.jemacs.swing.SwingBuffer;
import gnu.mapping.InPort;
import gnu.text.NullReader;
import java.io.IOException;

public class MarkerReader
extends InPort {
    Marker marker;
    BufferContent content;

    public MarkerReader(Buffer buffer) {
        this(buffer, buffer.pointMarker);
    }

    public MarkerReader(Marker marker) {
        this(marker.getBuffer(), marker);
    }

    MarkerReader(Buffer buffer, Marker marker) {
        super(NullReader.nullReader, buffer.getName());
        this.marker = marker;
        this.content = ((SwingBuffer)buffer).content;
        this.buffer = this.content.getArray();
    }

    public int read() {
        int offset = this.marker.getOffset();
        this.buffer = this.content.getArray();
        if (offset >= this.content.gapStart) {
            offset += this.content.gapEnd - this.content.gapStart;
        }
        int length = this.buffer.length;
        this.pos = offset;
        if (offset >= length) {
            this.limit = offset;
            return -1;
        }
        char ch = this.buffer[this.pos];
        ++this.pos;
        this.limit = this.pos;
        return ch;
    }

    public int getLineNumber() {
        throw new Error("MarkerReader. getLineNumber - not implemented");
    }

    public int getColumnNumber() {
        throw new Error("MarkerReader,getColumnNumber - not implemented");
    }

    public void reset() throws IOException {
        throw new Error("MarkerReader.reset - not implemented");
    }
}

