/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.swing.BufferContent;
import gnu.jemacs.swing.BufferReader;
import gnu.lists.Consumer;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Segment;
import javax.swing.text.StringContent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class SwingBuffer
extends Buffer {
    public DefaultStyledDocument doc;
    public Caret curPosition = null;
    public BufferContent content;
    public StyledDocument modelineDocument;
    public static StyleContext styles = new StyleContext();
    public static Style defaultStyle = styles.addStyle("default", null);
    public Style inputStyle = defaultStyle;
    public static Style redStyle = styles.addStyle("red", null);
    static Style blueStyle = styles.addStyle("blue", null);

    public SwingBuffer(String name) {
        this(name, new BufferContent());
    }

    public SwingBuffer(String name, BufferContent content) {
        super(name);
        this.doc = new DefaultStyledDocument((AbstractDocument.Content)content, styles);
        this.content = content;
        this.pointMarker = new Marker(this, 0, true);
        this.markMarker = new Marker();
        this.modelineDocument = new DefaultStyledDocument((AbstractDocument.Content)new StringContent(), styles);
        this.doc.putProperty("i18n", Boolean.TRUE);
        this.redrawModeline();
    }

    public void removeRegion(int start, int end) throws BadLocationException {
        this.doc.remove(start, end - start);
    }

    public void removeAll() {
        try {
            this.doc.remove(0, this.maxDot());
        }
        catch (BadLocationException ex) {
            throw new WrappedException(ex);
        }
    }

    public void removeChar(int count) {
        this.remove(this.getDot(), count);
    }

    void remove(int point, int count) {
        try {
            if (count < 0) {
                if (point - (count = -count) < this.minDot()) {
                    Signal.signal("Beginning of buffer");
                }
                point -= count;
            } else if (point + count > this.maxDot()) {
                Signal.signal("End of buffer");
            }
            this.doc.remove(point, count);
            this.setDot(point);
        }
        catch (BadLocationException ex) {
            throw new Error("bad location: " + ex);
        }
    }

    public void removePos(int ipos, int count) {
        this.remove(this.nextIndex(ipos), count);
    }

    public void save(Writer out) throws Exception {
        int count;
        int length;
        int todo = length = this.getLength();
        Segment segment = new Segment();
        for (int offset = 0; offset < length; offset += count) {
            count = length;
            if (count > 4096) {
                count = 4096;
            }
            this.doc.getText(offset, count, segment);
            out.write(segment.array, segment.offset, segment.count);
        }
    }

    public void insert(char ch, int count) {
        this.pointMarker.insert(ch, count, this.inputStyle);
    }

    public void insert(int index, String string, Object style) {
        if (style == null) {
            style = defaultStyle;
        }
        try {
            this.doc.insertString(index, string, (Style)style);
        }
        catch (BadLocationException ex) {
            throw new Error("bad location: " + ex);
        }
    }

    public void insert(String string, Object style) {
        this.insert(this.getDot(), string, style);
    }

    public void insert(String string, Object style, int ipos) {
        this.insert(this.nextIndex(ipos), string, style);
    }

    public void insertFile(Reader in) throws Exception {
        int count;
        char[] buffer = new char[2048];
        int offset = this.getDot();
        while ((count = in.read(buffer, 0, buffer.length)) > 0) {
            this.doc.insertString(offset, new String(buffer, 0, count), null);
            offset += count;
        }
    }

    public void redrawModeline() {
        try {
            this.modelineDocument.remove(0, this.modelineDocument.getLength());
            this.modelineDocument.insertString(0, "-----", redStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), "JEmacs: " + this.getName(), blueStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), " ---", redStyle);
        }
        catch (BadLocationException ex) {
            throw new Error("internal error in redraw-modeline- " + ex);
        }
    }

    public long scan(char target, int start, int end, int count, boolean allowQuit) {
        if (end == 0) {
            end = count > 0 ? this.content.length() - 1 : 0;
        }
        return this.content.scan(target, start, end, count, allowQuit);
    }

    public int lineStartOffset(int offset) {
        return (int)this.content.scan('\n', offset, this.minDot(), -1, true);
    }

    public int getDot() {
        if (this.pointMarker.sequence == null) {
            return this.curPosition.getDot();
        }
        return this.pointMarker.getOffset();
    }

    public void setDot(int i) {
        if (i > this.maxDot()) {
            throw new Error("set dot to " + i + " max:" + this.maxDot());
        }
        if (this.pointMarker.sequence == null) {
            this.curPosition.setDot(i);
        } else {
            this.pointMarker.set(this, i);
        }
    }

    public int maxDot() {
        return this.content.length() - 1;
    }

    public int getLength() {
        return this.doc.getLength();
    }

    public char charAt(int index) {
        return this.content.charAt(index);
    }

    public void setCharAt(int index, char ch) {
        this.content.setCharAt(index, ch);
    }

    public void fill(char value) {
        this.content.fill(value);
    }

    public void fill(int fromIndex, int toIndex, char value) {
        this.content.fill(fromIndex, toIndex, value);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.content.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public void writeTo(int start, int count, Writer dest) throws IOException {
        this.content.writeTo(start, count, dest);
    }

    public void consume(int start, int count, Consumer out) {
        this.content.consume(start, count, out);
    }

    public int createPos(int index, boolean isAfter) {
        return this.content.createPos(index, isAfter);
    }

    public Object get(int index) {
        return this.content.get(index);
    }

    public int size() {
        return this.content.size();
    }

    public int nextIndex(int ipos) {
        return this.content.nextIndex(ipos);
    }

    public long savePointMark() {
        int pointPosition = this.content.createPos(this.getDot(), false);
        int markPosition = 0;
        return (long)markPosition << 32 | (long)pointPosition & 0xFFFFFFFFL;
    }

    public void restorePointMark(long pointMark) {
        int pointPosition = (int)pointMark;
        int markPosition = (int)(pointMark >> 32);
        this.setDot(this.content.nextIndex(pointPosition));
        this.content.releasePos(pointPosition);
    }

    public InPort openReader(int start, int count) {
        return new BufferReader(this, start, count);
    }

    static {
        String version = System.getProperty("java.version");
        if (version != null && (version.startsWith("1.2") || version.startsWith("1.3"))) {
            StyleConstants.setFontFamily(defaultStyle, "Lucida Sans TypeWriter");
            StyleConstants.setFontSize(defaultStyle, 14);
        }
        StyleConstants.setForeground(redStyle, Color.red);
        StyleConstants.setForeground(blueStyle, Color.blue);
    }
}

