/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.sax;

import gnu.lists.Consumer;
import gnu.mapping.Symbol;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ConsumeSAXHandler
implements DocumentHandler,
ContentHandler {
    Consumer out;

    public void setDocumentLocator(Locator locator) {
    }

    public ConsumeSAXHandler(Consumer out) {
        this.out = out;
    }

    public void startDocument() {
        this.out.beginDocument();
    }

    public void endDocument() {
        this.out.endDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.out.beginGroup(qName, Symbol.make(namespaceURI, localName));
        int numAttributes = atts.getLength();
        for (int i = 0; i < numAttributes; ++i) {
            this.out.beginAttribute(atts.getQName(i), Symbol.make(atts.getURI(i), atts.getLocalName(i)));
            this.out.writeChars(atts.getValue(i));
            this.out.endAttribute();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.out.endGroup(qName);
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        name = name.intern();
        this.out.beginGroup(name, name);
        int attrLength = atts.getLength();
        for (int i = 0; i < attrLength; ++i) {
            name = atts.getName(i);
            name = name.intern();
            String type = atts.getType(i);
            String value = atts.getValue(i);
            this.out.beginAttribute(name, name);
            this.out.writeChars(value);
            this.out.endAttribute();
        }
    }

    public void endElement(String name) throws SAXException {
        name = name.intern();
        this.out.endGroup(name);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.out.write(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.out.write(ch, start, length);
    }

    public void processingInstruction(String target, String data) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
    }
}

