/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import gnu.mapping.Procedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.Translator;

public class Macro
extends Syntax
implements Printable,
Externalizable {
    public Object expander;
    Vector capturedIdentifiers;
    String capturedFields;
    String[] templateIdentifiers;
    Declaration[] capturedDeclarations;

    public static Macro make(Declaration declaration) {
        Macro macro = new Macro(declaration.getSymbol());
        macro.capturedIdentifiers = new Vector();
        macro.bind(declaration);
        return macro;
    }

    public static Macro make(Object object2, Procedure procedure) {
        Macro macro = new Macro(object2, procedure);
        return macro;
    }

    public static Macro make(Object object2, Procedure procedure, String[] stringArray, String string) {
        Macro macro = new Macro(object2, procedure);
        macro.templateIdentifiers = stringArray;
        macro.capturedFields = string;
        return macro;
    }

    public void captureDecls(Hashtable hashtable) {
        if (this.capturedFields == null) {
            return;
        }
        int n = 0;
        int n2 = this.capturedFields.length();
        while (--n2 >= 0) {
            if (this.capturedFields.charAt(n2) != ';') continue;
            ++n;
        }
        Declaration[] declarationArray = new Declaration[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = this.capturedFields.indexOf(59, n3);
            if (n4 > n3) {
                String string = this.capturedFields.substring(n3, n4);
                declarationArray[i] = (Declaration)hashtable.get(string);
            }
            n3 = n4 + 1;
        }
        this.capturedDeclarations = declarationArray;
    }

    public void bind(Declaration declaration) {
        declaration.setSimple(false);
        declaration.setFlag(49152);
        declaration.noteValue(new QuoteExp(this));
    }

    public void setExpander(Procedure procedure) {
        this.expander = new QuoteExp(procedure);
    }

    public Macro() {
    }

    public Macro(Macro macro) {
        this.name = macro.name;
        this.expander = macro.expander;
        this.capturedIdentifiers = macro.capturedIdentifiers;
        this.templateIdentifiers = macro.templateIdentifiers;
        this.capturedFields = macro.capturedFields;
    }

    public Macro(Object object2, Procedure procedure) {
        super(object2);
        this.expander = new QuoteExp(procedure);
    }

    public Macro(Object object2, Expression expression) {
        super(object2);
        this.expander = expression;
    }

    public Macro(Object object2) {
        super(object2);
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        return translator.rewrite(this.expand(pair, translator));
    }

    public String toString() {
        return "#<macro " + this.getName() + '>';
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<macro ");
        printWriter.print(this.getName());
        printWriter.print('>');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object expand(Pair pair, Translator translator) {
        try {
            Object object2;
            Procedure procedure;
            Object object3 = this.expander;
            if (object3 instanceof Procedure) {
                procedure = (Procedure)object3;
            } else {
                if (!(object3 instanceof Expression)) {
                    object2 = translator.currentMacroDefinition;
                    translator.currentMacroDefinition = this;
                    try {
                        this.expander = object3 = translator.rewrite(object3);
                    }
                    finally {
                        translator.currentMacroDefinition = object2;
                    }
                }
                procedure = (Procedure)((Expression)object3).eval(translator.getGlobalEnvironment());
            }
            object2 = new SyntaxForm();
            ((SyntaxForm)object2).form = pair;
            ((SyntaxForm)object2).tr = translator;
            Object object4 = procedure.apply1(object2);
            return object4;
        }
        catch (Throwable throwable) {
            return translator.syntaxError("evaluating syntax transformer '" + this.getName() + "' threw " + throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        String string = translator.getFile();
        int n = translator.getLine();
        int n2 = translator.getColumn();
        Syntax syntax2 = translator.currentSyntax;
        try {
            translator.setLine(pair);
            translator.currentSyntax = this;
            boolean bl = translator.scan_form(this.expand(pair, translator), vector, scopeExp);
            return bl;
        }
        finally {
            translator.setLine(string, n, n2);
            translator.currentSyntax = syntax2;
        }
    }

    private static String getUsedFieldsList(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof Declaration) {
                    Declaration declaration = (Declaration)object2;
                    if (declaration.field != null && !declaration.getFlag(65536)) {
                        stringBuffer.append(declaration.field.getName());
                    }
                }
                stringBuffer.append(';');
            }
        }
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(((QuoteExp)this.expander).getValue());
        objectOutput.writeObject(this.templateIdentifiers);
        objectOutput.writeObject(Macro.getUsedFieldsList(this.capturedDeclarations));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.expander = new QuoteExp(objectInput.readObject());
        this.templateIdentifiers = (String[])objectInput.readObject();
        this.capturedFields = (String)objectInput.readObject();
    }
}

