/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.glj.lisp;

import gnu.expr.Language;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.InPort;
import gnu.text.LineBufferedReader;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import kawa.standard.Scheme;

public class Lisp {
    public static final Object nil = LList.Empty;

    public static LList read(Reader reader) throws IOException, SyntaxException {
        if (reader == null) {
            return (LList)nil;
        }
        InPort port = new InPort(reader);
        return Lisp.read(port);
    }

    public static LList read(InputStream stream) throws IOException, SyntaxException {
        if (stream == null) {
            return (LList)nil;
        }
        InPort port = new InPort(stream);
        return Lisp.read(port);
    }

    static LList read(InPort port) throws IOException, SyntaxException {
        Object obj = null;
        Language.setDefaultLanguage((Language)new Scheme());
        LispReader lispReader = new LispReader((LineBufferedReader)port);
        obj = lispReader.readObject();
        return (LList)obj;
    }

    public static boolean isAtom(Object obj) {
        return !(obj instanceof Pair);
    }

    public static boolean isList(Object obj) {
        return obj instanceof LList;
    }

    public static boolean isNil(Object obj) {
        return obj instanceof LList && ((LList)obj).isEmpty();
    }

    public static boolean isPair(Object obj) {
        return Lisp.isList(obj) && !Lisp.isNil(obj);
    }

    public static Object car(Object list) {
        if (list instanceof Pair) {
            Object obj = ((Pair)list).car;
            if (obj.equals("NIL")) {
                return (LList)nil;
            }
            return ((Pair)list).car;
        }
        return (LList)nil;
    }

    public static Object cdr(Object list) {
        if (list instanceof Pair) {
            return ((Pair)list).cdr;
        }
        return (LList)nil;
    }

    public static Pair cons(Object car, Object cdr) {
        return new Pair(car, cdr);
    }

    public static Pair list(Object car, Object cadr) {
        return new Pair(car, (Object)new Pair(cadr, (Object)LList.Empty));
    }

    public static LList remove(Object obj, LList list) {
        if (list.isEmpty()) {
            return list;
        }
        if (obj.equals(((Pair)list).car)) {
            return Lisp.remove(obj, (LList)Lisp.cdr(list));
        }
        return new Pair(Lisp.car(list), (Object)Lisp.remove(obj, (LList)Lisp.cdr(list)));
    }

    public static LList merge(LList list1, LList list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        return Lisp.merge((LList)Lisp.cdr(list1), Lisp.insert(Lisp.car(list1), list2));
    }

    public static LList insert(Object obj, LList list) {
        if (list.contains(obj)) {
            return list;
        }
        return new Pair(obj, (Object)list);
    }

    public static LList append(LList list1, LList list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        LList revList = Lisp.reverse(list1);
        for (int i = 0; i < list2.size(); ++i) {
            revList = new Pair(list2.get(i), (Object)revList);
        }
        return Lisp.reverse(revList);
    }

    public static LList reverse(LList list) {
        if (list.isEmpty()) {
            return list;
        }
        LList retList = LList.Empty;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            retList = new Pair(list.get(i), (Object)retList);
        }
        return retList;
    }

    public static LList assoc(Object obj, LList list) {
        if (list == null || list.isEmpty()) {
            return (LList)nil;
        }
        for (int i = 0; i < ((Pair)list).size(); ++i) {
            Object part = list.get(i);
            if (!(part instanceof Pair)) {
                return (LList)nil;
            }
            if (!obj.equals(Lisp.car(part))) continue;
            return (LList)part;
        }
        return (LList)nil;
    }

    public static LList member(Object obj, LList list) {
        if (list == null || list.isEmpty()) {
            return (LList)nil;
        }
        if (Lisp.car(list).equals(obj)) {
            return list;
        }
        list = (LList)Lisp.cdr(list);
        while (list instanceof Pair) {
            if (Lisp.car(list).equals(obj)) {
                return list;
            }
            list = (LList)Lisp.cdr(list);
        }
        return (LList)nil;
    }

    public static LList subst(Object newObj, Object oldObj, LList list) {
        if (list.isEmpty()) {
            return list;
        }
        LList retList = LList.Empty;
        for (int i = 0; i < list.size(); ++i) {
            retList = ((Pair)list).get(i) instanceof LList ? Lisp.append(retList, (LList)new Pair((Object)Lisp.subst(newObj, oldObj, (LList)((Pair)list).get(i)), (Object)LList.Empty)) : (oldObj.equals(((Pair)list).get(i)) ? Lisp.append(retList, (LList)new Pair(newObj, (Object)LList.Empty)) : Lisp.append(retList, (LList)new Pair(((Pair)list).get(i), (Object)LList.Empty)));
        }
        return retList;
    }

    public static LList lastPair(LList list) {
        if (list.isEmpty()) {
            return list;
        }
        if (Lisp.isPair(Lisp.cdr(list))) {
            return Lisp.lastPair((LList)Lisp.cdr(list));
        }
        return list;
    }

    public static Object nthCdr(int count, Object list) {
        if (!Lisp.isList(list)) {
            return list;
        }
        for (int i = 0; i < count; ++i) {
            if (Lisp.isNil(list)) {
                return list;
            }
            list = Lisp.cdr(list);
        }
        return list;
    }
}

