/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.i18n.text.converter.CharsetMeta;

public class CharConvRepackage {
    private static final String M_COMMAND = "-custom-charsets-jar";
    private static final String M_CHARSET = "-charset";
    private static final String M_DEFAULT_JAR_NAME = "jdbc_orai18n_cs.jar";
    private static final String M_RESERVED_NAME = "orai18n";
    private static final String[] GDK_JDBC_PACKAGE_CLASS = new String[]{"oracle/i18n/text/converter/CharacterConverterOGS.class", "oracle/i18n/text/converter/CharacterConverter12Byte.class", "oracle/i18n/text/converter/CharacterConverter1Byte.class", "oracle/i18n/text/converter/CharacterConverterGB18030.class", "oracle/i18n/text/converter/CharacterConverterJAEUC.class", "oracle/i18n/text/converter/CharacterConverterLC.class", "oracle/i18n/text/converter/CharacterConverterSJIS.class", "oracle/i18n/text/converter/CharacterConverterShift.class", "oracle/i18n/text/converter/CharacterConverterZHTEUC.class", "oracle/i18n/text/converter/Messages.class", "oracle/i18n/text/converter/GDKMessage.class", "oracle/i18n/util/GDKOracleMetaData.class", "oracle/sql/converter/CharacterConverters.class"};
    private static final Set UNICODE_CHARSETS = new HashSet();
    static /* synthetic */ Class class$oracle$i18n$util$CharConvRepackage;

    public static final String getCommand() {
        return M_COMMAND;
    }

    public static void printUsage() {
        System.out.println("  -custom-charsets-jar <jar/zip file name> -charset <character set name> [<character set name> ...] : Generates a custom character set jar/zip file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(List list) throws Exception {
        File file;
        Object object;
        if (list.size() < 2) {
            CharConvRepackage.printUsage();
            return;
        }
        Class clazz = class$oracle$i18n$util$CharConvRepackage == null ? (class$oracle$i18n$util$CharConvRepackage = CharConvRepackage.class$("oracle.i18n.util.CharConvRepackage")) : class$oracle$i18n$util$CharConvRepackage;
        for (int i = 0; i < GDK_JDBC_PACKAGE_CLASS.length; ++i) {
            object = clazz.getResourceAsStream("/" + GDK_JDBC_PACKAGE_CLASS[i]);
            if (object != null) continue;
            new ClassNotFoundException("/" + GDK_JDBC_PACKAGE_CLASS[i]);
        }
        object = (String)list.get(0);
        if (M_CHARSET.equals(object)) {
            file = new File(M_DEFAULT_JAR_NAME);
        } else {
            file = new File((String)object);
            if (file.getName().startsWith(M_RESERVED_NAME)) {
                throw new IllegalArgumentException("You cannot specify the name for jar/zip file: " + file.getName());
            }
            list.remove(0);
            if (!M_CHARSET.equals(list.get(0))) {
                CharConvRepackage.printUsage();
                return;
            }
        }
        list.remove(0);
        File file2 = File.createTempFile("gdk", null);
        file2.deleteOnExit();
        FileOutputStream fileOutputStream = null;
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n;
            fileOutputStream = new FileOutputStream(file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (n = 0; n < list.size(); ++n) {
                object5 = ((String)list.get(n)).toUpperCase(Locale.US);
                if (UNICODE_CHARSETS.contains(object5)) {
                    System.out.println("Added       Character set : " + (String)object5);
                    continue;
                }
                object4 = CharsetMeta.getInstance();
                object3 = ((CharsetMeta)object4).getCharSetId((String)object5);
                if (object3 == null) {
                    throw new UnsupportedEncodingException((String)object5);
                }
                String string = Integer.toHexString(Integer.parseInt((String)object3));
                object2 = "lx2" + ("0000" + string).substring(string.length());
                String string2 = "oracle/i18n/data/" + (String)object2 + ".glb";
                InputStream inputStream = clazz.getResourceAsStream("/" + string2);
                if (inputStream == null) {
                    throw new UnsupportedEncodingException((String)object5);
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object object6 = objectInputStream.readObject();
                objectInputStream.close();
                inputStream.close();
                ZipEntry zipEntry = new ZipEntry(string2);
                zipOutputStream.putNextEntry(zipEntry);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
                objectOutputStream.writeObject(object6);
                System.out.println("Added       Character set : " + (String)object5);
            }
            for (n = 0; n < GDK_JDBC_PACKAGE_CLASS.length; ++n) {
                object5 = new ZipEntry(GDK_JDBC_PACKAGE_CLASS[n]);
                zipOutputStream.putNextEntry((ZipEntry)object5);
                object4 = clazz.getResourceAsStream("/" + GDK_JDBC_PACKAGE_CLASS[n]);
                CharConvRepackage.copyFile((InputStream)object4, zipOutputStream);
                ((InputStream)object4).close();
            }
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            zipOutputStream.putNextEntry(zipEntry);
            object5 = clazz.getResourceAsStream("/oracle/i18n/util/manifest.tmp");
            CharConvRepackage.copyFile((InputStream)object5, zipOutputStream);
            ((InputStream)object5).close();
            object4 = new ByteArrayOutputStream();
            object3 = new OutputStreamWriter((OutputStream)object4, "iso-8859-1");
            ((Writer)object3).write("\n");
            ((Writer)object3).write("This custom character set jar/zip file was created with the following command:\n");
            ((Writer)object3).write("java -jar orai18n.jar -custom-charsets-jar " + file.getName() + " " + M_CHARSET);
            for (int i = 0; i < list.size(); ++i) {
                object2 = ((String)list.get(i)).toUpperCase(Locale.US);
                ((Writer)object3).write(" ");
                ((Writer)object3).write((String)object2);
            }
            ((Writer)object3).write("\n");
            ((OutputStreamWriter)object3).close();
            ((ByteArrayOutputStream)object4).close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object4).toByteArray());
            zipEntry = new ZipEntry("oracle/i18n/readme.txt");
            zipOutputStream.putNextEntry(zipEntry);
            CharConvRepackage.copyFile(byteArrayInputStream, zipOutputStream);
            byteArrayInputStream.close();
            zipOutputStream.close();
            fileOutputStream.close();
            fileOutputStream = null;
            if (!file2.renameTo(file)) {
                object2 = new FileInputStream(file2);
                fileOutputStream = new FileOutputStream(file);
                CharConvRepackage.copyFile((InputStream)object2, fileOutputStream);
                fileOutputStream.close();
                fileOutputStream = null;
                ((FileInputStream)object2).close();
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private static final void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        UNICODE_CHARSETS.add("AL16UTF16");
        UNICODE_CHARSETS.add("AL16UTF16LE");
        UNICODE_CHARSETS.add("AL32UTF8");
        UNICODE_CHARSETS.add("UTF8");
        UNICODE_CHARSETS.add("UTFE");
        UNICODE_CHARSETS.add("AL24UTFFSS");
    }
}

