/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2.msgs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jms.Destination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.il.uil2.msgs.BaseMsg;

public class BrowseMsg
extends BaseMsg {
    private Destination dest;
    private String selector;
    private SpyMessage[] msgs;

    public BrowseMsg() {
        this(null, null);
    }

    public BrowseMsg(Destination dest, String selector) {
        super(3);
        this.dest = dest;
        this.selector = selector;
    }

    public Destination getDest() {
        return this.dest;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setMessages(SpyMessage[] msgs) {
        this.msgs = msgs;
    }

    public SpyMessage[] getMessages() {
        return this.msgs;
    }

    public void write(ObjectOutputStream out) throws IOException {
        super.write(out);
        out.writeObject(this.dest);
        out.writeObject(this.selector);
        int hasMessages = this.msgs != null ? 1 : 0;
        out.writeByte(hasMessages);
        if (hasMessages == 1) {
            out.writeObject(this.msgs);
        }
    }

    public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        this.dest = (Destination)in.readObject();
        this.selector = (String)in.readObject();
        byte hasMessages = in.readByte();
        if (hasMessages == 1) {
            this.msgs = (SpyMessage[])in.readObject();
        }
    }
}

