/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import org.apache.log4j.Logger;

public class HashStringUtil {
    private static final Logger log = Logger.getLogger(HashStringUtil.class);
    private static final boolean isDebug = log.isDebugEnabled();

    public static long hashName(String name) {
        try {
            long hash = 0L;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
            MessageDigest messagedigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
            dataoutputstream.writeUTF(name);
            dataoutputstream.flush();
            byte[] abyte0 = messagedigest.digest();
            for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
                hash += (long)(abyte0[j] & 0xFF) << j * 8;
            }
            if (isDebug) {
                log.debug("hash on field " + name + " = " + hash);
            }
            return hash;
        }
        catch (Exception e) {
            RuntimeException rte = new RuntimeException(e);
            throw rte;
        }
    }
}

