/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import [Ljava.lang.String;;
import org.jboss.util.CoercionException;
import org.jboss.util.Objects;
import org.jboss.util.property.FilePropertyReader;
import org.jboss.util.property.PropertyException;
import org.jboss.util.property.PropertyManager;

public final class DefaultPropertyReader
extends FilePropertyReader {
    public static final String DEFAULT_PROPERTY_NAME = "properties";

    public DefaultPropertyReader(String propertyName) {
        super(DefaultPropertyReader.getFilenames(propertyName));
    }

    public DefaultPropertyReader() {
        this(DEFAULT_PROPERTY_NAME);
    }

    public static String[] getFilenames(String propertyName) throws PropertyException {
        String[] filenames;
        String filename = PropertyManager.getProperty(propertyName);
        if (filename != null) {
            filenames = new String[]{String.valueOf(filename)};
        } else {
            Object[] values = PropertyManager.getArrayProperty(propertyName);
            try {
                filenames = (String[])Objects.coerce(values, String;.class);
            }
            catch (CoercionException e) {
                throw new PropertyException(e);
            }
        }
        return filenames;
    }
}

