/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Field {
    public static final int TEXT_FORMAT = 0;
    public static final int BINARY_FORMAT = 1;
    private final int length;
    private final int oid;
    private final int mod;
    private final String columnLabel;
    private String columnName;
    private Integer nullable;
    private Boolean autoIncrement;
    private int format = 0;
    private final int tableOid;
    private final int positionInTable;

    public Field(String name, int oid, int length, int mod) {
        this(name, name, oid, length, mod, 0, 0);
    }

    public Field(String name, int oid, int length) {
        this(name, name, oid, length, 0, 0, 0);
    }

    public Field(String columnLabel, String columnName, int oid, int length, int mod, int tableOid, int positionInTable) {
        this.columnLabel = columnLabel;
        this.columnName = columnName;
        this.oid = oid;
        this.length = length;
        this.mod = mod;
        this.tableOid = tableOid;
        this.positionInTable = positionInTable;
    }

    public int getOID() {
        return this.oid;
    }

    public int getMod() {
        return this.mod;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public int getLength() {
        return this.length;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getTableOid() {
        return this.tableOid;
    }

    public int getPositionInTable() {
        return this.positionInTable;
    }

    public int getNullable(Connection con) throws SQLException {
        int n;
        PreparedStatement ps;
        block7: {
            if (this.nullable != null) {
                return this.nullable;
            }
            if (this.tableOid == 0 || this.positionInTable == 0) {
                this.nullable = new Integer(2);
                return this.nullable;
            }
            ResultSet res = null;
            ps = null;
            try {
                ps = con.prepareStatement("SELECT attnotnull FROM pg_catalog.pg_attribute WHERE attrelid = ? AND attnum = ?;");
                ps.setInt(1, this.tableOid);
                ps.setInt(2, this.positionInTable);
                res = ps.executeQuery();
                int nullResult = 2;
                if (res.next()) {
                    nullResult = res.getBoolean(1) ? 0 : 1;
                }
                this.nullable = new Integer(nullResult);
                n = nullResult;
                Object var5_6 = null;
                if (res == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var5_7 = null;
                    if (res != null) {
                        res.close();
                    }
                    if (ps == null) break block8;
                    ps.close();
                }
                throw throwable;
            }
            res.close();
        }
        if (ps != null) {
            ps.close();
        }
        return n;
    }

    public boolean getAutoIncrement(Connection con) throws SQLException {
        boolean bl;
        PreparedStatement ps;
        block6: {
            if (this.autoIncrement != null) {
                return this.autoIncrement;
            }
            if (this.tableOid == 0 || this.positionInTable == 0) {
                this.autoIncrement = Boolean.FALSE;
                return this.autoIncrement;
            }
            ResultSet res = null;
            ps = null;
            try {
                ps = con.prepareStatement("SELECT def.adsrc FROM pg_catalog.pg_class c JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid) LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum) WHERE c.oid = ? and a.attnum = ? AND def.adsrc LIKE '%nextval(%'");
                ps.setInt(1, this.tableOid);
                ps.setInt(2, this.positionInTable);
                res = ps.executeQuery();
                this.autoIncrement = res.next() ? Boolean.TRUE : Boolean.FALSE;
                bl = this.autoIncrement;
                Object var4_5 = null;
                if (res == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_6 = null;
                    if (res != null) {
                        res.close();
                    }
                    if (ps == null) break block7;
                    ps.close();
                }
                throw throwable;
            }
            res.close();
        }
        if (ps != null) {
            ps.close();
        }
        return bl;
    }

    public String getColumnName(Connection con) throws SQLException {
        String string;
        PreparedStatement ps;
        block7: {
            if (this.columnName != null) {
                return this.columnName;
            }
            this.columnName = "";
            if (this.tableOid == 0 || this.positionInTable == 0) {
                return this.columnName;
            }
            ResultSet res = null;
            ps = null;
            try {
                ps = con.prepareStatement("SELECT attname FROM pg_catalog.pg_attribute WHERE attrelid = ? AND attnum = ?");
                ps.setInt(1, this.tableOid);
                ps.setInt(2, this.positionInTable);
                res = ps.executeQuery();
                if (res.next()) {
                    this.columnName = res.getString(1);
                }
                string = this.columnName;
                Object var4_5 = null;
                if (res == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var4_6 = null;
                    if (res != null) {
                        res.close();
                    }
                    if (ps == null) break block8;
                    ps.close();
                }
                throw throwable;
            }
            res.close();
        }
        if (ps != null) {
            ps.close();
        }
        return string;
    }
}

