/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import sun.tools.asm.Assembler;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.Type;
import sun.tools.javac.SourceMember;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.Node;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class MemberDefinition
implements Constants {
    protected long where;
    protected int modifiers;
    protected Type type;
    protected String documentation;
    protected IdentifierToken[] expIds;
    protected ClassDeclaration[] exp;
    protected Node value;
    protected ClassDefinition clazz;
    protected Identifier name;
    protected ClassDefinition innerClass;
    protected MemberDefinition nextMember;
    protected MemberDefinition nextMatch;
    protected MemberDefinition accessPeer;
    protected boolean superAccessMethod;
    private static Map proxyCache;
    static final int PUBLIC_ACCESS = 1;
    static final int PROTECTED_ACCESS = 2;
    static final int PACKAGE_ACCESS = 3;
    static final int PRIVATE_ACCESS = 4;

    public MemberDefinition(long l, ClassDefinition classDefinition, int n, Type type, Identifier identifier, IdentifierToken[] identifierTokenArray, Node node) {
        if (identifierTokenArray == null) {
            identifierTokenArray = new IdentifierToken[]{};
        }
        this.where = l;
        this.clazz = classDefinition;
        this.modifiers = n;
        this.type = type;
        this.name = identifier;
        this.expIds = identifierTokenArray;
        this.value = node;
    }

    public MemberDefinition(ClassDefinition classDefinition) {
        this(classDefinition.getWhere(), classDefinition.getOuterClass(), classDefinition.getModifiers(), classDefinition.getType(), classDefinition.getName().getFlatName().getName(), null, null);
        this.innerClass = classDefinition;
    }

    public static MemberDefinition makeProxyMember(MemberDefinition memberDefinition, ClassDefinition classDefinition, Environment environment) {
        String string;
        MemberDefinition memberDefinition2;
        if (proxyCache == null) {
            proxyCache = new HashMap();
        }
        if ((memberDefinition2 = (MemberDefinition)proxyCache.get(string = memberDefinition.toString() + "@" + classDefinition.toString())) != null) {
            return memberDefinition2;
        }
        memberDefinition2 = new MemberDefinition(memberDefinition.getWhere(), classDefinition, memberDefinition.getModifiers(), memberDefinition.getType(), memberDefinition.getName(), memberDefinition.getExceptionIds(), null);
        memberDefinition2.exp = memberDefinition.getExceptions(environment);
        proxyCache.put(string, memberDefinition2);
        return memberDefinition2;
    }

    public final long getWhere() {
        return this.where;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.clazz.getClassDeclaration();
    }

    public void resolveTypeStructure(Environment environment) {
    }

    public ClassDeclaration getDefiningClassDeclaration() {
        return this.getClassDeclaration();
    }

    public final ClassDefinition getClassDefinition() {
        return this.clazz;
    }

    public final ClassDefinition getTopClass() {
        return this.clazz.getTopClass();
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void subModifiers(int n) {
        this.modifiers &= ~n;
    }

    public final void addModifiers(int n) {
        this.modifiers |= n;
    }

    public final Type getType() {
        return this.type;
    }

    public final Identifier getName() {
        return this.name;
    }

    public Vector getArguments() {
        return this.isMethod() ? new Vector() : null;
    }

    public ClassDeclaration[] getExceptions(Environment environment) {
        if (this.expIds != null && this.exp == null) {
            if (this.expIds.length == 0) {
                this.exp = new ClassDeclaration[0];
            } else {
                throw new CompilerError("getExceptions " + this);
            }
        }
        return this.exp;
    }

    public final IdentifierToken[] getExceptionIds() {
        return this.expIds;
    }

    public ClassDefinition getInnerClass() {
        return this.innerClass;
    }

    public boolean isUplevelValue() {
        if (!this.isSynthetic() || !this.isVariable() || this.isStatic()) {
            return false;
        }
        String string = this.name.toString();
        return string.startsWith("val$") || string.toString().startsWith("loc$") || string.toString().startsWith("this$");
    }

    public boolean isAccessMethod() {
        return this.isSynthetic() && this.isMethod() && this.accessPeer != null;
    }

    public MemberDefinition getAccessMethodTarget() {
        if (this.isAccessMethod()) {
            MemberDefinition memberDefinition = this.accessPeer;
            while (memberDefinition != null) {
                if (!memberDefinition.isAccessMethod()) {
                    return memberDefinition;
                }
                memberDefinition = memberDefinition.accessPeer;
            }
        }
        return null;
    }

    public void setAccessMethodTarget(MemberDefinition memberDefinition) {
        if (this.getAccessMethodTarget() != memberDefinition) {
            if (this.accessPeer != null || memberDefinition.accessPeer != null) {
                throw new CompilerError("accessPeer");
            }
            this.accessPeer = memberDefinition;
        }
    }

    public MemberDefinition getAccessUpdateMember() {
        if (this.isAccessMethod()) {
            MemberDefinition memberDefinition = this.accessPeer;
            while (memberDefinition != null) {
                if (memberDefinition.isAccessMethod()) {
                    return memberDefinition;
                }
                memberDefinition = memberDefinition.accessPeer;
            }
        }
        return null;
    }

    public void setAccessUpdateMember(MemberDefinition memberDefinition) {
        if (this.getAccessUpdateMember() != memberDefinition) {
            if (!this.isAccessMethod() || memberDefinition.getAccessMethodTarget() != this.getAccessMethodTarget()) {
                throw new CompilerError("accessPeer");
            }
            memberDefinition.accessPeer = this.accessPeer;
            this.accessPeer = memberDefinition;
        }
    }

    public final boolean isSuperAccessMethod() {
        return this.superAccessMethod;
    }

    public final void setIsSuperAccessMethod(boolean bl) {
        this.superAccessMethod = bl;
    }

    public final boolean isBlankFinal() {
        return this.isFinal() && !this.isSynthetic() && this.getValue() == null;
    }

    public boolean isNeverNull() {
        if (this.isUplevelValue()) {
            return !this.name.toString().startsWith("val$");
        }
        return false;
    }

    public Node getValue(Environment environment) throws ClassNotFound {
        return this.value;
    }

    public final Node getValue() {
        return this.value;
    }

    public final void setValue(Node node) {
        this.value = node;
    }

    public Object getInitialValue() {
        return null;
    }

    public final MemberDefinition getNextMember() {
        return this.nextMember;
    }

    public final MemberDefinition getNextMatch() {
        return this.nextMatch;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void check(Environment environment) throws ClassNotFound {
    }

    public Vset check(Environment environment, Context context, Vset vset) throws ClassNotFound {
        return vset;
    }

    public void code(Environment environment, Assembler assembler) throws ClassNotFound {
        throw new CompilerError("code");
    }

    public void codeInit(Environment environment, Context context, Assembler assembler) throws ClassNotFound {
        throw new CompilerError("codeInit");
    }

    public boolean reportDeprecated(Environment environment) {
        return this.isDeprecated() || this.clazz.reportDeprecated(environment);
    }

    public final boolean canReach(Environment environment, MemberDefinition memberDefinition) {
        if (memberDefinition.isLocal() || !memberDefinition.isVariable() || !this.isVariable() && !this.isInitializer()) {
            return true;
        }
        if (this.getClassDeclaration().equals(memberDefinition.getClassDeclaration()) && this.isStatic() == memberDefinition.isStatic()) {
            while ((memberDefinition = memberDefinition.getNextMember()) != null && memberDefinition != this) {
            }
            return memberDefinition != null;
        }
        return true;
    }

    private int getAccessLevel() {
        if (this.isPublic()) {
            return 1;
        }
        if (this.isProtected()) {
            return 2;
        }
        if (this.isPackagePrivate()) {
            return 3;
        }
        if (this.isPrivate()) {
            return 4;
        }
        throw new CompilerError("getAccessLevel()");
    }

    private void reportError(Environment environment, String string, ClassDeclaration classDeclaration, MemberDefinition memberDefinition) {
        if (classDeclaration == null) {
            environment.error(this.getWhere(), string, this, this.getClassDeclaration(), memberDefinition.getClassDeclaration());
        } else {
            environment.error(classDeclaration.getClassDefinition().getWhere(), string, this, this.getClassDeclaration(), memberDefinition.getClassDeclaration());
        }
    }

    public boolean sameReturnType(MemberDefinition memberDefinition) {
        Type type;
        if (!this.isMethod() || !memberDefinition.isMethod()) {
            throw new CompilerError("sameReturnType: not method");
        }
        Type type2 = this.getType().getReturnType();
        return type2 == (type = memberDefinition.getType().getReturnType());
    }

    public boolean checkOverride(Environment environment, MemberDefinition memberDefinition) {
        return this.checkOverride(environment, memberDefinition, null);
    }

    private boolean checkOverride(Environment environment, MemberDefinition memberDefinition, ClassDeclaration classDeclaration) {
        boolean bl = true;
        if (!this.isMethod()) {
            throw new CompilerError("checkOverride(), expected method");
        }
        if (this.isSynthetic()) {
            if (memberDefinition.isFinal() || memberDefinition.isConstructor() || memberDefinition.isStatic() || !this.isStatic()) {
                // empty if block
            }
            return true;
        }
        if (this.getName() != memberDefinition.getName() || !this.getType().equalArguments(memberDefinition.getType())) {
            throw new CompilerError("checkOverride(), signature mismatch");
        }
        if (memberDefinition.isStatic() && !this.isStatic()) {
            this.reportError(environment, "override.static.with.instance", classDeclaration, memberDefinition);
            bl = false;
        }
        if (!memberDefinition.isStatic() && this.isStatic()) {
            this.reportError(environment, "hide.instance.with.static", classDeclaration, memberDefinition);
            bl = false;
        }
        if (memberDefinition.isFinal()) {
            this.reportError(environment, "override.final.method", classDeclaration, memberDefinition);
            bl = false;
        }
        if (memberDefinition.reportDeprecated(environment) && !this.isDeprecated() && this instanceof SourceMember) {
            this.reportError(environment, "warn.override.is.deprecated", classDeclaration, memberDefinition);
        }
        if (this.getAccessLevel() > memberDefinition.getAccessLevel()) {
            this.reportError(environment, "override.more.restrictive", classDeclaration, memberDefinition);
            bl = false;
        }
        if (!this.sameReturnType(memberDefinition)) {
            // empty if block
        }
        if (!this.exceptionsFit(environment, memberDefinition)) {
            this.reportError(environment, "override.incompatible.exceptions", classDeclaration, memberDefinition);
            bl = false;
        }
        return bl;
    }

    public boolean checkMeet(Environment environment, MemberDefinition memberDefinition, ClassDeclaration classDeclaration) {
        if (!this.isMethod()) {
            throw new CompilerError("checkMeet(), expected method");
        }
        if (!this.isAbstract() && !memberDefinition.isAbstract()) {
            throw new CompilerError("checkMeet(), no abstract method");
        }
        if (!this.isAbstract()) {
            return this.checkOverride(environment, memberDefinition, classDeclaration);
        }
        if (!memberDefinition.isAbstract()) {
            return memberDefinition.checkOverride(environment, this, classDeclaration);
        }
        if (this.getName() != memberDefinition.getName() || !this.getType().equalArguments(memberDefinition.getType())) {
            throw new CompilerError("checkMeet(), signature mismatch");
        }
        if (!this.sameReturnType(memberDefinition)) {
            environment.error(classDeclaration.getClassDefinition().getWhere(), "meet.different.return", this, this.getClassDeclaration(), memberDefinition.getClassDeclaration());
            return false;
        }
        return true;
    }

    public boolean couldOverride(Environment environment, MemberDefinition memberDefinition) {
        if (!this.isMethod()) {
            throw new CompilerError("coulcOverride(), expected method");
        }
        if (!memberDefinition.isAbstract()) {
            return false;
        }
        if (this.getAccessLevel() > memberDefinition.getAccessLevel()) {
            return false;
        }
        return this.exceptionsFit(environment, memberDefinition);
    }

    private boolean exceptionsFit(Environment environment, MemberDefinition memberDefinition) {
        ClassDeclaration[] classDeclarationArray = this.getExceptions(environment);
        ClassDeclaration[] classDeclarationArray2 = memberDefinition.getExceptions(environment);
        block2: for (int i = 0; i < classDeclarationArray.length; ++i) {
            try {
                ClassDefinition classDefinition = classDeclarationArray[i].getClassDefinition(environment);
                for (int j = 0; j < classDeclarationArray2.length; ++j) {
                    if (classDefinition.subClassOf(environment, classDeclarationArray2[j])) continue block2;
                }
                if (classDefinition.subClassOf(environment, environment.getClassDeclaration(idJavaLangError)) || classDefinition.subClassOf(environment, environment.getClassDeclaration(idJavaLangRuntimeException))) continue;
                return false;
            }
            catch (ClassNotFound classNotFound) {
                environment.error(this.getWhere(), "class.not.found", classNotFound.name, memberDefinition.getClassDeclaration());
            }
        }
        return true;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isMethod() {
        return this.type.isType(12);
    }

    public final boolean isVariable() {
        return !this.type.isType(12) && this.innerClass == null;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x40000) != 0;
    }

    public final boolean isStrict() {
        return (this.modifiers & 0x200000) != 0;
    }

    public final boolean isInnerClass() {
        return this.innerClass != null;
    }

    public final boolean isInitializer() {
        return this.getName().equals(idClassInit);
    }

    public final boolean isConstructor() {
        return this.getName().equals(idInit);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isInlineable(Environment environment, boolean bl) throws ClassNotFound {
        return (this.isStatic() || this.isPrivate() || this.isFinal() || this.isConstructor() || bl) && !this.isSynchronized() && !this.isNative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConstant() {
        if (this.isFinal() && this.isVariable() && this.value != null) {
            try {
                this.modifiers &= 0xFFFFFFEF;
                boolean bl = ((Expression)this.value).isConstant();
                return bl;
            }
            finally {
                this.modifiers |= 0x10;
            }
        }
        return false;
    }

    public String toString() {
        Identifier identifier = this.getClassDefinition().getName();
        if (this.isInitializer()) {
            return this.isStatic() ? "static {}" : "instance {}";
        }
        if (this.isConstructor()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(identifier);
            stringBuffer.append('(');
            Type[] typeArray = this.getType().getArgumentTypes();
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeArray[i].toString());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.isInnerClass()) {
            return this.getInnerClass().toString();
        }
        return this.type.typeString(this.getName().toString());
    }

    public void print(PrintStream printStream) {
        if (this.isPublic()) {
            printStream.print("public ");
        }
        if (this.isPrivate()) {
            printStream.print("private ");
        }
        if (this.isProtected()) {
            printStream.print("protected ");
        }
        if (this.isFinal()) {
            printStream.print("final ");
        }
        if (this.isStatic()) {
            printStream.print("static ");
        }
        if (this.isSynchronized()) {
            printStream.print("synchronized ");
        }
        if (this.isAbstract()) {
            printStream.print("abstract ");
        }
        if (this.isNative()) {
            printStream.print("native ");
        }
        if (this.isVolatile()) {
            printStream.print("volatile ");
        }
        if (this.isTransient()) {
            printStream.print("transient ");
        }
        printStream.println(this.toString() + ";");
    }

    public void cleanup(Environment environment) {
        this.documentation = null;
        if (this.isMethod() && this.value != null) {
            int n = 0;
            if (this.isPrivate() || this.isInitializer()) {
                this.value = Statement.empty;
            } else {
                n = ((Statement)this.value).costInline(Statement.MAXINLINECOST, null, null);
                if (n >= Statement.MAXINLINECOST) {
                    this.value = Statement.empty;
                } else {
                    try {
                        if (!this.isInlineable(null, true)) {
                            this.value = Statement.empty;
                        }
                    }
                    catch (ClassNotFound classNotFound) {
                        // empty catch block
                    }
                }
            }
            if (this.value != Statement.empty && environment.dump()) {
                environment.output("[after cleanup of " + this.getName() + ", " + n + " expression cost units remain]");
            }
        } else if (this.isVariable() && (this.isPrivate() || !this.isFinal() || this.type.isType(9))) {
            this.value = null;
        }
    }
}

