/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.convert.BasicObjectConverter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.impl.PropertyDescriptorProperty;

public class BeanConverter
extends BasicObjectConverter
implements Converter {
    public Map getPropertyMapFromObject(Object example, boolean readRequired, boolean writeRequired) throws MarshallException {
        return this.getPropertyMapFromClass(example.getClass(), readRequired, writeRequired);
    }

    public Map getPropertyMapFromClass(Class type, boolean readRequired, boolean writeRequired) throws MarshallException {
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            HashMap<String, PropertyDescriptorProperty> properties = new HashMap<String, PropertyDescriptorProperty>();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                if (name.equals("class") || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && descriptor.getWriteMethod() == null) continue;
                properties.put(name, new PropertyDescriptorProperty(descriptor));
            }
            return properties;
        }
        catch (IntrospectionException ex) {
            throw new MarshallException(type, (Throwable)ex);
        }
    }

    protected TypeHintContext createTypeHintContext(InboundContext inctx, Property property) {
        return new TypeHintContext(this.converterManager, property.getSetter(), 0);
    }
}

